/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.experiment;

import com.intellij.completion.ml.experiment.ExperimentConfig;
import com.intellij.completion.ml.experiment.ExperimentGroupConfig;
import com.intellij.completion.ml.experiment.ExperimentInfo;
import com.intellij.completion.ml.experiment.ExperimentLanguageConfig;
import com.intellij.completion.ml.experiment.ExperimentStatus;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.util.ResourceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/completion/ml/experiment/ClientExperimentStatus;", "Lcom/intellij/completion/ml/experiment/ExperimentStatus;", "()V", "experimentConfig", "Lcom/intellij/completion/ml/experiment/ExperimentConfig;", "languageToGroup", "", "", "Lcom/intellij/completion/ml/experiment/ExperimentInfo;", "disable", "", "findMatchingLanguage", "language", "Lcom/intellij/lang/Language;", "forLanguage", "getBucketsMapping", "", "", "seed", "", "(Ljava/lang/Long;)Ljava/util/List;", "isDisabled", "", "setDisabled", "value", "Companion", "intellij.completionMlRanking"})
public final class ClientExperimentStatus
implements ExperimentStatus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExperimentConfig experimentConfig = Companion.loadExperimentInfo();
    @NotNull
    private final Map<String, ExperimentInfo> languageToGroup = new HashMap();
    @NotNull
    private static final String EXPERIMENT_DISABLED_PROPERTY_KEY = "ml.completion.experiment.disabled";

    public ClientExperimentStatus() {
        List<Integer> bucketsMapping = this.getBucketsMapping(this.experimentConfig.getSeed());
        EventLogConfiguration eventLogConfiguration = EventLogConfiguration.Companion.getInstance();
        for (ExperimentLanguageConfig languageSettings : this.experimentConfig.getLanguages()) {
            Object v0;
            block2: {
                int bucket = ((Number)bucketsMapping.get(eventLogConfiguration.getBucket())).intValue() % languageSettings.getExperimentBucketsCount();
                int groupNumber = languageSettings.getIncludeGroups().size() > bucket ? ((Number)languageSettings.getIncludeGroups().get(bucket)).intValue() : this.experimentConfig.getVersion();
                Iterable iterable = this.experimentConfig.getGroups();
                for (Object t : iterable) {
                    ExperimentGroupConfig it = (ExperimentGroupConfig)t;
                    boolean bl = false;
                    if (!(it.getNumber() == groupNumber)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            ExperimentGroupConfig group = v0;
            ExperimentInfo groupInfo = group == null ? new ExperimentInfo(false, this.experimentConfig.getVersion(), false, false, false, false, 60, null) : new ExperimentInfo(true, group.getNumber(), group.getUseMLRanking(), group.getShowArrows(), group.getCalculateFeatures(), languageSettings.getShouldLogElementFeatures());
            this.languageToGroup.put(languageSettings.getId(), groupInfo);
        }
    }

    @Override
    @NotNull
    public ExperimentInfo forLanguage(@NotNull Language language) {
        ExperimentInfo experimentInfo;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new ExperimentInfo(false, 0, false, false, false, false, 60, null);
        }
        String string = this.findMatchingLanguage(language);
        if (string == null) {
            return new ExperimentInfo(false, this.experimentConfig.getVersion(), false, false, false, false, 60, null);
        }
        String matchingLanguage = string;
        RegistryValue registryValue = Registry.get((String)"completion.ml.override.experiment.group.number");
        Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"get(\"completion.ml.overr\u2026experiment.group.number\")");
        RegistryValue experimentGroupRegistry = registryValue;
        if (experimentGroupRegistry.isChangedFromDefault()) {
            Object v2;
            block6: {
                Iterable iterable = this.experimentConfig.getGroups();
                for (Object t : iterable) {
                    ExperimentGroupConfig it = (ExperimentGroupConfig)t;
                    boolean bl = false;
                    if (!(it.getNumber() == experimentGroupRegistry.asInteger())) continue;
                    v2 = t;
                    break block6;
                }
                v2 = null;
            }
            ExperimentGroupConfig group = v2;
            if (group != null) {
                this.setDisabled(false);
                return new ExperimentInfo(true, group.getNumber(), group.getUseMLRanking(), group.getShowArrows(), group.getCalculateFeatures(), true);
            }
        }
        if ((experimentInfo = this.languageToGroup.get(matchingLanguage)) == null) {
            experimentInfo = new ExperimentInfo(false, this.experimentConfig.getVersion(), false, false, false, false, 60, null);
        }
        return experimentInfo;
    }

    @Override
    public void disable() {
        if (ApplicationManager.getApplication().isEAP()) {
            this.setDisabled(true);
        }
    }

    @Override
    public boolean isDisabled() {
        return PropertiesComponent.getInstance().isTrueValue(EXPERIMENT_DISABLED_PROPERTY_KEY);
    }

    private final void setDisabled(boolean value) {
        PropertiesComponent.getInstance().setValue(EXPERIMENT_DISABLED_PROPERTY_KEY, value);
    }

    /*
     * WARNING - void declaration
     */
    private final String findMatchingLanguage(Language language) {
        Object v2;
        block6: {
            void $this$filterTo$iv$iv;
            Collection collection = Language.getRegisteredLanguages();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRegisteredLanguages()");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Language it = (Language)element$iv$iv;
                boolean bl = false;
                if (!language.isKindOf(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List baseLanguages = (List)destination$iv$iv;
            Iterable iterable2 = this.languageToGroup.keySet();
            for (Object e : iterable2) {
                boolean bl;
                block5: {
                    String languageId = (String)e;
                    boolean bl2 = false;
                    Iterable $this$any$iv = baseLanguages;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Language it = (Language)element$iv;
                            boolean bl3 = false;
                            if (!StringsKt.equals((String)languageId, (String)it.getID(), (boolean)true)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v2 = e;
                break block6;
            }
            v2 = null;
        }
        return v2;
    }

    private final List<Integer> getBucketsMapping(Long seed) {
        IntRange buckets = RangesKt.until((int)0, (int)256);
        return seed == null ? CollectionsKt.toList((Iterable)((Iterable)buckets)) : CollectionsKt.shuffled((Iterable)((Iterable)buckets), (Random)new Random(seed));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/completion/ml/experiment/ClientExperimentStatus$Companion;", "", "()V", "EXPERIMENT_DISABLED_PROPERTY_KEY", "", "checkExperimentGroups", "", "experimentInfo", "Lcom/intellij/completion/ml/experiment/ExperimentConfig;", "loadExperimentInfo", "intellij.completionMlRanking"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExperimentConfig loadExperimentInfo() {
            try {
                if (!ApplicationManager.getApplication().isEAP()) {
                    return ExperimentConfig.Companion.disabledExperiment();
                }
                byte[] byArray = ResourceUtil.getResourceAsBytes((String)"experiment.json", (ClassLoader)ClientExperimentStatus.class.getClassLoader());
                Intrinsics.checkNotNull((Object)byArray);
                byte[] data = byArray;
                ExperimentConfig experimentInfo = (ExperimentConfig)Json.Default.decodeFromString((DeserializationStrategy)ExperimentConfig.Companion.serializer(), new String(data, Charsets.UTF_8));
                this.checkExperimentGroups(experimentInfo);
                return experimentInfo;
            }
            catch (Throwable e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(ClientExperimentStatus.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                logger.error("Error on loading ML Completion experiment info", e);
                return ExperimentConfig.Companion.disabledExperiment();
            }
        }

        private final void checkExperimentGroups(ExperimentConfig experimentInfo) {
            boolean bl;
            for (ExperimentGroupConfig group : experimentInfo.getGroups()) {
                if (group.getShowArrows()) {
                    bl = group.getUseMLRanking();
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$42 = false;
                        String $i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$42 = "Showing arrows requires ML ranking";
                        throw new AssertionError((Object)$i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$42);
                    }
                }
                if (!group.getUseMLRanking()) continue;
                bl = group.getCalculateFeatures();
                if (!_Assertions.ENABLED || bl) continue;
                boolean $i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$62 = false;
                String $i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$62 = "ML ranking requires calculating features";
                throw new AssertionError((Object)$i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$62);
            }
            for (ExperimentLanguageConfig language : experimentInfo.getLanguages()) {
                block12: {
                    boolean bl2 = bl = language.getIncludeGroups().size() <= language.getExperimentBucketsCount();
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$72 = false;
                        String $i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$72 = "Groups count must be less than the total number of buckets (" + language.getId() + ")";
                        throw new AssertionError((Object)$i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$72);
                    }
                    Iterable $this$all$iv = language.getIncludeGroups();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v1 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            boolean bl3;
                            block11: {
                                int number = ((Number)element$iv).intValue();
                                boolean bl4 = false;
                                Iterable $this$any$iv = experimentInfo.getGroups();
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl3 = false;
                                } else {
                                    for (Object element$iv2 : $this$any$iv) {
                                        ExperimentGroupConfig it = (ExperimentGroupConfig)element$iv2;
                                        boolean bl5 = false;
                                        if (!(it.getNumber() == number)) continue;
                                        bl3 = true;
                                        break block11;
                                    }
                                    bl3 = false;
                                }
                            }
                            if (bl3) continue;
                            v1 = false;
                            break block12;
                        }
                        v1 = bl = true;
                    }
                }
                if (!_Assertions.ENABLED || bl) continue;
                boolean bl6 = false;
                String string = "Group included for language (" + language.getId() + ") should be among general list of groups";
                throw new AssertionError((Object)string);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

