/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.common;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.textMatching.SimilarityScorer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/completion/ml/common/ContextSimilarityUtil;", "", "()V", "LINE_SIMILARITY_SCORER_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/textMatching/SimilarityScorer;", "getLINE_SIMILARITY_SCORER_KEY", "()Lcom/intellij/openapi/util/Key;", "PARENT_SIMILARITY_SCORER_KEY", "getPARENT_SIMILARITY_SCORER_KEY", "createLineSimilarityScorer", "line", "", "createParentSimilarityScorer", "element", "Lcom/intellij/psi/PsiElement;", "intellij.completionMlRanking"})
public final class ContextSimilarityUtil {
    @NotNull
    public static final ContextSimilarityUtil INSTANCE = new ContextSimilarityUtil();
    @NotNull
    private static final Key<SimilarityScorer> LINE_SIMILARITY_SCORER_KEY;
    @NotNull
    private static final Key<SimilarityScorer> PARENT_SIMILARITY_SCORER_KEY;

    private ContextSimilarityUtil() {
    }

    @NotNull
    public final Key<SimilarityScorer> getLINE_SIMILARITY_SCORER_KEY() {
        return LINE_SIMILARITY_SCORER_KEY;
    }

    @NotNull
    public final Key<SimilarityScorer> getPARENT_SIMILARITY_SCORER_KEY() {
        return PARENT_SIMILARITY_SCORER_KEY;
    }

    @NotNull
    public final SimilarityScorer createLineSimilarityScorer(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        List list = StringUtil.getWordsIn((String)line);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getWordsIn(line)");
        return new SimilarityScorer(list, null, 2, null);
    }

    @NotNull
    public final SimilarityScorer createParentSimilarityScorer(@Nullable PsiElement element) {
        List parents = new ArrayList();
        for (PsiElement curElement = element; curElement != null && !(curElement instanceof PsiFile); curElement = curElement.getParent()) {
            String it;
            if (!(curElement instanceof PsiNamedElement)) continue;
            if (((PsiNamedElement)curElement).getName() == null) continue;
            boolean bl = false;
            parents.add(it);
        }
        return new SimilarityScorer(parents, null, 2, null);
    }

    static {
        Key key = Key.create((String)"LINE_SIMILARITY_SCORER");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(\"LINE_SIMILARITY_SCORER\")");
        LINE_SIMILARITY_SCORER_KEY = key;
        Key key2 = Key.create((String)"PARENT_SIMILARITY_SCORER");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(\"PARENT_SIMILARITY_SCORER\")");
        PARENT_SIMILARITY_SCORER_KEY = key2;
    }
}

