/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.common;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.ml.CompletionEnvironment;
import com.intellij.codeInsight.completion.ml.ContextFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.completion.ml.common.ContextSimilarityUtil;
import com.intellij.completion.ml.common.CurrentProjectInfo;
import com.intellij.completion.ml.common.LocationFeaturesUtil;
import com.intellij.completion.ml.ngram.NGram;
import com.intellij.completion.ml.util.LookupExtensionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\u0012\u001a\u00020\u000f*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/completion/ml/common/CommonLocationFeatures;", "Lcom/intellij/codeInsight/completion/ml/ContextFeatureProvider;", "()V", "calculateFeatures", "", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "environment", "Lcom/intellij/codeInsight/completion/ml/CompletionEnvironment;", "getName", "isAfterDot", "", "position", "Lcom/intellij/psi/PsiElement;", "putContextSimilarityScorers", "", "line", "putNGramScorers", "addPsiParents", "", "numParents", "", "CaseSensitivity", "intellij.completionMlRanking"})
public final class CommonLocationFeatures
implements ContextFeatureProvider {
    @NotNull
    public String getName() {
        return "common";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull CompletionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Lookup lookup = environment.getLookup();
        Intrinsics.checkNotNullExpressionValue((Object)lookup, (String)"environment.lookup");
        Lookup lookup2 = lookup;
        Editor editor = lookup2.getTopLevelEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"lookup.topLevelEditor");
        Editor editor2 = editor;
        int caretOffset = lookup2.getLookupStart();
        LogicalPosition logicalPosition = editor2.offsetToLogicalPosition(caretOffset);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"editor.offsetToLogicalPosition(caretOffset)");
        LogicalPosition logicalPosition2 = logicalPosition;
        int lineStartOffset = editor2.getDocument().getLineStartOffset(logicalPosition2.line);
        PsiElement psiElement = environment.getParameters().getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"environment.parameters.position");
        PsiElement position = psiElement;
        int prefixLength = LookupExtensionsKt.prefix(lookup2).length();
        String string = editor2.getDocument().getText(new TextRange(lineStartOffset, caretOffset));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"editor.document.getText(\u2026tartOffset, caretOffset))");
        String linePrefix = string;
        this.putNGramScorers(environment);
        int prefixToDrop = prefixLength > 0 ? prefixLength : 0;
        this.putContextSimilarityScorers(StringsKt.dropLast((String)linePrefix, (int)prefixToDrop), position, environment);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"line_num", (Object)MLFeatureValue.Companion.float(logicalPosition2.line)), TuplesKt.to((Object)"col_num", (Object)MLFeatureValue.Companion.float(logicalPosition2.column)), TuplesKt.to((Object)"indent_level", (Object)MLFeatureValue.Companion.float(LocationFeaturesUtil.INSTANCE.indentLevel(linePrefix, EditorUtil.getTabSize((Editor)editor2)))), TuplesKt.to((Object)"is_in_line_beginning", (Object)MLFeatureValue.Companion.binary(StringUtil.isEmptyOrSpaces((String)linePrefix)))};
        Map result = MapsKt.mutableMapOf((Pair[])pairArray);
        if (DumbService.isDumb((Project)lookup2.getProject())) {
            result.put("dumb_mode", MLFeatureValue.Companion.binary(true));
        }
        Project project = lookup2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"lookup.project");
        if (CurrentProjectInfo.Companion.getInstance(project).isIdeaProject()) {
            result.put("is_idea_project", MLFeatureValue.Companion.binary(true));
        }
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)codeInsightSettings, (String)"getInstance()");
        CaseSensitivity caseSensitive = CaseSensitivity.Companion.fromSettings(codeInsightSettings);
        if (caseSensitive != CaseSensitivity.NONE) {
            result.put("case_sensitivity", MLFeatureValue.Companion.categorical((Enum)caseSensitive));
        }
        result.put("is_after_dot", MLFeatureValue.Companion.binary(this.isAfterDot(position)));
        this.addPsiParents(result, position, 10);
        return result;
    }

    private final void putNGramScorers(CompletionEnvironment environment) {
        CompletionParameters completionParameters = environment.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)completionParameters, (String)"environment.parameters");
        for (Map.Entry<Key<NGram.Scorer>, NGram.Scorer> entry : NGram.INSTANCE.getScorers$intellij_completionMlRanking(completionParameters, 4).entrySet()) {
            Key<NGram.Scorer> key = entry.getKey();
            NGram.Scorer scorer = entry.getValue();
            environment.putUserData(key, (Object)scorer);
        }
    }

    private final void putContextSimilarityScorers(String line, PsiElement position, CompletionEnvironment environment) {
        environment.putUserData(ContextSimilarityUtil.INSTANCE.getLINE_SIMILARITY_SCORER_KEY(), (Object)ContextSimilarityUtil.INSTANCE.createLineSimilarityScorer(line));
        environment.putUserData(ContextSimilarityUtil.INSTANCE.getPARENT_SIMILARITY_SCORER_KEY(), (Object)ContextSimilarityUtil.INSTANCE.createParentSimilarityScorer(position));
    }

    private final void addPsiParents(Map<String, MLFeatureValue> $this$addPsiParents, PsiElement position, int numParents) {
        PsiElement psiElement = position.getParent();
        if (psiElement == null) {
            return;
        }
        PsiElement curParent = psiElement;
        int i = 1;
        if (i <= numParents) {
            while (true) {
                if (curParent.getParent() == null) {
                    return;
                }
                String parentName = "parent_" + i;
                $this$addPsiParents.put(parentName, MLFeatureValue.Companion.className$default((MLFeatureValue.Companion)MLFeatureValue.Companion, curParent.getClass(), (boolean)false, (int)2, null));
                if (curParent instanceof PsiFileSystemItem) {
                    return;
                }
                if (i == numParents) break;
                ++i;
            }
        }
    }

    private final boolean isAfterDot(PsiElement position) {
        PsiElement prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)position);
        return prev != null && Intrinsics.areEqual((Object)prev.getText(), (Object)".");
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u0000 \u00062\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/completion/ml/common/CommonLocationFeatures$CaseSensitivity;", "", "(Ljava/lang/String;I)V", "NONE", "ALL", "FIRST_LETTER", "Companion", "intellij.completionMlRanking"})
    private static final class CaseSensitivity
    extends Enum<CaseSensitivity> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ CaseSensitivity NONE;
        public static final /* enum */ CaseSensitivity ALL;
        public static final /* enum */ CaseSensitivity FIRST_LETTER;
        private static final /* synthetic */ CaseSensitivity[] $VALUES;

        public static CaseSensitivity[] values() {
            return (CaseSensitivity[])$VALUES.clone();
        }

        public static CaseSensitivity valueOf(String value) {
            return Enum.valueOf(CaseSensitivity.class, value);
        }

        static {
            NONE = new CaseSensitivity();
            ALL = new CaseSensitivity();
            FIRST_LETTER = new CaseSensitivity();
            $VALUES = caseSensitivityArray = new CaseSensitivity[]{CaseSensitivity.NONE, CaseSensitivity.ALL, CaseSensitivity.FIRST_LETTER};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/completion/ml/common/CommonLocationFeatures$CaseSensitivity$Companion;", "", "()V", "fromSettings", "Lcom/intellij/completion/ml/common/CommonLocationFeatures$CaseSensitivity;", "settings", "Lcom/intellij/codeInsight/CodeInsightSettings;", "intellij.completionMlRanking"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CaseSensitivity fromSettings(@NotNull CodeInsightSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                return switch (settings.getCompletionCaseSensitive()) {
                    case 1 -> ALL;
                    case 3 -> FIRST_LETTER;
                    default -> NONE;
                };
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

