/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.actions;

import com.fasterxml.jackson.jr.ob.JSON;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.completion.ml.storage.LookupStorage;
import com.intellij.completion.ml.util.LookupElementExtensionsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ide.CopyPasteManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000e"}, d2={"Lcom/intellij/completion/ml/actions/MLCompletionFeaturesUtil;", "", "()V", "getCommonFeatures", "Lcom/intellij/completion/ml/actions/MLCompletionFeaturesUtil$CommonFeatures;", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "getElementFeatures", "Lcom/intellij/completion/ml/actions/MLCompletionFeaturesUtil$ElementFeatures;", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "CommonFeatures", "CopyFeaturesToClipboard", "ElementFeatures", "intellij.completionMlRanking"})
public final class MLCompletionFeaturesUtil {
    @NotNull
    public static final MLCompletionFeaturesUtil INSTANCE = new MLCompletionFeaturesUtil();

    private MLCompletionFeaturesUtil() {
    }

    @NotNull
    public final CommonFeatures getCommonFeatures(@NotNull LookupImpl lookup) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        LookupStorage lookupStorage = LookupStorage.Companion.get(lookup);
        if (lookupStorage == null) {
            return new CommonFeatures(null, null, null, 7, null);
        }
        LookupStorage storage = lookupStorage;
        return new CommonFeatures(storage.getUserFactors(), storage.getSessionFactors().getLastUsedCommonFactors(), storage.getContextFactors());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ElementFeatures getElementFeatures(@NotNull LookupImpl lookup, @NotNull LookupElement element) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map<String, Object> features2;
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String id = LookupElementExtensionsKt.idString(element);
        LookupStorage lookupStorage = LookupStorage.Companion.get(lookup);
        if (lookupStorage == null) {
            return new ElementFeatures(id, null, 2, null);
        }
        LookupStorage storage = lookupStorage;
        Map<String, Object> map = storage.getItemStorage(id).getLastUsedFactors();
        if (map == null) {
            return new ElementFeatures(id, null, 2, null);
        }
        Map<String, Object> map2 = features2 = map;
        String string = id;
        boolean $i$f$mapValues = false;
        void var8_9 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            String string2 = it.getValue().toString();
            map4.put(k, string2);
        }
        Map map5 = destination$iv$iv;
        String string3 = string;
        return new ElementFeatures(string3, map5);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0015\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0015\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003JK\u0010\u000f\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/completion/ml/actions/MLCompletionFeaturesUtil$CommonFeatures;", "", "user", "", "", "session", "context", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)V", "getContext", "()Ljava/util/Map;", "getSession", "getUser", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.completionMlRanking"})
    public static final class CommonFeatures {
        @NotNull
        private final Map<String, String> user;
        @NotNull
        private final Map<String, String> session;
        @NotNull
        private final Map<String, String> context;

        public CommonFeatures(@NotNull Map<String, String> user, @NotNull Map<String, String> session, @NotNull Map<String, String> context) {
            Intrinsics.checkNotNullParameter(user, (String)"user");
            Intrinsics.checkNotNullParameter(session, (String)"session");
            Intrinsics.checkNotNullParameter(context, (String)"context");
            this.user = user;
            this.session = session;
            this.context = context;
        }

        public /* synthetic */ CommonFeatures(Map map, Map map2, Map map3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            if ((n & 2) != 0) {
                map2 = MapsKt.emptyMap();
            }
            if ((n & 4) != 0) {
                map3 = MapsKt.emptyMap();
            }
            this(map, map2, map3);
        }

        @NotNull
        public final Map<String, String> getUser() {
            return this.user;
        }

        @NotNull
        public final Map<String, String> getSession() {
            return this.session;
        }

        @NotNull
        public final Map<String, String> getContext() {
            return this.context;
        }

        @NotNull
        public final Map<String, String> component1() {
            return this.user;
        }

        @NotNull
        public final Map<String, String> component2() {
            return this.session;
        }

        @NotNull
        public final Map<String, String> component3() {
            return this.context;
        }

        @NotNull
        public final CommonFeatures copy(@NotNull Map<String, String> user, @NotNull Map<String, String> session, @NotNull Map<String, String> context) {
            Intrinsics.checkNotNullParameter(user, (String)"user");
            Intrinsics.checkNotNullParameter(session, (String)"session");
            Intrinsics.checkNotNullParameter(context, (String)"context");
            return new CommonFeatures(user, session, context);
        }

        public static /* synthetic */ CommonFeatures copy$default(CommonFeatures commonFeatures, Map map, Map map2, Map map3, int n, Object object) {
            if ((n & 1) != 0) {
                map = commonFeatures.user;
            }
            if ((n & 2) != 0) {
                map2 = commonFeatures.session;
            }
            if ((n & 4) != 0) {
                map3 = commonFeatures.context;
            }
            return commonFeatures.copy(map, map2, map3);
        }

        @NotNull
        public String toString() {
            return "CommonFeatures(user=" + this.user + ", session=" + this.session + ", context=" + this.context + ")";
        }

        public int hashCode() {
            int result = ((Object)this.user).hashCode();
            result = result * 31 + ((Object)this.session).hashCode();
            result = result * 31 + ((Object)this.context).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommonFeatures)) {
                return false;
            }
            CommonFeatures commonFeatures = (CommonFeatures)other;
            if (!Intrinsics.areEqual(this.user, commonFeatures.user)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.session, commonFeatures.session)) {
                return false;
            }
            return Intrinsics.areEqual(this.context, commonFeatures.context);
        }

        public CommonFeatures() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/completion/ml/actions/MLCompletionFeaturesUtil$ElementFeatures;", "", "id", "", "features", "", "(Ljava/lang/String;Ljava/util/Map;)V", "getFeatures", "()Ljava/util/Map;", "getId", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.completionMlRanking"})
    public static final class ElementFeatures {
        @NotNull
        private final String id;
        @NotNull
        private final Map<String, String> features;

        public ElementFeatures(@NotNull String id, @NotNull Map<String, String> features2) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(features2, (String)"features");
            this.id = id;
            this.features = features2;
        }

        public /* synthetic */ ElementFeatures(String string, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                map = MapsKt.emptyMap();
            }
            this(string, map);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final Map<String, String> getFeatures() {
            return this.features;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final Map<String, String> component2() {
            return this.features;
        }

        @NotNull
        public final ElementFeatures copy(@NotNull String id, @NotNull Map<String, String> features2) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(features2, (String)"features");
            return new ElementFeatures(id, features2);
        }

        public static /* synthetic */ ElementFeatures copy$default(ElementFeatures elementFeatures, String string, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                string = elementFeatures.id;
            }
            if ((n & 2) != 0) {
                map = elementFeatures.features;
            }
            return elementFeatures.copy(string, map);
        }

        @NotNull
        public String toString() {
            return "ElementFeatures(id=" + this.id + ", features=" + this.features + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + ((Object)this.features).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ElementFeatures)) {
                return false;
            }
            ElementFeatures elementFeatures = (ElementFeatures)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)elementFeatures.id)) {
                return false;
            }
            return Intrinsics.areEqual(this.features, elementFeatures.features);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/completion/ml/actions/MLCompletionFeaturesUtil$CopyFeaturesToClipboard;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "Companion", "intellij.completionMlRanking"})
    public static final class CopyFeaturesToClipboard
    extends AnAction {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final Logger LOG;

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            e.getPresentation().setEnabled(editor != null && LookupManager.getActiveLookup((Editor)editor) != null);
        }

        /*
         * WARNING - void declaration
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            JSON.Feature[] featureArray = LookupManager.getActiveLookup((Editor)editor);
            LookupImpl lookupImpl = featureArray instanceof LookupImpl ? (LookupImpl)featureArray : null;
            if (lookupImpl == null) {
                return;
            }
            LookupImpl lookup = lookupImpl;
            featureArray = new JSON.Feature[]{JSON.Feature.PRETTY_PRINT_OUTPUT};
            JSON jSON = JSON.std.with(featureArray);
            featureArray = new Pair[2];
            featureArray[0] = TuplesKt.to((Object)"common", (Object)INSTANCE.getCommonFeatures(lookup));
            List list = lookup.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"lookup.items");
            Iterable iterable = list;
            String string = "elements";
            int n = 1;
            JSON.Feature[] featureArray2 = featureArray;
            JSON jSON2 = jSON;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            void var9_13 = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                LookupElement it = (LookupElement)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                ElementFeatures elementFeatures = INSTANCE.getElementFeatures(lookup, it);
                Pair pair = TuplesKt.to((Object)elementFeatures.getId(), elementFeatures.getFeatures());
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map map = destination$iv$iv;
            featureArray2[n] = TuplesKt.to((Object)string, (Object)map);
            String json = jSON2.asString((Object)MapsKt.mapOf((Pair[])featureArray));
            try {
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(json));
            }
            catch (Exception e2) {
                LOG.debug("Error on copying features to clipboard: " + json);
                throw e2;
            }
        }

        static {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(CopyFeaturesToClipboard.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            LOG = logger;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/completion/ml/actions/MLCompletionFeaturesUtil$CopyFeaturesToClipboard$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.completionMlRanking"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

