/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.structuralsearch;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.lang.properties.structuralsearch.PropertiesMatchingStrategy;
import com.intellij.lang.properties.template.PropertiesContextType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.structuralsearch.DocumentBasedReplaceHandler;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.PatternContextInfo;
import com.intellij.structuralsearch.PredefinedConfigurationUtil;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.handlers.LiteralWithSubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PropertiesStructuralSearchProfile
extends StructuralSearchProfile {
    private static final String TYPED_VAR_PREFIX = "__$_";

    public Configuration @NotNull [] getPredefinedTemplates() {
        return new Configuration[]{PropertiesStructuralSearchProfile.createConfiguration(PropertiesBundle.message("predefined.configuration.duplicated.word.in.property.value", new Object[0]), "Duplicated word", "'_key='value:.*\\b(\\w+)\\s+\\1\\b.*"), PropertiesStructuralSearchProfile.createConfiguration(PropertiesBundle.message("predefined.configuration.double.single.quote.in.value.without.curly.brace", new Object[0]), "Double ' without {", "'_key='value:[ regex( [^{]*''[^{]* ) ]")};
    }

    @NotNull
    private static Configuration createConfiguration(@NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String name, @NotNull @NonNls String refName, @NotNull @NonNls String criteria) {
        return PredefinedConfigurationUtil.createConfiguration((String)name, (String)refName, (String)criteria, (String)PropertiesBundle.message("properties.files.inspection.group.display.name", new Object[0]), (LanguageFileType)PropertiesFileType.INSTANCE);
    }

    @NotNull
    public @NotNull PsiElement @NotNull [] createPatternTree(@NotNull String text, @NotNull PatternContextInfo contextInfo, @NotNull LanguageFileType fileType, @NotNull Language language, @NotNull Project project, boolean physical) {
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText("__dummy.properties", language, (CharSequence)text, physical, true);
        PsiElement child = file.getFirstChild();
        if (child == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        SmartList result = new SmartList();
        for (PsiElement patternElement = child.getFirstChild(); patternElement != null; patternElement = patternElement.getNextSibling()) {
            if (!(patternElement instanceof Property) && !(patternElement instanceof PsiComment)) continue;
            result.add((Object)patternElement);
        }
        return (PsiElement[])result.toArray((Object[])PsiElement.EMPTY_ARRAY);
    }

    public void compile(PsiElement @NotNull [] elements, @NotNull GlobalCompilingVisitor globalVisitor) {
        if (elements.length > 1) {
            throw new MalformedPatternException();
        }
        CompiledPattern pattern = globalVisitor.getContext().getPattern();
        for (PsiElement element : elements) {
            if (element instanceof PsiComment) {
                PsiComment comment = (PsiComment)element;
                String commentText = comment.getText();
                if (globalVisitor.hasFragments(commentText)) {
                    MatchingHandler handler = globalVisitor.processPatternStringWithFragments(commentText, GlobalCompilingVisitor.OccurenceKind.COMMENT);
                    if (handler != null) {
                        comment.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
                    }
                } else {
                    globalVisitor.handle((PsiElement)comment);
                }
                pattern.getHandler(element).setFilter(e -> e instanceof PsiComment);
            } else if (element instanceof Property) {
                PsiElement lastChild;
                Property property = (Property)element;
                pattern.getHandler(element).setFilter(e -> e instanceof Property);
                PsiElement firstChild = property.getFirstChild();
                if (firstChild instanceof PropertyKeyImpl) {
                    globalVisitor.handle(firstChild);
                    pattern.getHandler(firstChild).setFilter(e -> e instanceof PropertyKeyImpl);
                }
                if ((lastChild = property.getLastChild()) instanceof PropertyValueImpl) {
                    String valueText = lastChild.getText();
                    MatchingHandler handler = globalVisitor.processPatternStringWithFragments(valueText, GlobalCompilingVisitor.OccurenceKind.TEXT);
                    if (handler != null) {
                        lastChild.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
                    }
                    pattern.getHandler(firstChild).setFilter(e -> e instanceof PropertyValueImpl);
                }
            }
            pattern.setHandler(element, (MatchingHandler)new TopLevelMatchingHandler(pattern.getHandler(element)));
        }
    }

    @NotNull
    public PsiElementVisitor createMatchingVisitor(final @NotNull GlobalMatchingVisitor globalVisitor) {
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element instanceof Property) {
                    PsiElement value;
                    Property other = (Property)globalVisitor.getElement(Property.class);
                    PsiElement key = element.getFirstChild();
                    if (globalVisitor.setResult(globalVisitor.match(key, other.getFirstChild())) && (value = element.getLastChild()) instanceof PropertyValueImpl) {
                        PsiElement otherValue = other.getLastChild();
                        globalVisitor.setResult(globalVisitor.matchOptionally(value, (PsiElement)(otherValue instanceof PropertyValueImpl ? otherValue : null)));
                    }
                } else if (element instanceof PropertyKeyImpl) {
                    PropertyKeyImpl other = (PropertyKeyImpl)globalVisitor.getElement(PropertyKeyImpl.class);
                    MatchContext context = globalVisitor.getMatchContext();
                    MatchingHandler handler = context.getPattern().getHandler(element);
                    if (handler instanceof SubstitutionHandler) {
                        globalVisitor.setResult(((SubstitutionHandler)handler).handle((PsiElement)other, context));
                    } else {
                        globalVisitor.setResult(globalVisitor.matchText(element, (PsiElement)other));
                    }
                } else if (element instanceof PropertyValueImpl) {
                    PropertyValueImpl other = (PropertyValueImpl)globalVisitor.getElement(PropertyValueImpl.class);
                    MatchContext context = globalVisitor.getMatchContext();
                    MatchingHandler handler = (MatchingHandler)element.getUserData(CompiledPattern.HANDLER_KEY);
                    if (handler instanceof LiteralWithSubstitutionHandler) {
                        globalVisitor.setResult(handler.match(element, (PsiElement)other, context));
                    } else if (handler instanceof SubstitutionHandler) {
                        globalVisitor.setResult(((SubstitutionHandler)handler).handle((PsiElement)other, context));
                    } else {
                        globalVisitor.setResult(globalVisitor.matchText(element, (PsiElement)other));
                    }
                }
            }

            public void visitComment(@NotNull PsiComment comment) {
                PsiElement other = globalVisitor.getElement();
                MatchingHandler handler = (MatchingHandler)comment.getUserData(CompiledPattern.HANDLER_KEY);
                globalVisitor.setResult(handler instanceof LiteralWithSubstitutionHandler ? handler.match((PsiElement)comment, other, globalVisitor.getMatchContext()) : globalVisitor.matchText((PsiElement)comment, other));
            }
        };
    }

    @NotNull
    public CompiledPattern createCompiledPattern() {
        return new CompiledPattern(){
            {
                this.setStrategy(PropertiesMatchingStrategy.INSTANCE);
            }

            public String @NotNull [] getTypedVarPrefixes() {
                return new String[]{PropertiesStructuralSearchProfile.TYPED_VAR_PREFIX};
            }

            public boolean isTypedVar(@NotNull String str) {
                return str.startsWith(PropertiesStructuralSearchProfile.TYPED_VAR_PREFIX);
            }
        };
    }

    public boolean isMyLanguage(@NotNull Language language) {
        return language == PropertiesLanguage.INSTANCE;
    }

    @NotNull
    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        return PropertiesContextType.class;
    }

    public StructuralReplaceHandler getReplaceHandler(@NotNull Project project, @NotNull ReplaceOptions replaceOptions) {
        return new DocumentBasedReplaceHandler(project);
    }
}

