/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.properties.PropertiesQuickFixFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.lang.properties.references.PropertyReferenceBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyReference
extends PropertyReferenceBase
implements LocalQuickFixProvider {
    @Nullable
    private final String myBundleName;

    public PropertyReference(@NotNull String key, @NotNull PsiElement element, @Nullable String bundleName, boolean soft, TextRange range) {
        super(key, soft, element, range);
        this.myBundleName = bundleName;
    }

    public PropertyReference(@NotNull String key, @NotNull PsiElement element, @Nullable String bundleName, boolean soft) {
        super(key, soft, element);
        this.myBundleName = bundleName;
    }

    @Override
    @Nullable
    protected List<PropertiesFile> getPropertiesFiles() {
        if (this.myBundleName == null) {
            return null;
        }
        return this.retrievePropertyFilesByBundleName(this.myBundleName, this.myElement);
    }

    protected List<PropertiesFile> retrievePropertyFilesByBundleName(String bundleName, PsiElement element) {
        return I18nUtil.propertiesFilesByBundleName(bundleName, element);
    }

    public LocalQuickFix @NotNull [] getQuickFixes() {
        List<PropertiesFile> propertiesFiles = this.retrievePropertyFilesByBundleName(this.myBundleName, this.getElement());
        LocalQuickFix fix = PropertiesQuickFixFactory.getInstance().createCreatePropertyFix(this.myElement, this.myKey, propertiesFiles);
        return new LocalQuickFix[]{fix};
    }
}

