/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertiesResourceBundleUtil;
import com.intellij.lang.properties.psi.PropertyKeyValueFormat;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFileFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertiesElementFactory {
    private static final Key<PropertiesFile> SYSTEM_PROPERTIES_KEY = Key.create((String)"system.properties.file");
    private static final UserDataCache<PropertiesFile, Project, Void> PROPERTIES = new UserDataCache<PropertiesFile, Project, Void>("system.properties.file"){

        protected PropertiesFile compute(Project project, Void p) {
            return PropertiesElementFactory.createPropertiesFile(project, System.getProperties(), "system");
        }
    };

    @NotNull
    public static IProperty createProperty(@NotNull Project project, @NonNls @NotNull String name, @NonNls @NotNull String value, @Nullable Character delimiter) {
        return PropertiesElementFactory.createProperty(project, name, value, delimiter, PropertyKeyValueFormat.PRESENTABLE);
    }

    @NotNull
    public static IProperty createProperty(@NotNull Project project, @NonNls @NotNull String name, @NonNls @NotNull String value, @Nullable Character delimiter, @NotNull PropertyKeyValueFormat format) {
        String text = PropertiesElementFactory.getPropertyText(name, value, delimiter, project, format);
        PropertiesFile dummyFile = PropertiesElementFactory.createPropertiesFile(project, text);
        return dummyFile.getProperties().get(0);
    }

    @NotNull
    public static String getPropertyText(@NonNls @NotNull String name, @NonNls @NotNull String value, @NonNls @Nullable Character delimiter, @Nullable Project project, @NotNull PropertyKeyValueFormat format) {
        if (delimiter == null) {
            delimiter = Character.valueOf(project == null ? (char)'=' : PropertiesCodeStyleSettings.getInstance(project).getDelimiter());
        }
        return (format != PropertyKeyValueFormat.FILE ? PropertiesElementFactory.escape(name) : name) + delimiter + PropertiesElementFactory.escapeValue(value, delimiter.charValue(), format);
    }

    @NotNull
    public static PropertiesFile createPropertiesFile(@NotNull Project project, @NonNls @NotNull String text) {
        @NonNls String filename = "dummy." + PropertiesFileType.INSTANCE.getDefaultExtension();
        return (PropertiesFile)PsiFileFactory.getInstance((Project)project).createFileFromText(filename, (FileType)PropertiesFileType.INSTANCE, (CharSequence)text);
    }

    @NotNull
    public static PropertiesFile createPropertiesFile(@NotNull Project project, Properties properties, String fileName) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            properties.store(stream, "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        @NonNls String filename = fileName + "." + PropertiesFileType.INSTANCE.getDefaultExtension();
        return (PropertiesFile)PsiFileFactory.getInstance((Project)project).createFileFromText(filename, (FileType)PropertiesFileType.INSTANCE, (CharSequence)stream.toString());
    }

    @NotNull
    public static synchronized PropertiesFile getSystemProperties(@NotNull Project project) {
        PropertiesFile systemPropertiesFile = (PropertiesFile)project.getUserData(SYSTEM_PROPERTIES_KEY);
        if (systemPropertiesFile == null) {
            systemPropertiesFile = PropertiesElementFactory.createPropertiesFile(project, System.getProperties(), "system");
            project.putUserData(SYSTEM_PROPERTIES_KEY, (Object)systemPropertiesFile);
        }
        return systemPropertiesFile;
    }

    @NotNull
    private static String escape(@NotNull String name) {
        if (StringUtil.startsWithChar((CharSequence)name, (char)'#') || StringUtil.startsWithChar((CharSequence)name, (char)'!')) {
            name = "\\" + (String)name;
        }
        return StringUtil.escapeChars((String)name, (char[])new char[]{'=', ':', ' ', '\t'});
    }

    @Deprecated(forRemoval=true)
    public static String escapeValue(String value, char delimiter) {
        return PropertiesElementFactory.escapeValue(value, delimiter, PropertyKeyValueFormat.PRESENTABLE);
    }

    public static String escapeValue(String value, char delimiter, PropertyKeyValueFormat format) {
        return PropertiesResourceBundleUtil.convertValueToFileFormat(value, delimiter, format);
    }
}

