/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.projectView;

import com.intellij.ide.DeleteProvider;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleDeleteProvider
implements DeleteProvider {
    private static final Logger LOG = Logger.getInstance(ResourceBundleDeleteProvider.class);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        ResourceBundle[] resourceBundles = (ResourceBundle[])ResourceBundle.ARRAY_DATA_KEY.getData(dataContext);
        if (resourceBundles != null && resourceBundles.length != 0) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            LOG.assertTrue(project != null);
            PsiElement[] toDelete = (PsiElement[])Arrays.stream(resourceBundles).flatMap(rb -> rb.getPropertiesFiles().stream()).map(PropertiesFile::getContainingFile).toArray(PsiElement[]::new);
            SafeDeleteHandler.invoke((Project)project, (PsiElement[])toDelete, (boolean)true, () -> {
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                for (ResourceBundle bundle : resourceBundles) {
                    fileEditorManager.closeFile((VirtualFile)new ResourceBundleAsVirtualFile(bundle));
                }
            });
        }
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        return project != null;
    }
}

