/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.codeInspection.unsorted;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.codeInspection.unsorted.AlphaUnsortedPropertiesFileInspectionSuppressor;
import com.intellij.lang.properties.psi.PropertiesElementFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertiesList;
import com.intellij.lang.properties.psi.PropertyKeyValueFormat;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AlphaUnsortedPropertiesFileInspection
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(AlphaUnsortedPropertiesFileInspection.class);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new PsiElementVisitor(){

            public void visitFile(@NotNull PsiFile file) {
                PropertiesFile propertiesFile = AlphaUnsortedPropertiesFileInspection.findPropertiesFile(file);
                if (propertiesFile == null) {
                    return;
                }
                ResourceBundle resourceBundle = propertiesFile.getResourceBundle();
                String resourceBundleBaseName = resourceBundle.getBaseName();
                if (!AlphaUnsortedPropertiesFileInspection.isResourceBundleAlphaSortedExceptOneFile(resourceBundle, propertiesFile)) {
                    holder.registerProblem((PsiElement)file, PropertiesBundle.message("inspection.alpha.unsorted.properties.file.description1", resourceBundleBaseName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new PropertiesSorterQuickFix(false)});
                    return;
                }
                if (!propertiesFile.isAlphaSorted()) {
                    PropertiesSorterQuickFix fix = new PropertiesSorterQuickFix(true);
                    holder.registerProblem((PsiElement)file, PropertiesBundle.message("inspection.alpha.unsorted.properties.file.description", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
                }
            }
        };
    }

    @Nullable
    private static PropertiesFile findPropertiesFile(@NotNull PsiFile file) {
        PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(file);
        if (!(propertiesFile instanceof PropertiesFileImpl)) {
            return null;
        }
        for (AlphaUnsortedPropertiesFileInspectionSuppressor filter : (AlphaUnsortedPropertiesFileInspectionSuppressor[])AlphaUnsortedPropertiesFileInspectionSuppressor.EP_NAME.getExtensions()) {
            if (!filter.suppressInspectionFor(propertiesFile)) continue;
            return null;
        }
        return propertiesFile;
    }

    private static boolean isResourceBundleAlphaSortedExceptOneFile(@NotNull ResourceBundle resourceBundle, @NotNull PropertiesFile exceptedFile) {
        for (PropertiesFile file : resourceBundle.getPropertiesFiles()) {
            if (!(file instanceof PropertiesFileImpl)) {
                return true;
            }
            if (file.equals(exceptedFile) || file.isAlphaSorted()) continue;
            return false;
        }
        return true;
    }

    private static void sortPropertiesFile(PropertiesFile file) {
        ArrayList<IProperty> properties = new ArrayList<IProperty>(file.getProperties());
        properties.sort(Comparator.comparing(IProperty::getKey, String.CASE_INSENSITIVE_ORDER));
        PropertiesList propertiesList = (PropertiesList)PsiTreeUtil.findChildOfType((PsiElement)file.getContainingFile(), PropertiesList.class);
        if (propertiesList == null) {
            return;
        }
        char delimiter = PropertiesCodeStyleSettings.getInstance(file.getProject()).getDelimiter();
        StringBuilder rawText = new StringBuilder(propertiesList.getDocCommentText());
        for (int i = 0; i < properties.size(); ++i) {
            String key;
            IProperty property = (IProperty)properties.get(i);
            String value = property.getValue();
            String commentAboveProperty = property.getDocCommentText();
            if (commentAboveProperty != null) {
                rawText.append(commentAboveProperty);
            }
            if ((key = property.getKey()) == null) continue;
            String propertyText = PropertiesElementFactory.getPropertyText(key, value != null ? value : "", Character.valueOf(delimiter), null, PropertyKeyValueFormat.FILE);
            rawText.append(propertyText);
            if (i == properties.size() - 1) continue;
            rawText.append("\n");
        }
        PropertiesFile fakeFile = PropertiesElementFactory.createPropertiesFile(file.getProject(), rawText.toString());
        PropertiesList fakePropertiesList = (PropertiesList)PsiTreeUtil.findChildOfType((PsiElement)fakeFile.getContainingFile(), PropertiesList.class);
        LOG.assertTrue(fakePropertiesList != null);
        propertiesList.replace((PsiElement)fakePropertiesList);
    }

    @NotNull
    public String getShortName() {
        return "AlphaUnsortedPropertiesFile";
    }

    private static final class PropertiesSorterQuickFix
    implements LocalQuickFix {
        private final boolean myOnlyCurrentFile;

        private PropertiesSorterQuickFix(boolean onlyCurrentFile) {
            this.myOnlyCurrentFile = onlyCurrentFile;
        }

        @NotNull
        public String getFamilyName() {
            return PropertiesBundle.message("properties.sorter.quick.fix.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Collection<PropertiesFile> filesToSort = this.getFilesToSort(descriptor.getPsiElement().getContainingFile());
            boolean force = filesToSort.size() == 1;
            for (PropertiesFile file : filesToSort) {
                if (!force && file.isAlphaSorted()) continue;
                AlphaUnsortedPropertiesFileInspection.sortPropertiesFile(file);
            }
        }

        @NotNull
        private Collection<PropertiesFile> getFilesToSort(@NotNull PsiFile file) {
            PropertiesFile propertiesFile = AlphaUnsortedPropertiesFileInspection.findPropertiesFile(file);
            if (propertiesFile == null) {
                return Collections.emptyList();
            }
            if (this.myOnlyCurrentFile) {
                return Collections.singleton(propertiesFile);
            }
            return propertiesFile.getResourceBundle().getPropertiesFiles();
        }
    }
}

