/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesInspectionBase;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class UseEllipsisInPropertyInspection
extends PropertiesInspectionBase {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Charset charset = EncodingProjectManager.getInstance((Project)holder.getProject()).getDefaultCharsetForPropertiesFiles(null);
        if (charset != StandardCharsets.UTF_8) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (!(element instanceof PropertyValueImpl)) {
                    return;
                }
                boolean found = UseEllipsisInPropertyInspection.getThreeDots(((PropertyValueImpl)element).getChars());
                if (found) {
                    int length = element.getTextLength();
                    holder.registerProblem(element, TextRange.create((int)(length - 3), (int)length), PropertiesBundle.message("inspection.use.ellipsis.in.property.description", new Object[0]), new LocalQuickFix[]{ReplaceThreeDotsWithEllipsisFix.getInstance()});
                }
            }
        };
    }

    private static boolean getThreeDots(@NotNull CharSequence element) {
        int textLength = element.length();
        if (textLength <= 4) {
            return false;
        }
        if (element.charAt(textLength - 3) != '.') {
            return false;
        }
        if (element.charAt(textLength - 2) != '.') {
            return false;
        }
        if (element.charAt(textLength - 1) != '.') {
            return false;
        }
        return element.charAt(textLength - 4) != '.';
    }

    private static final class ReplaceThreeDotsWithEllipsisFix
    implements LocalQuickFix {
        private static volatile ReplaceThreeDotsWithEllipsisFix instance;

        private ReplaceThreeDotsWithEllipsisFix() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static ReplaceThreeDotsWithEllipsisFix getInstance() {
            if (instance != null) return instance;
            Class<ReplaceThreeDotsWithEllipsisFix> clazz = ReplaceThreeDotsWithEllipsisFix.class;
            synchronized (ReplaceThreeDotsWithEllipsisFix.class) {
                if (instance != null) return instance;
                instance = new ReplaceThreeDotsWithEllipsisFix();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        @NotNull
        public String getFamilyName() {
            return PropertiesBundle.message("use.ellipsis.fix.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PropertyValueImpl)) {
                return;
            }
            boolean found = UseEllipsisInPropertyInspection.getThreeDots(((PropertyValueImpl)element).getChars());
            if (found) {
                int length = element.getTextLength();
                StringBuilder newText = new StringBuilder(((PropertyValueImpl)element).getChars());
                newText.replace(length - 3, length, "\u2026");
                ((PropertyValueImpl)element).replaceWithText(newText.toString());
            }
        }
    }
}

