/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.actions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.actions.CopyPropertyValueToClipboardIntention;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;

public final class CopyPropertyKeyToClipboardIntention
implements IntentionAction,
LowPriorityAction {
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return PropertiesBundle.message("copy.property.key.to.clipboard.intention.family.name", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return file.getLanguage().isKindOf((Language)PropertiesLanguage.INSTANCE) && CopyPropertyValueToClipboardIntention.getProperty(editor, file) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        Property property = CopyPropertyValueToClipboardIntention.getProperty(editor, file);
        if (property == null) {
            return;
        }
        String key = property.getUnescapedKey();
        if (key == null) {
            return;
        }
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(key));
    }

    public boolean startInWriteAction() {
        return false;
    }
}

