/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.properties.CustomResourceBundle;
import com.intellij.lang.properties.EmptyResourceBundle;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyKeyIndex;
import com.intellij.lang.properties.xml.XmlPropertiesFileImpl;
import com.intellij.lang.properties.xml.XmlPropertiesIndex;
import com.intellij.lang.properties.xml.XmlProperty;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertiesImplUtil
extends PropertiesUtil {
    @NotNull
    public static ResourceBundleWithCachedFiles getResourceBundleWithCachedFiles(@NotNull PropertiesFile representative) {
        return (ResourceBundleWithCachedFiles)ReadAction.compute(() -> {
            PsiFile containingFile = representative.getContainingFile();
            if (!containingFile.isValid()) {
                return ResourceBundleWithCachedFiles.EMPTY;
            }
            ResourceBundleManager manager = ResourceBundleManager.getInstance(representative.getProject());
            CustomResourceBundle customResourceBundle = manager.getCustomResourceBundle(representative);
            if (customResourceBundle != null) {
                return new ResourceBundleWithCachedFiles(customResourceBundle, customResourceBundle.getPropertiesFiles());
            }
            VirtualFile virtualFile = representative.getVirtualFile();
            if (virtualFile == null) {
                return ResourceBundleWithCachedFiles.EMPTY;
            }
            if (manager.isDefaultDissociated(virtualFile)) {
                return new ResourceBundleWithCachedFiles(new ResourceBundleImpl(representative), Collections.singletonList(representative));
            }
            String baseName = manager.getBaseName(containingFile);
            String extension = containingFile.getVirtualFile().getExtension();
            PsiDirectory directory = containingFile.getContainingDirectory();
            if (directory == null) {
                return ResourceBundleWithCachedFiles.EMPTY;
            }
            ResourceBundleWithCachedFiles bundle = PropertiesImplUtil.getResourceBundle(baseName, extension, directory);
            return bundle == null ? new ResourceBundleWithCachedFiles(new ResourceBundleImpl(representative), Collections.singletonList(representative)) : bundle;
        });
    }

    @NotNull
    public static List<PropertiesFile> getResourceBundleFiles(@NotNull PropertiesFile representative) {
        return PropertiesImplUtil.getResourceBundleWithCachedFiles(representative).getFiles();
    }

    @NotNull
    public static ResourceBundle getResourceBundle(@NotNull PropertiesFile representative) {
        return PropertiesImplUtil.getResourceBundleWithCachedFiles(representative).getBundle();
    }

    @Nullable
    private static ResourceBundleWithCachedFiles getResourceBundle(@NotNull String baseName, @Nullable String extension, @NotNull PsiDirectory baseDirectory) {
        ResourceBundleManager bundleBaseNameManager = ResourceBundleManager.getInstance(baseDirectory.getProject());
        List<PropertiesFile> bundleFiles = Stream.of(baseDirectory.isValid() ? baseDirectory.getFiles() : PsiFile.EMPTY_ARRAY).filter(f -> PropertiesImplUtil.isPropertiesFile(f) && Comparing.strEqual((String)f.getVirtualFile().getExtension(), (String)extension) && Objects.equals(bundleBaseNameManager.getBaseName((PsiFile)f), baseName)).map(PropertiesImplUtil::getPropertiesFile).collect(Collectors.toList());
        if (bundleFiles.isEmpty()) {
            return null;
        }
        return new ResourceBundleWithCachedFiles(new ResourceBundleImpl((PropertiesFile)bundleFiles.get(0)), bundleFiles);
    }

    public static boolean isPropertiesFile(@Nullable PsiFile file) {
        return PropertiesImplUtil.getPropertiesFile(file) != null;
    }

    @Nullable
    public static PropertiesFile getPropertiesFile(@NotNull VirtualFile file, @NotNull Project project) {
        return PropertiesImplUtil.getPropertiesFile(PsiManager.getInstance((Project)project).findFile(file));
    }

    @Contract(value="null -> null")
    @Nullable
    public static PropertiesFile getPropertiesFile(@Nullable PsiFile file) {
        if (!PropertiesImplUtil.canBePropertyFile(file)) {
            return null;
        }
        return file instanceof PropertiesFile ? (PropertiesFile)file : XmlPropertiesFileImpl.getPropertiesFile(file);
    }

    public static boolean canBePropertyFile(PsiFile file) {
        return file instanceof PropertiesFile || file instanceof XmlFile && file.getFileType() == XmlFileType.INSTANCE;
    }

    @Nullable
    public static PropertiesFile getPropertiesFile(@Nullable PsiElement element) {
        if (!(element instanceof PsiFile)) {
            return null;
        }
        return PropertiesImplUtil.getPropertiesFile((PsiFile)element);
    }

    @NotNull
    public static List<IProperty> findPropertiesByKey(@NotNull Project project, @NotNull String key) {
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        ArrayList<IProperty> properties = new ArrayList<IProperty>(PropertyKeyIndex.getInstance().get(key, project, scope));
        HashSet files = new HashSet();
        FileBasedIndex.getInstance().processValues(XmlPropertiesIndex.NAME, (Object)new XmlPropertiesIndex.Key(key), null, (file, value) -> {
            PropertiesFile propertiesFile;
            PsiFile psiFile;
            if (files.add(file) && (psiFile = PsiManager.getInstance((Project)project).findFile(file)) != null && (propertiesFile = XmlPropertiesFileImpl.getPropertiesFile(psiFile)) != null) {
                properties.addAll(propertiesFile.findPropertiesByKey(key));
            }
            return true;
        }, scope);
        return properties;
    }

    @Nullable
    public static ResourceBundle createByUrl(@NotNull String url, @NotNull Project project) {
        int idx = url.lastIndexOf(47);
        if (idx == -1) {
            return null;
        }
        String baseDirectoryName = url.substring(0, idx);
        String baseName = url.substring(idx + 1);
        VirtualFile baseDirectoryVirtualFile = VirtualFileManager.getInstance().findFileByUrl(baseDirectoryName);
        if (baseDirectoryVirtualFile == null) {
            return null;
        }
        PsiDirectory baseDirectory = PsiManager.getInstance((Project)project).findDirectory(baseDirectoryVirtualFile);
        if (baseDirectory == null) {
            return null;
        }
        ResourceBundleManager bundleBaseNameManager = ResourceBundleManager.getInstance(project);
        for (PsiFile file : baseDirectory.getFiles()) {
            String currBaseName;
            PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(file);
            if (propertiesFile == null || !(currBaseName = bundleBaseNameManager.getBaseName(file)).equals(baseName)) continue;
            return PropertiesImplUtil.getResourceBundle(propertiesFile);
        }
        return null;
    }

    public static boolean isAlphaSorted(@NotNull Collection<? extends IProperty> properties) {
        String previousKey = null;
        for (IProperty iProperty : properties) {
            String key = iProperty.getKey();
            if (key == null) {
                return false;
            }
            if (previousKey != null && String.CASE_INSENSITIVE_ORDER.compare(previousKey, key) > 0) {
                return false;
            }
            previousKey = key;
        }
        return true;
    }

    @Nullable
    public static IProperty getProperty(@Nullable PsiElement element) {
        PomTarget target;
        if (element instanceof IProperty) {
            return (IProperty)element;
        }
        if (element instanceof PomTargetPsiElement && (target = ((PomTargetPsiElement)element).getTarget()) instanceof XmlProperty) {
            return (IProperty)target;
        }
        return null;
    }

    public static final class ResourceBundleWithCachedFiles {
        private static final ResourceBundleWithCachedFiles EMPTY = new ResourceBundleWithCachedFiles(EmptyResourceBundle.getInstance(), Collections.emptyList());
        private final ResourceBundle myBundle;
        private final List<PropertiesFile> myFiles;

        private ResourceBundleWithCachedFiles(@NotNull ResourceBundle bundle, @NotNull List<PropertiesFile> files) {
            this.myBundle = bundle;
            this.myFiles = files;
        }

        @NotNull
        public ResourceBundle getBundle() {
            return this.myBundle;
        }

        @NotNull
        public List<PropertiesFile> getFiles() {
            return this.myFiles;
        }
    }
}

