/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.CustomResourceBundleState;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomResourceBundle
extends ResourceBundle {
    private static final Logger LOG = Logger.getInstance(CustomResourceBundle.class);
    private final List<PropertiesFile> myFiles;
    private final String myBaseName;

    private CustomResourceBundle(List<PropertiesFile> files, @NotNull String baseName) {
        LOG.assertTrue(!files.isEmpty());
        this.myFiles = ContainerUtil.sorted(files, Comparator.comparing(PropertiesFile::getName));
        this.myBaseName = baseName;
    }

    public static CustomResourceBundle fromState(CustomResourceBundleState state, Project project) {
        List files = ContainerUtil.mapNotNull(state.getFiles(VirtualFileManager.getInstance()), virtualFile -> PropertiesImplUtil.getPropertiesFile(virtualFile, project));
        return files.size() < 2 ? null : new CustomResourceBundle(files, state.getBaseName());
    }

    @Override
    @NotNull
    public List<PropertiesFile> getPropertiesFiles() {
        return this.myFiles;
    }

    @Override
    @NotNull
    public PropertiesFile getDefaultPropertiesFile() {
        return (PropertiesFile)ContainerUtil.getFirstItem(this.myFiles);
    }

    @Override
    @NotNull
    public String getBaseName() {
        return this.myBaseName;
    }

    @Override
    @Nullable
    public VirtualFile getBaseDirectory() {
        VirtualFile baseDir = null;
        for (PropertiesFile file : this.myFiles) {
            VirtualFile currentBaseDir = file.getContainingFile().getVirtualFile().getParent();
            if (baseDir == null) {
                baseDir = currentBaseDir;
                continue;
            }
            if (baseDir.equals(currentBaseDir)) continue;
            return null;
        }
        return baseDir;
    }

    @Override
    public boolean isValid() {
        for (PropertiesFile file : this.myFiles) {
            if (file.getContainingFile().isValid()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomResourceBundle resourceBundle = (CustomResourceBundle)o;
        return resourceBundle.getPropertiesFiles().equals(this.getPropertiesFiles()) && resourceBundle.getBaseName().equals(this.getBaseName());
    }

    public int hashCode() {
        return this.myFiles.hashCode() * 31 + this.myBaseName.hashCode();
    }
}

