/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.android;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gct.testing.CloudConfigurationHelper;
import com.google.gct.testing.android.CloudConfiguration;
import com.google.gct.testing.android.CloudConfigurationCoordinator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.combobox.ListComboBoxModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudConfigurationComboBox
extends ComboboxWithBrowseButton {
    private static final List<String> LOADING_CONFIGURATIONS = ImmutableList.of((Object)"Loading configurations...");
    private final CloudConfiguration.Kind myConfigurationKind;
    private int myCurrentAndroidConfigurationId = -1;
    private Module myCurrentModule;
    private AndroidFacet myCurrentFacet;
    private volatile List<? extends CloudConfiguration> myTestingConfigurations;
    private ActionListener myActionListener;
    private static Map<CloudConfiguration.Kind, CloudConfiguration> myLastChosenCloudConfigurationPerKind = Maps.newHashMapWithExpectedSize((int)5);
    private static Map<Integer, Map<Pair<CloudConfiguration.Kind, Module>, CloudConfiguration>> myMatrixConfigurationByAndroidConfigurationIdAndModuleCache = Maps.newHashMapWithExpectedSize((int)5);

    public CloudConfigurationComboBox(@NotNull CloudConfiguration.Kind configurationKind) {
        this.myConfigurationKind = configurationKind;
        this.setMinimumSize(new Dimension(JBUI.scale((int)100), this.getMinimumSize().height));
        this.getComboBox().setRenderer(new TestConfigurationRenderer());
        this.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object item = CloudConfigurationComboBox.this.getComboBox().getSelectedItem();
                if (item instanceof CloudConfiguration) {
                    CloudConfigurationComboBox.this.rememberCloudConfiguration((CloudConfiguration)item);
                }
            }
        });
        CloudConfigurationCoordinator.getInstance(this.myConfigurationKind).addComboBox(this);
    }

    public void setFacet(@Nullable AndroidFacet facet) {
        if (facet == null) {
            return;
        }
        this.myCurrentFacet = facet;
        this.myCurrentModule = this.myCurrentFacet.getModule();
        this.removeActionListener(this.myActionListener);
        this.getComboBox().setModel(new ListComboBoxModel(LOADING_CONFIGURATIONS));
        this.setEnabled(false);
        this.myActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudConfiguration selectedConfig = CloudConfigurationHelper.openMatrixConfigurationDialog(CloudConfigurationComboBox.this.myCurrentFacet, (CloudConfiguration)CloudConfigurationComboBox.this.getComboBox().getSelectedItem(), CloudConfigurationComboBox.this.myConfigurationKind);
                List<? extends CloudConfiguration> cloudConfigurations = CloudConfigurationHelper.getCloudConfigurations(CloudConfigurationComboBox.this.myCurrentFacet, CloudConfigurationComboBox.this.myConfigurationKind);
                CloudConfigurationCoordinator.getInstance(CloudConfigurationComboBox.this.myConfigurationKind).updateComboBoxesWithNewCloudConfigurations(cloudConfigurations, CloudConfigurationComboBox.this.myCurrentModule);
                if (cloudConfigurations.isEmpty() || selectedConfig != null) {
                    CloudConfigurationComboBox.this.getComboBox().setSelectedItem(selectedConfig);
                }
                CloudConfigurationComboBox.this.getComboBox().updateUI();
            }
        };
        this.addActionListener(this.myActionListener);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                CloudConfigurationComboBox.this.myTestingConfigurations = CloudConfigurationHelper.getCloudConfigurations(CloudConfigurationComboBox.this.myCurrentFacet, CloudConfigurationComboBox.this.myConfigurationKind);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CloudConfigurationComboBox.this.updateContent();
                        CloudConfigurationComboBox.this.setEnabled(true);
                    }
                });
            }
        });
    }

    public void setRunConfigurationId(int configurationId) {
        this.myCurrentAndroidConfigurationId = configurationId;
    }

    public void dispose() {
        CloudConfigurationCoordinator.getInstance(this.myConfigurationKind).removeComboBox(this);
        super.dispose();
    }

    public void selectCloudConfiguration(int cloudConfigurationId) {
        if (this.myTestingConfigurations != null) {
            for (CloudConfiguration cloudConfiguration : this.myTestingConfigurations) {
                if (cloudConfiguration.getId() != cloudConfigurationId) continue;
                this.getComboBox().setSelectedItem(cloudConfiguration);
                this.rememberCloudConfiguration(cloudConfiguration);
                return;
            }
        }
    }

    private void rememberCloudConfiguration(CloudConfiguration cloudConfiguration) {
        myLastChosenCloudConfigurationPerKind.put(this.myConfigurationKind, cloudConfiguration);
        if (this.myCurrentAndroidConfigurationId != -1 && this.myCurrentModule != null) {
            HashMap matrixConfigurationByModuleCache = myMatrixConfigurationByAndroidConfigurationIdAndModuleCache.get(this.myCurrentAndroidConfigurationId);
            if (matrixConfigurationByModuleCache == null) {
                matrixConfigurationByModuleCache = Maps.newHashMapWithExpectedSize((int)5);
                myMatrixConfigurationByAndroidConfigurationIdAndModuleCache.put(this.myCurrentAndroidConfigurationId, matrixConfigurationByModuleCache);
            }
            matrixConfigurationByModuleCache.put(Pair.create((Object)((Object)this.myConfigurationKind), (Object)this.myCurrentModule), cloudConfiguration);
        }
    }

    private void updateContent() {
        if (this.myCurrentModule == null || this.myCurrentModule.isDisposed()) {
            return;
        }
        this.getComboBox().setModel(new ListComboBoxModel(this.myTestingConfigurations));
        if (this.myCurrentAndroidConfigurationId == -1) {
            CloudConfiguration cloudConfiguration = myLastChosenCloudConfigurationPerKind.get((Object)this.myConfigurationKind);
            if (cloudConfiguration != null && this.myTestingConfigurations.contains(cloudConfiguration)) {
                this.getComboBox().setSelectedItem(cloudConfiguration);
            }
        } else {
            CloudConfiguration selectedConfig;
            Map<Pair<CloudConfiguration.Kind, Module>, CloudConfiguration> matrixConfigurationByModuleCache = myMatrixConfigurationByAndroidConfigurationIdAndModuleCache.get(this.myCurrentAndroidConfigurationId);
            if (matrixConfigurationByModuleCache != null && (selectedConfig = matrixConfigurationByModuleCache.get(Pair.create((Object)((Object)this.myConfigurationKind), (Object)this.myCurrentModule))) != null && this.myTestingConfigurations.contains(selectedConfig)) {
                this.getComboBox().setSelectedItem(selectedConfig);
            }
        }
    }

    public void updateCloudConfigurations(List<? extends CloudConfiguration> cloudConfigurations, Module module) {
        if (this.myCurrentFacet != null && this.myCurrentModule.equals(module)) {
            this.myTestingConfigurations = cloudConfigurations;
            int selectedConfigurationId = -1;
            Object selectedItem = this.getComboBox().getSelectedItem();
            if (selectedItem != null) {
                selectedConfigurationId = ((CloudConfiguration)selectedItem).getId();
            }
            this.updateContent();
            this.selectCloudConfiguration(selectedConfigurationId);
        }
    }

    private static class TestConfigurationRenderer
    extends ColoredListCellRenderer {
        private TestConfigurationRenderer() {
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value == null) {
                this.append("[none]", SimpleTextAttributes.ERROR_ATTRIBUTES);
            } else if (value instanceof CloudConfiguration) {
                CloudConfiguration config = (CloudConfiguration)value;
                this.append(config.getDisplayName(), config.getDeviceConfigurationCount() < 1 ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.setIcon(config.getIcon());
            } else {
                this.append(String.valueOf(value));
            }
        }
    }
}

