/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.google.gct.testing.CloudConfigurationHelper;
import com.google.gct.testing.CloudConfigurationImpl;
import com.google.gct.testing.android.CloudConfiguration;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudTestingUtils {
    public static final String PRICING_LINK = "https://firebase.google.com/pricing";
    public static final String CREATE_FIREBASE_PROJECT_LINK = "https://console.firebase.google.com";
    public static final String ANDROID_STUDIO_URL_FLAG = "?source=android-studio";
    private static final String GOOGLE_GROUP_URL = "'https://firebase.google.com/support'";
    private static final String SHOW_GOOGLE_CLOUD_TESTING_TIMESTAMPS = "show.google.cloud.testing.timestamps";
    public static final String SET_TEST_RUN_ID = "setTestRunId";
    public static final String SET_ACTIVE_CLOUD_MATRIX = "setActiveCloudMatrix";
    public static final String TEST_CONFIGURATION_STOPPED = "testConfigurationStopped";
    public static final String TEST_CONFIGURATION_STARTED = "testConfigurationStarted";
    public static final String TEST_CONFIGURATION_PROGRESS = "testConfigurationProgress";
    public static final String TEST_CONFIGURATION_SCHEDULED = "testConfigurationScheduled";
    public static final String TEST_CONFIGURATION_FINISHED = "testConfigurationFinished";
    public static Icon CLOUD_DEVICE_ICON;
    public static Icon CLOUD_DEBUG_ICON;
    private static final Logger LOG;

    public static boolean shouldShowProgressTimestamps() {
        return Boolean.getBoolean(SHOW_GOOGLE_CLOUD_TESTING_TIMESTAMPS);
    }

    public static CloudConfigurationImpl getConfigurationById(int id, AndroidFacet facet) {
        for (CloudConfiguration cloudConfiguration : CloudConfigurationHelper.getAllCloudConfigurations(facet)) {
            if (cloudConfiguration.getId() != id) continue;
            return (CloudConfigurationImpl)cloudConfiguration;
        }
        return null;
    }

    public static String prepareTestSpecification(AndroidTestRunConfiguration testRunConfiguration) {
        switch (testRunConfiguration.TESTING_TYPE) {
            case 3: {
                return "class " + testRunConfiguration.CLASS_NAME + "#" + testRunConfiguration.METHOD_NAME;
            }
            case 2: {
                return "class " + testRunConfiguration.CLASS_NAME;
            }
            case 1: {
                return "package " + testRunConfiguration.PACKAGE_NAME;
            }
            case 0: {
                return "";
            }
        }
        throw new IllegalStateException("Unsupported testing type: " + testRunConfiguration.TESTING_TYPE);
    }

    public static boolean checkJavaVersion() {
        String javaVersion = System.getProperty("java.version");
        String[] versionParts = javaVersion.split("\\.");
        if (Double.parseDouble(versionParts[0] + "." + versionParts[1]) < 1.8) {
            final String message = "<html>You are using Java <b>" + javaVersion + "</b>.<br>Due to security reasons, to launch firebase devices, you need to upgrade to Java <b>1.8</b> or higher.<br>You can download the latest Java release from <a href='https://java.com'>here</a>.</html>";
            final Project project = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showDialog((Project)project, (String)message, (String)"Your Java is too old for launching firebase devices!", (String[])new String[]{"Cancel"}, (int)0, null);
                }
            });
            return false;
        }
        return true;
    }

    public static void showBalloonMessage(final Project project, final String message, final MessageType type, final int delaySeconds) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
                JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, type, null).setFadeoutTime((long)(delaySeconds * 1000)).createBalloon().show(RelativePoint.getCenterOf((JComponent)statusBar.getComponent()), Balloon.Position.atRight);
            }
        });
    }

    public static void showErrorMessage(@Nullable Project project, String errorDialogTitle, String errorMessage) {
        int newLineIndex = errorMessage.indexOf(10);
        String userErrorMessage = newLineIndex != -1 ? errorMessage.substring(0, newLineIndex) : errorMessage;
        String detailedErrorMessage = newLineIndex != -1 ? "<html><a href='https://firebase.google.com/support'>Report this issue</a> (please copy/paste the text below into the form)<br><br>" + CloudTestingUtils.getDetailedErrorMessage(errorMessage.substring(newLineIndex + 1)) + "</html>" : "No details...";
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.CLOUD_TESTING).setKind(AndroidStudioEvent.EventKind.CLOUD_TESTING_BACKEND_ERROR).setCloudTestingErrorMessage(userErrorMessage), (Project)project));
        CloudTestingUtils.showCascadingErrorMessages(project, errorDialogTitle, userErrorMessage, detailedErrorMessage);
    }

    private static String getDetailedErrorMessage(String errorMessage) {
        int debugInfoStartIndex;
        int debugInfoEndIndex;
        String debugInfoField = "\"debugInfo\" : \"";
        int debugInfoIndex = ((String)errorMessage).indexOf(debugInfoField);
        if (debugInfoIndex != -1 && (debugInfoEndIndex = ((String)errorMessage).indexOf(34, debugInfoStartIndex = debugInfoIndex + debugInfoField.length())) != -1) {
            String debugInfo = ((String)errorMessage).substring(debugInfoStartIndex, debugInfoEndIndex);
            errorMessage = ((String)errorMessage).substring(0, debugInfoIndex) + ((String)errorMessage).substring(debugInfoEndIndex + 2);
            String unescapedDebugInfo = debugInfo.replace("\\n", "\n").replace("\\t", "\t");
            errorMessage = (String)errorMessage + "\n\nDEBUG INFO:\n" + unescapedDebugInfo;
        }
        return ((String)errorMessage).replace("\n", "<br>").replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
    }

    private static void showCascadingErrorMessages(final @Nullable Project project, final String errorDialogTitle, String userErrorMessage, final String detailedErrorMessage) {
        new Notification(errorDialogTitle, "", String.format("<b>%s</b> <a href=''>Details</a>", userErrorMessage), NotificationType.WARNING).setListener((NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                notification.expire();
                Messages.showDialog((Project)project, (String)detailedErrorMessage, (String)errorDialogTitle, (String[])new String[]{"Cancel"}, (int)0, null);
            }
        }).notify(project == null || project.isDefault() ? null : project);
    }

    public static GridBagConstraints createConfigurationChooserGbc(int x, int y) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = x == 0 ? 17 : 13;
        gbc.fill = x == 0 ? 1 : 2;
        gbc.insets = x == 0 && y == 0 ? new Insets(5, 7, 5, 5) : new Insets(5, 5, 5, 5);
        gbc.weightx = x == 0 ? 0.1 : 1.0;
        gbc.weighty = 0.0;
        return gbc;
    }

    public static GridBagConstraints createCloudTestOptionGbc(int x, int y, boolean isExtendedDeviceChooserDialog) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = x == 0 ? 17 : 17;
        gbc.fill = x == 0 ? 1 : 1;
        int leftFirstInsets = isExtendedDeviceChooserDialog ? 21 : 20;
        int leftSecondInsets = isExtendedDeviceChooserDialog ? 49 : 58;
        gbc.insets = x == 0 ? new Insets(0, leftFirstInsets, 0, 0) : new Insets(0, leftSecondInsets, 0, 0);
        gbc.weightx = x == 0 ? 0.0 : 1.0;
        gbc.weighty = 0.0;
        return gbc;
    }

    public static Color makeDarker(Color color, int shades) {
        if (shades < 1) {
            return color;
        }
        return CloudTestingUtils.makeDarker(ColorUtil.darker((Color)color, (int)1), shades - 1);
    }

    public static String preparePricingAnchor(String linkText) {
        return "<a href='https://firebase.google.com/pricing'>" + linkText + "</a>";
    }

    public static String prepareCreateFirebaseProjectAnchor(String linkText) {
        return "<a href='https://console.firebase.google.com'>" + linkText + "</a>";
    }

    public static void linkifyEditorPane(@NotNull JEditorPane editorPane, @NotNull Color backgroundColor) {
        editorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        editorPane.setEditable(false);
        editorPane.setBackground(backgroundColor);
        editorPane.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
    }

    public static void addToInvokeLater(Runnable runnable) {
        Application application = ApplicationManager.getApplication();
        if (application.isHeadlessEnvironment() && !application.isUnitTestMode()) {
            runnable.run();
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable);
        }
    }

    public static void runInEventDispatchThread(Runnable runnable, ModalityState state) {
        try {
            ApplicationManager.getApplication().invokeAndWait(runnable, state);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    static {
        LOG = Logger.getInstance((String)CloudTestingUtils.class.getName());
        try {
            CLOUD_DEBUG_ICON = new ImageIcon(ImageIO.read(CloudTestingUtils.class.getResourceAsStream("CloudDebug.png")));
        }
        catch (Exception e) {
            CLOUD_DEBUG_ICON = AllIcons.Actions.StartDebugger;
        }
        try {
            CLOUD_DEVICE_ICON = new ImageIcon(ImageIO.read(CloudTestingUtils.class.getResourceAsStream("CloudDevice.png")));
        }
        catch (Exception e) {
            CLOUD_DEVICE_ICON = StudioIcons.Avd.DEVICE_PHONE;
        }
    }

    public static enum ConfigurationStopReason {
        FINISHED,
        INFRASTRUCTURE_FAILURE,
        TRIGGERING_ERROR,
        TIMED_OUT;

    }
}

