/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gct.testing.CloudConfigurationHelper;
import com.google.gct.testing.CloudConfigurationImpl;
import com.google.gct.testing.CloudTestingUtils;
import com.google.gct.testing.TwoPanelTree;
import com.google.gct.testing.TwoPanelTreeDimensionSelectionEvent;
import com.google.gct.testing.TwoPanelTreeSelectionListener;
import com.google.gct.testing.TwoPanelTreeTypeGroupSelectionEvent;
import com.google.gct.testing.TwoPanelTreeTypeSelectionEvent;
import com.google.gct.testing.android.CloudConfiguration;
import com.google.gct.testing.dimension.ConfigurationChangeEvent;
import com.google.gct.testing.dimension.ConfigurationChangeListener;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.execution.ExecutionBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class CloudConfigurationChooserDialog
extends DialogWrapper
implements ConfigurationChangeListener {
    private final List<CloudConfigurationImpl> editableConfigurations;
    private final List<CloudConfigurationImpl> defaultConfigurations;
    private final MyAddAction myAddAction;
    private final MyRemoveAction myRemoveAction;
    private final MyCopyActionButton myCopyActionButton;
    private final MyMoveUpAction myMoveUpAction;
    private final MyMoveDownAction myMoveDownAction;
    private final DefaultMutableTreeNode customRoot;
    private final DefaultMutableTreeNode defaultsRoot;
    private final CloudConfiguration.Kind configurationKind;
    private JPanel myPanel;
    private final Splitter mySplitter;
    private JPanel myConfigurationPanel;
    private JTextField myConfigurationName;
    private Tree myConfigurationTree;
    private JPanel myConfigurationTreePanel;
    private JLabel myConfigurationNameLabel;
    private JLabel myGroupDescriptionLabel;
    private JPanel myConfigurationEditorPanel;
    private JPanel myConfigurationInfoPanel;
    private JLabel myConfigurationInfoLabel;
    private JLabel myDimensionNameLabel;
    private ToolbarDecorator myToolbarDecorator;
    private CloudConfigurationImpl selectedConfiguration;
    private final AndroidFacet facet;
    LoadingCache<CloudConfigurationImpl, TwoPanelTree> dimensionTreeCache;

    public CloudConfigurationChooserDialog(Module module, List<CloudConfigurationImpl> editableConfigurations, List<CloudConfigurationImpl> defaultConfigurations, CloudConfigurationImpl initiallySelectedConfiguration, @NotNull CloudConfiguration.Kind configurationKind) {
        super(module.getProject(), true);
        this.$$$setupUI$$$();
        this.myAddAction = new MyAddAction();
        this.myRemoveAction = new MyRemoveAction();
        this.myCopyActionButton = new MyCopyActionButton();
        this.myMoveUpAction = new MyMoveUpAction();
        this.myMoveDownAction = new MyMoveDownAction();
        this.customRoot = new DefaultMutableTreeNode("Custom");
        this.defaultsRoot = new DefaultMutableTreeNode("Defaults");
        this.mySplitter = new Splitter(false);
        this.dimensionTreeCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CloudConfigurationImpl, TwoPanelTree>(){

            public TwoPanelTree load(CloudConfigurationImpl configuration) throws Exception {
                TwoPanelTree tree = new TwoPanelTree(configuration);
                TwoPanelTreeSelectionListener treeSelectionListener = new TwoPanelTreeSelectionListener(){

                    @Override
                    public void dimensionSelectionChanged(TwoPanelTreeDimensionSelectionEvent e) {
                        CloudConfigurationChooserDialog.this.myDimensionNameLabel.setText("");
                        CloudConfigurationChooserDialog.this.myConfigurationInfoLabel.setText("");
                    }

                    @Override
                    public void typeSelectionChanged(TwoPanelTreeTypeSelectionEvent e) {
                        CloudConfigurationChooserDialog.this.myDimensionNameLabel.setText(e.getType().getConfigurationDialogDisplayName());
                        Object details = "<html><table cellpadding='0'>";
                        for (Map.Entry<String, String> entry : e.getType().getDetails().entrySet()) {
                            details = (String)details + "<tr><td>" + entry.getKey() + ":&nbsp;</td><td>" + entry.getValue() + "</td></tr>";
                        }
                        details = (String)details + "</table>";
                        if (!e.getCurrentDimension().getSupportedDomain().contains(e.getType())) {
                            details = (String)details + "<br><i>This option is not currently supported by Google Cloud.</i>";
                        }
                        details = (String)details + "</html>";
                        CloudConfigurationChooserDialog.this.myConfigurationInfoLabel.setText((String)details);
                    }

                    @Override
                    public void groupSelectionChanged(TwoPanelTreeTypeGroupSelectionEvent e) {
                        CloudConfigurationChooserDialog.this.myDimensionNameLabel.setText(e.getGroup().getDescription());
                        CloudConfigurationChooserDialog.this.myConfigurationInfoLabel.setText("");
                    }
                };
                tree.addSelectionListener(treeSelectionListener);
                return tree;
            }
        });
        this.configurationKind = configurationKind;
        this.myConfigurationInfoPanel.setPreferredSize(new Dimension(490, UIUtil.isUnderDarcula() ? 153 : 156));
        this.editableConfigurations = editableConfigurations;
        this.defaultConfigurations = defaultConfigurations;
        this.facet = AndroidFacet.getInstance((Module)module);
        if (configurationKind == CloudConfiguration.Kind.SINGLE_DEVICE) {
            this.setTitle("Single Device Configurations");
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.CLOUD_TESTING).setKind(AndroidStudioEvent.EventKind.CLOUD_TESTING_CONFIGURE_CLOUD_DEVICE), (Project)module.getProject()));
        } else {
            this.setTitle("Matrix Configurations");
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.CLOUD_TESTING).setKind(AndroidStudioEvent.EventKind.CLOUD_TESTING_CONFIGURE_MATRIX), (Project)module.getProject()));
        }
        this.getOKAction().setEnabled(true);
        this.myConfigurationTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath selectedPath = e.getPath();
                if (selectedPath.getPathCount() == 2) {
                    CloudConfigurationChooserDialog.this.updateConfigurationControls(false);
                    DefaultMutableTreeNode selectedGroup = (DefaultMutableTreeNode)selectedPath.getPath()[1];
                    if (selectedGroup.equals(CloudConfigurationChooserDialog.this.customRoot)) {
                        CloudConfigurationChooserDialog.this.myGroupDescriptionLabel.setText("User-defined configurations. To add a new one click ");
                        CloudConfigurationChooserDialog.this.myGroupDescriptionLabel.setIcon(IconUtil.getAddIcon());
                        CloudConfigurationChooserDialog.this.myGroupDescriptionLabel.setHorizontalTextPosition(2);
                    } else {
                        CloudConfigurationChooserDialog.this.myGroupDescriptionLabel.setText("Default configurations");
                        CloudConfigurationChooserDialog.this.myGroupDescriptionLabel.setIcon(null);
                    }
                    CloudConfigurationChooserDialog.this.selectedConfiguration = null;
                } else {
                    CloudConfigurationChooserDialog.this.updateConfigurationControls(true);
                    CloudConfigurationChooserDialog.this.selectedConfiguration = (CloudConfigurationImpl)((DefaultMutableTreeNode)selectedPath.getPath()[2]).getUserObject();
                    CloudConfigurationChooserDialog.this.myConfigurationName.setText(CloudConfigurationChooserDialog.this.selectedConfiguration.getName());
                    CloudConfigurationChooserDialog.this.myConfigurationName.setEnabled(CloudConfigurationChooserDialog.this.selectedConfiguration.isEditable());
                }
                CloudConfigurationChooserDialog.this.updateConfigurationDetailsPanel(CloudConfigurationChooserDialog.this.selectedConfiguration);
            }
        });
        this.myConfigurationTree.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                CloudConfigurationChooserDialog.this.myDimensionNameLabel.setText("");
                CloudConfigurationChooserDialog.this.myConfigurationInfoLabel.setText("");
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.myConfigurationTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                    if (node == CloudConfigurationChooserDialog.this.customRoot) {
                        this.append("Custom", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                        this.setIcon(StudioIcons.Common.ANDROID_HEAD);
                    } else if (node == CloudConfigurationChooserDialog.this.defaultsRoot) {
                        this.append("Defaults", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                        this.setIcon(AllIcons.General.Settings);
                    } else if (node.getUserObject() instanceof CloudConfigurationImpl) {
                        CloudConfigurationImpl config = (CloudConfigurationImpl)node.getUserObject();
                        boolean isInvalidConfiguration = config.getDeviceConfigurationCount() < 1;
                        boolean oldMySelected = this.mySelected;
                        if (isInvalidConfiguration) {
                            this.mySelected = false;
                        }
                        this.append(config.getDisplayName(), isInvalidConfiguration ? new SimpleTextAttributes(1, (Color)JBColor.RED) : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        this.mySelected = oldMySelected;
                        this.setIcon(config.getIcon());
                    }
                    this.setIconTextGap(2);
                }
            }
        });
        if (initiallySelectedConfiguration != null) {
            this.myConfigurationName.setText(initiallySelectedConfiguration.getName());
        }
        this.myConfigurationName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                CloudConfigurationChooserDialog.this.selectedConfiguration.setName(CloudConfigurationChooserDialog.this.myConfigurationName.getText());
            }
        });
        this.myDimensionNameLabel = new JLabel("", 2);
        Font currentFont = this.myDimensionNameLabel.getFont();
        this.myDimensionNameLabel.setFont(new Font(currentFont.getFontName(), 1, currentFont.getSize()));
        this.myConfigurationInfoPanel.add((Component)this.myDimensionNameLabel, CloudTestingUtils.createConfigurationChooserGbc(0, 0));
        this.myConfigurationInfoLabel = new JLabel("", 2);
        this.myConfigurationInfoPanel.add((Component)this.myConfigurationInfoLabel, CloudTestingUtils.createConfigurationChooserGbc(0, 1));
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Root");
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.myConfigurationTree.setModel((TreeModel)treeModel);
        this.myConfigurationTree.getSelectionModel().setSelectionMode(1);
        treeModel.insertNodeInto(this.customRoot, rootNode, 0);
        treeModel.insertNodeInto(this.defaultsRoot, rootNode, 1);
        this.selectTreeNode(this.customRoot);
        for (CloudConfigurationImpl configuration : editableConfigurations) {
            this.addConfigurationToTree(-1, configuration, configuration.equals(initiallySelectedConfiguration));
        }
        for (CloudConfigurationImpl configuration : defaultConfigurations) {
            this.addConfigurationToTree(-1, configuration, configuration.equals(initiallySelectedConfiguration));
        }
        Dimension preferredSize = this.myConfigurationTreePanel.getPreferredSize();
        preferredSize.width = Math.max(preferredSize.width, 350);
        preferredSize.height = Math.max(preferredSize.height, 440);
        this.myConfigurationTreePanel.setPreferredSize(preferredSize);
        this.myConfigurationTreePanel.add((Component)this.createLeftPanel(), "Center");
        this.mySplitter.setProportion(0.35f);
        this.mySplitter.setFirstComponent((JComponent)this.myConfigurationTreePanel);
        this.mySplitter.setSecondComponent((JComponent)this.myConfigurationPanel);
        this.myPanel.add((Component)this.mySplitter, "Center");
        treeModel.reload();
        this.expandAllRows(this.myConfigurationTree);
        this.init();
    }

    private void addConfigurationToTree(int index, CloudConfigurationImpl configuration, boolean makeSelected) {
        configuration.addConfigurationChangeListener(this);
        DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(configuration);
        if (configuration.isEditable()) {
            this.addChildToNode(index, newChild, this.customRoot);
        } else {
            this.addChildToNode(index, newChild, this.defaultsRoot);
        }
        if (makeSelected) {
            this.selectTreeNode(newChild);
        }
    }

    private void addChildToNode(int index, DefaultMutableTreeNode child, DefaultMutableTreeNode node) {
        if (index == -1) {
            node.add(child);
        } else {
            node.insert(child, index);
        }
    }

    private void selectTreeNode(final DefaultMutableTreeNode node) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeUtil.selectInTree((DefaultMutableTreeNode)node, (boolean)true, (JTree)CloudConfigurationChooserDialog.this.myConfigurationTree);
            }
        });
    }

    private void removeConfigurationFromTree(CloudConfigurationImpl configuration) {
        configuration.removeConfigurationChangeListener(this);
        MutableTreeNode toRemove = (MutableTreeNode)TreeUtil.findNodeWithObject((Object)configuration, (TreeModel)this.myConfigurationTree.getModel(), (Object)this.customRoot);
        this.customRoot.remove(toRemove);
    }

    private JPanel createLeftPanel() {
        this.myToolbarDecorator = ToolbarDecorator.createDecorator((JTree)this.myConfigurationTree).setAsUsualTopToolbar().setAddAction((AnActionButtonRunnable)this.myAddAction).setAddActionUpdater((AnActionButtonUpdater)this.myAddAction).setAddActionName(ExecutionBundle.message((String)"add.new.run.configuration.action2.name", (Object[])new Object[0])).setRemoveAction((AnActionButtonRunnable)this.myRemoveAction).setRemoveActionUpdater((AnActionButtonUpdater)this.myRemoveAction).setRemoveActionName(ExecutionBundle.message((String)"remove.run.configuration.action.name", (Object[])new Object[0])).setMoveUpAction((AnActionButtonRunnable)this.myMoveUpAction).setMoveUpActionUpdater((AnActionButtonUpdater)this.myMoveUpAction).setMoveUpActionName(ExecutionBundle.message((String)"move.up.action.name", (Object[])new Object[0])).setMoveDownAction((AnActionButtonRunnable)this.myMoveDownAction).setMoveDownActionUpdater((AnActionButtonUpdater)this.myMoveDownAction).setMoveDownActionName(ExecutionBundle.message((String)"move.down.action.name", (Object[])new Object[0])).addExtraAction((AnActionButton)this.myCopyActionButton).setButtonComparator(new String[]{ExecutionBundle.message((String)"add.new.run.configuration.action2.name", (Object[])new Object[0]), ExecutionBundle.message((String)"remove.run.configuration.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"copy.configuration.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"action.name.save.configuration", (Object[])new Object[0]), ExecutionBundle.message((String)"run.configuration.edit.default.configuration.settings.text", (Object[])new Object[0]), ExecutionBundle.message((String)"move.up.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"move.down.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"run.configuration.create.folder.text", (Object[])new Object[0])}).setForcedDnD();
        return this.myToolbarDecorator.createPanel();
    }

    private void updateConfigurationDetailsPanel(CloudConfigurationImpl configuration) {
        this.myConfigurationEditorPanel.removeAll();
        if (configuration != null) {
            this.myConfigurationInfoPanel.setVisible(true);
            try {
                this.myConfigurationEditorPanel.add(((TwoPanelTree)this.dimensionTreeCache.get((Object)configuration)).getPanel());
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            this.myConfigurationEditorPanel.updateUI();
        } else {
            this.myConfigurationInfoPanel.setVisible(false);
        }
    }

    private void updateConfigurationControls(boolean isRealConfiguration) {
        this.myConfigurationName.setVisible(isRealConfiguration);
        this.myConfigurationNameLabel.setVisible(isRealConfiguration);
        this.myGroupDescriptionLabel.setVisible(!isRealConfiguration);
    }

    private void expandAllRows(Tree tree) {
        for (int i = 0; i < tree.getRowCount(); ++i) {
            tree.expandRow(i);
        }
    }

    public CloudConfigurationImpl getSelectedConfiguration() {
        return this.selectedConfiguration;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myConfigurationTree;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private void createUIComponents() {
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent e) {
        DefaultTreeModel model = (DefaultTreeModel)this.myConfigurationTree.getModel();
        model.nodeChanged(TreeUtil.findNodeWithObject((Object)e.getConfiguration(), (TreeModel)model, (Object)this.customRoot));
        this.myConfigurationTreePanel.updateUI();
    }

    private void addNewConfiguration(CloudConfigurationImpl newConfiguration) {
        newConfiguration.setIcon(CloudConfigurationHelper.DEFAULT_ICON);
        int addIndex = this.selectedConfiguration == null ? this.editableConfigurations.size() : this.editableConfigurations.indexOf(this.selectedConfiguration) + 1;
        this.editableConfigurations.add(addIndex, newConfiguration);
        this.addConfigurationToTree(addIndex, newConfiguration, true);
        this.selectedConfiguration = newConfiguration;
        this.updateConfigurationTree();
    }

    private void moveConfigurationToIndex(int index, CloudConfigurationImpl configuration) {
        this.editableConfigurations.remove(configuration);
        this.editableConfigurations.add(index, configuration);
        this.removeConfigurationFromTree(configuration);
        this.addConfigurationToTree(index, configuration, true);
        this.updateConfigurationTree();
    }

    private void updateConfigurationTree() {
        ((DefaultTreeModel)this.myConfigurationTree.getModel()).reload();
        this.expandAllRows(this.myConfigurationTree);
        this.myConfigurationTree.updateUI();
    }

    protected void doOKAction() {
        super.doOKAction();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        Tree tree;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JLabel jLabel;
        JLabel jLabel2;
        JTextField jTextField;
        JPanel jPanel4;
        JPanel jPanel5;
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        this.myConfigurationPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel4, "North");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, "North");
        this.myConfigurationName = jTextField = new JTextField();
        jPanel6.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myConfigurationNameLabel = jLabel2 = new JLabel();
        jLabel2.setText("Name");
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 0, 2, 1, 8, 0, 0, 0, null, null, null));
        this.myGroupDescriptionLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        ((Component)jLabel).setVisible(false);
        jPanel6.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel7, "Center");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridBagLayout());
        jPanel7.add((Component)jPanel8, "North");
        this.myConfigurationEditorPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(1, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel8.add((Component)jPanel3, gridBagConstraints);
        this.myConfigurationInfoPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setMinimumSize(new Dimension(540, 150));
        jPanel2.setOpaque(true);
        jPanel2.setPreferredSize(new Dimension(10, 10));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.fill = 2;
        jPanel8.add((Component)jPanel2, gridBagConstraints2);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Details", 0, 0, null, null));
        this.myConfigurationTreePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel, "Center");
        this.myConfigurationTree = tree = new Tree();
        tree.setAutoscrolls(true);
        tree.setEditable(false);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        jPanel.add((Component)tree, "Center");
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class MyAddAction
    extends AnAction
    implements AnActionButtonRunnable,
    AnActionButtonUpdater {
        private MyAddAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            this.doAdd();
        }

        public void run(AnActionButton button) {
            this.doAdd();
        }

        private void doAdd() {
            CloudConfigurationChooserDialog.this.addNewConfiguration(new CloudConfigurationImpl(CloudConfigurationChooserDialog.this.facet, CloudConfigurationChooserDialog.this.configurationKind));
        }

        public boolean isEnabled(AnActionEvent e) {
            return true;
        }
    }

    private class MyRemoveAction
    extends AnAction
    implements AnActionButtonRunnable,
    AnActionButtonUpdater {
        private MyRemoveAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            this.doRemove();
        }

        public void run(AnActionButton button) {
            this.doRemove();
        }

        private void doRemove() {
            DefaultMutableTreeNode treeNode;
            if (CloudConfigurationChooserDialog.this.selectedConfiguration == null || !CloudConfigurationChooserDialog.this.selectedConfiguration.isEditable()) {
                return;
            }
            int removedIndex = CloudConfigurationChooserDialog.this.editableConfigurations.indexOf(CloudConfigurationChooserDialog.this.selectedConfiguration);
            CloudConfigurationChooserDialog.this.editableConfigurations.remove(CloudConfigurationChooserDialog.this.selectedConfiguration);
            CloudConfigurationChooserDialog.this.removeConfigurationFromTree(CloudConfigurationChooserDialog.this.selectedConfiguration);
            if (CloudConfigurationChooserDialog.this.editableConfigurations.isEmpty()) {
                treeNode = CloudConfigurationChooserDialog.this.defaultConfigurations.isEmpty() ? CloudConfigurationChooserDialog.this.customRoot : TreeUtil.findNodeWithObject((DefaultMutableTreeNode)CloudConfigurationChooserDialog.this.defaultsRoot, (Object)CloudConfigurationChooserDialog.this.defaultConfigurations.get(0));
            } else {
                if (removedIndex > CloudConfigurationChooserDialog.this.editableConfigurations.size() - 1) {
                    removedIndex = CloudConfigurationChooserDialog.this.editableConfigurations.size() - 1;
                }
                treeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)CloudConfigurationChooserDialog.this.customRoot, (Object)CloudConfigurationChooserDialog.this.editableConfigurations.get(removedIndex));
            }
            CloudConfigurationChooserDialog.this.selectTreeNode(treeNode);
            CloudConfigurationChooserDialog.this.updateConfigurationTree();
        }

        public boolean isEnabled(AnActionEvent e) {
            return CloudConfigurationChooserDialog.this.selectedConfiguration != null && CloudConfigurationChooserDialog.this.selectedConfiguration.isEditable();
        }
    }

    private class MyCopyActionButton
    extends AnActionButton
    implements AnActionButtonUpdater {
        public MyCopyActionButton() {
            super(ExecutionBundle.message((String)"copy.configuration.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"copy.configuration.action.name", (Object[])new Object[0]), PlatformIcons.COPY_ICON);
            this.addCustomUpdater(this);
        }

        public void actionPerformed(AnActionEvent e) {
            CloudConfigurationImpl newConfiguration = CloudConfigurationChooserDialog.this.selectedConfiguration != null ? CloudConfigurationChooserDialog.this.selectedConfiguration.copy("Copy of ") : new CloudConfigurationImpl(CloudConfigurationChooserDialog.this.facet, CloudConfigurationChooserDialog.this.configurationKind);
            CloudConfigurationChooserDialog.this.addNewConfiguration(newConfiguration);
        }

        public boolean isEnabled(AnActionEvent e) {
            return CloudConfigurationChooserDialog.this.selectedConfiguration != null;
        }
    }

    private class MyMoveUpAction
    extends AnAction
    implements AnActionButtonRunnable,
    AnActionButtonUpdater {
        private MyMoveUpAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            this.moveUp();
        }

        public void run(AnActionButton button) {
            this.moveUp();
        }

        private void moveUp() {
            int index;
            if (CloudConfigurationChooserDialog.this.selectedConfiguration != null && (index = CloudConfigurationChooserDialog.this.editableConfigurations.indexOf(CloudConfigurationChooserDialog.this.selectedConfiguration)) > 0) {
                CloudConfigurationChooserDialog.this.moveConfigurationToIndex(index - 1, CloudConfigurationChooserDialog.this.selectedConfiguration);
            }
        }

        public boolean isEnabled(AnActionEvent e) {
            return CloudConfigurationChooserDialog.this.selectedConfiguration != null && CloudConfigurationChooserDialog.this.selectedConfiguration.isEditable() && CloudConfigurationChooserDialog.this.editableConfigurations.indexOf(CloudConfigurationChooserDialog.this.selectedConfiguration) > 0;
        }
    }

    private class MyMoveDownAction
    extends AnAction
    implements AnActionButtonRunnable,
    AnActionButtonUpdater {
        private MyMoveDownAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            this.moveDown();
        }

        public void run(AnActionButton button) {
            this.moveDown();
        }

        private void moveDown() {
            int index;
            if (CloudConfigurationChooserDialog.this.selectedConfiguration != null && (index = CloudConfigurationChooserDialog.this.editableConfigurations.indexOf(CloudConfigurationChooserDialog.this.selectedConfiguration)) != -1 && index < CloudConfigurationChooserDialog.this.editableConfigurations.size() - 1) {
                CloudConfigurationChooserDialog.this.moveConfigurationToIndex(index + 1, CloudConfigurationChooserDialog.this.selectedConfiguration);
            }
        }

        public boolean isEnabled(AnActionEvent e) {
            return CloudConfigurationChooserDialog.this.selectedConfiguration != null && CloudConfigurationChooserDialog.this.selectedConfiguration.isEditable() && CloudConfigurationChooserDialog.this.editableConfigurations.indexOf(CloudConfigurationChooserDialog.this.selectedConfiguration) < CloudConfigurationChooserDialog.this.editableConfigurations.size() - 1;
        }
    }
}

