/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer;

import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.input.pointer.HistoricalChange;
import androidx.compose.ui.input.pointer.InternalPointerEvent;
import androidx.compose.ui.input.pointer.NodeParent;
import androidx.compose.ui.input.pointer.PointerEvent;
import androidx.compose.ui.input.pointer.PointerEventKt;
import androidx.compose.ui.input.pointer.PointerEventPass;
import androidx.compose.ui.input.pointer.PointerEventType;
import androidx.compose.ui.input.pointer.PointerId;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.node.PointerInputModifierNode;
import androidx.compose.ui.node.PointerInputModifierNodeKt;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J7\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00150\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\bH\u0002\u00f8\u0001\u0000J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001f\u001a\u00020\u0017H\u0002J\b\u0010 \u001a\u00020\u0017H\u0016J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0017\u0010\"\u001a\u00020\b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00170$H\u0082\bJ7\u0010%\u001a\u00020\b2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00150\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\bH\u0016\u00f8\u0001\u0000J\u0006\u0010&\u001a\u00020\u0017J\b\u0010'\u001a\u00020(H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006)"}, d2={"Landroidx/compose/ui/input/pointer/Node;", "Landroidx/compose/ui/input/pointer/NodeParent;", "pointerInputNode", "Landroidx/compose/ui/node/PointerInputModifierNode;", "(Landroidx/compose/ui/node/PointerInputModifierNode;)V", "coordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "hasEntered", "", "isIn", "pointerEvent", "Landroidx/compose/ui/input/pointer/PointerEvent;", "pointerIds", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/ui/input/pointer/PointerId;", "getPointerIds", "()Landroidx/compose/runtime/collection/MutableVector;", "getPointerInputNode", "()Landroidx/compose/ui/node/PointerInputModifierNode;", "relevantChanges", "", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "buildCache", "", "changes", "", "parentCoordinates", "internalPointerEvent", "Landroidx/compose/ui/input/pointer/InternalPointerEvent;", "isInBounds", "cleanUpHits", "clearCache", "dispatchCancel", "dispatchFinalEventPass", "dispatchIfNeeded", "block", "Lkotlin/Function0;", "dispatchMainEventPass", "markIsIn", "toString", "", "ui"})
@SourceDebugExtension(value={"SMAP\nHitPathTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HitPathTracker.kt\nandroidx/compose/ui/input/pointer/Node\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 4 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,481:1\n432#1,5:485\n439#1:501\n432#1,5:502\n439#1:518\n1182#2:482\n1161#2,2:483\n460#3,11:490\n460#3,11:507\n48#3:525\n523#3:526\n460#3,11:536\n33#4,6:519\n98#4,2:527\n33#4,6:529\n100#4:535\n33#4,6:547\n*S KotlinDebug\n*F\n+ 1 HitPathTracker.kt\nandroidx/compose/ui/input/pointer/Node\n*L\n267#1:485,5\n267#1:501\n301#1:502,5\n301#1:518\n236#1:482\n236#1:483,2\n275#1:490,11\n309#1:507,11\n374#1:525\n375#1:526\n450#1:536,11\n344#1:519,6\n382#1:527,2\n382#1:529,6\n382#1:535\n463#1:547,6\n*E\n"})
public final class Node
extends NodeParent {
    @NotNull
    private final PointerInputModifierNode pointerInputNode;
    @NotNull
    private final MutableVector<PointerId> pointerIds;
    @NotNull
    private final Map<PointerId, PointerInputChange> relevantChanges;
    @Nullable
    private LayoutCoordinates coordinates;
    @Nullable
    private PointerEvent pointerEvent;
    private boolean isIn;
    private boolean hasEntered;

    public Node(@NotNull PointerInputModifierNode pointerInputNode) {
        Intrinsics.checkNotNullParameter((Object)pointerInputNode, (String)"pointerInputNode");
        this.pointerInputNode = pointerInputNode;
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.pointerIds = new MutableVector((Object[])new PointerId[capacity$iv$iv], 0);
        this.relevantChanges = new LinkedHashMap();
        this.isIn = true;
    }

    @NotNull
    public final PointerInputModifierNode getPointerInputNode() {
        return this.pointerInputNode;
    }

    @NotNull
    public final MutableVector<PointerId> getPointerIds() {
        return this.pointerIds;
    }

    @Override
    public boolean dispatchMainEventPass(@NotNull Map<PointerId, PointerInputChange> changes, @NotNull LayoutCoordinates parentCoordinates, @NotNull InternalPointerEvent internalPointerEvent, boolean isInBounds) {
        boolean bl;
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)parentCoordinates, (String)"parentCoordinates");
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        this.buildCache(changes, parentCoordinates, internalPointerEvent, isInBounds);
        Node this_$iv = this;
        boolean $i$f$dispatchIfNeeded = false;
        if (this_$iv.relevantChanges.isEmpty()) {
            bl = false;
        } else if (!PointerInputModifierNodeKt.isAttached(this_$iv.pointerInputNode)) {
            bl = false;
        } else {
            boolean bl2 = false;
            PointerEvent pointerEvent = this.pointerEvent;
            Intrinsics.checkNotNull((Object)pointerEvent);
            PointerEvent event = pointerEvent;
            LayoutCoordinates layoutCoordinates = this.coordinates;
            Intrinsics.checkNotNull((Object)layoutCoordinates);
            long size = layoutCoordinates.getSize-YbymL2g();
            this.pointerInputNode.onPointerEvent-H0pRuoY(event, PointerEventPass.Initial, size);
            if (PointerInputModifierNodeKt.isAttached(this.pointerInputNode)) {
                MutableVector<Node> this_$iv2 = this.getChildren();
                boolean $i$f$forEach = false;
                int size$iv = this_$iv2.getSize();
                if (size$iv > 0) {
                    int i$iv = 0;
                    Object[] content$iv = this_$iv2.getContent();
                    do {
                        Node it = (Node)content$iv[i$iv];
                        boolean bl3 = false;
                        LayoutCoordinates layoutCoordinates2 = this.coordinates;
                        Intrinsics.checkNotNull((Object)layoutCoordinates2);
                        it.dispatchMainEventPass(this.relevantChanges, layoutCoordinates2, internalPointerEvent, isInBounds);
                    } while (++i$iv < size$iv);
                }
            }
            if (PointerInputModifierNodeKt.isAttached(this.pointerInputNode)) {
                this.pointerInputNode.onPointerEvent-H0pRuoY(event, PointerEventPass.Main, size);
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean dispatchFinalEventPass(@NotNull InternalPointerEvent internalPointerEvent) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        Node this_$iv = this;
        boolean $i$f$dispatchIfNeeded = false;
        if (this_$iv.relevantChanges.isEmpty()) {
            bl = false;
        } else if (!PointerInputModifierNodeKt.isAttached(this_$iv.pointerInputNode)) {
            bl = false;
        } else {
            boolean bl2 = false;
            PointerEvent pointerEvent = this.pointerEvent;
            Intrinsics.checkNotNull((Object)pointerEvent);
            PointerEvent event = pointerEvent;
            LayoutCoordinates layoutCoordinates = this.coordinates;
            Intrinsics.checkNotNull((Object)layoutCoordinates);
            long size = layoutCoordinates.getSize-YbymL2g();
            this.pointerInputNode.onPointerEvent-H0pRuoY(event, PointerEventPass.Final, size);
            if (PointerInputModifierNodeKt.isAttached(this.pointerInputNode)) {
                MutableVector<Node> this_$iv2 = this.getChildren();
                boolean $i$f$forEach = false;
                int size$iv = this_$iv2.getSize();
                if (size$iv > 0) {
                    int i$iv = 0;
                    Object[] content$iv = this_$iv2.getContent();
                    do {
                        Node it = (Node)content$iv[i$iv];
                        boolean bl3 = false;
                        it.dispatchFinalEventPass(internalPointerEvent);
                    } while (++i$iv < size$iv);
                }
            }
            bl = true;
        }
        boolean result2 = bl;
        this.cleanUpHits(internalPointerEvent);
        this.clearCache();
        return result2;
    }

    private final void buildCache(Map<PointerId, PointerInputChange> changes, LayoutCoordinates parentCoordinates, InternalPointerEvent internalPointerEvent, boolean isInBounds) {
        PointerInputChange pointerInputChange;
        PointerEvent event;
        block13: {
            Object it;
            if (!PointerInputModifierNodeKt.isAttached(this.pointerInputNode)) {
                return;
            }
            this.coordinates = PointerInputModifierNodeKt.getLayoutCoordinates(this.pointerInputNode);
            for (Map.Entry<PointerId, PointerInputChange> entry : changes.entrySet()) {
                long key = entry.getKey().unbox-impl();
                PointerInputChange change = entry.getValue();
                if (!this.pointerIds.contains((Object)PointerId.box-impl(key))) continue;
                List historical = new ArrayList();
                Object $this$fastForEach$iv = change.getHistorical();
                boolean $i$f$fastForEach = false;
                int n = $this$fastForEach$iv.size();
                for (int index$iv22 = 0; index$iv22 < n; ++index$iv22) {
                    HistoricalChange item$iv = $this$fastForEach$iv.get(index$iv22);
                    it = item$iv;
                    boolean bl = false;
                    long l = ((HistoricalChange)it).getUptimeMillis();
                    LayoutCoordinates layoutCoordinates = this.coordinates;
                    Intrinsics.checkNotNull((Object)layoutCoordinates);
                    historical.add(new HistoricalChange(l, layoutCoordinates.localPositionOf-R5De75A(parentCoordinates, ((HistoricalChange)it).getPosition-F1C5BW0()), null));
                }
                $this$fastForEach$iv = this.relevantChanges;
                PointerId pointerId = PointerId.box-impl(key);
                LayoutCoordinates layoutCoordinates = this.coordinates;
                Intrinsics.checkNotNull((Object)layoutCoordinates);
                long index$iv22 = layoutCoordinates.localPositionOf-R5De75A(parentCoordinates, change.getPreviousPosition-F1C5BW0());
                LayoutCoordinates layoutCoordinates2 = this.coordinates;
                Intrinsics.checkNotNull((Object)layoutCoordinates2);
                long item$iv = layoutCoordinates2.localPositionOf-R5De75A(parentCoordinates, change.getPosition-F1C5BW0());
                PointerInputChange index$iv22 = PointerInputChange.copy-OHpmEuE$default(change, 0L, 0L, item$iv, false, 0L, index$iv22, false, 0, historical, 0L, 731, null);
                $this$fastForEach$iv.put(pointerId, index$iv22);
            }
            if (this.relevantChanges.isEmpty()) {
                this.pointerIds.clear();
                this.getChildren().clear();
                return;
            }
            MutableVector<PointerId> this_$iv = this.pointerIds;
            boolean $i$f$getLastIndex = false;
            for (int i = this_$iv.getSize() - 1; -1 < i; --i) {
                MutableVector<PointerId> this_$iv2 = this.pointerIds;
                boolean $i$f$get = false;
                long pointerId = ((PointerId)this_$iv2.getContent()[i]).unbox-impl();
                if (changes.containsKey(PointerId.box-impl(pointerId))) continue;
                this.pointerIds.removeAt(i);
            }
            event = new PointerEvent(CollectionsKt.toList((Iterable)this.relevantChanges.values()), internalPointerEvent);
            List<PointerInputChange> $this$fastFirstOrNull$iv = event.getChanges();
            boolean $i$f$fastFirstOrNull = false;
            List<PointerInputChange> $this$fastForEach$iv$iv = $this$fastFirstOrNull$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                PointerInputChange item$iv$iv;
                PointerInputChange it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                it = it$iv;
                boolean bl2 = false;
                if (!internalPointerEvent.issuesEnterExitEvent-0FcD4WY(((PointerInputChange)it).getId-J3iCeTQ())) continue;
                pointerInputChange = it$iv;
                break block13;
            }
            pointerInputChange = null;
        }
        PointerInputChange enterExitChange = pointerInputChange;
        if (enterExitChange != null) {
            if (!isInBounds) {
                this.isIn = false;
            } else if (!this.isIn && (enterExitChange.getPressed() || enterExitChange.getPreviousPressed())) {
                LayoutCoordinates layoutCoordinates = this.coordinates;
                Intrinsics.checkNotNull((Object)layoutCoordinates);
                long size = layoutCoordinates.getSize-YbymL2g();
                boolean bl = this.isIn = !PointerEventKt.isOutOfBounds-O0kMr_c(enterExitChange, size);
            }
            if (PointerEventType.equals-impl0(event.getType-7fucELk(), PointerEventType.Companion.getMove-7fucELk()) || PointerEventType.equals-impl0(event.getType-7fucELk(), PointerEventType.Companion.getEnter-7fucELk()) || PointerEventType.equals-impl0(event.getType-7fucELk(), PointerEventType.Companion.getExit-7fucELk())) {
                event.setType-EhbLWgg$ui(!this.hasEntered && this.isIn ? PointerEventType.Companion.getEnter-7fucELk() : (this.hasEntered && !this.isIn ? PointerEventType.Companion.getExit-7fucELk() : PointerEventType.Companion.getMove-7fucELk()));
            }
            if (PointerEventType.equals-impl0(event.getType-7fucELk(), PointerEventType.Companion.getEnter-7fucELk())) {
                this.hasEntered = true;
            }
            if (PointerEventType.equals-impl0(event.getType-7fucELk(), PointerEventType.Companion.getExit-7fucELk())) {
                this.hasEntered = false;
            }
        }
        this.pointerEvent = event;
    }

    private final void clearCache() {
        this.relevantChanges.clear();
        this.coordinates = null;
        this.pointerEvent = null;
    }

    private final boolean dispatchIfNeeded(Function0<Unit> block) {
        boolean $i$f$dispatchIfNeeded = false;
        if (this.relevantChanges.isEmpty()) {
            return false;
        }
        if (!PointerInputModifierNodeKt.isAttached(this.pointerInputNode)) {
            return false;
        }
        block.invoke();
        return true;
    }

    @Override
    public void dispatchCancel() {
        MutableVector<Node> this_$iv = this.getChildren();
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node it = (Node)content$iv[i$iv];
                boolean bl = false;
                it.dispatchCancel();
            } while (++i$iv < size$iv);
        }
        this.pointerInputNode.onCancelPointerInput();
    }

    public final void markIsIn() {
        this.isIn = true;
    }

    @Override
    public void cleanUpHits(@NotNull InternalPointerEvent internalPointerEvent) {
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        super.cleanUpHits(internalPointerEvent);
        PointerEvent pointerEvent = this.pointerEvent;
        if (pointerEvent == null) {
            return;
        }
        PointerEvent event = pointerEvent;
        List<PointerInputChange> $this$fastForEach$iv = event.getChanges();
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            boolean remove;
            PointerInputChange item$iv;
            PointerInputChange change = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            boolean bl2 = remove = !change.getPressed() && (!internalPointerEvent.issuesEnterExitEvent-0FcD4WY(change.getId-J3iCeTQ()) || !this.isIn);
            if (!remove) continue;
            this.pointerIds.remove((Object)PointerId.box-impl(change.getId-J3iCeTQ()));
        }
        this.isIn = false;
    }

    @NotNull
    public String toString() {
        return "Node(pointerInputFilter=" + this.pointerInputNode + ", children=" + this.getChildren() + ", pointerIds=" + this.pointerIds + ')';
    }
}

