/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.awt;

import androidx.compose.runtime.snapshots.SnapshotStateObserver;
import androidx.compose.ui.awt.Updater;
import java.awt.Component;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B!\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0016\u001a\u00020\u0007J\b\u0010\u0017\u001a\u00020\u0007H\u0002R\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Landroidx/compose/ui/awt/Updater;", "T", "Ljava/awt/Component;", "", "component", "update", "Lkotlin/Function1;", "", "(Ljava/awt/Component;Lkotlin/jvm/functions/Function1;)V", "Ljava/awt/Component;", "isDisposed", "", "isUpdateScheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "scheduleUpdate", "snapshotObserver", "Landroidx/compose/runtime/snapshots/SnapshotStateObserver;", "value", "getUpdate", "()Lkotlin/jvm/functions/Function1;", "setUpdate", "(Lkotlin/jvm/functions/Function1;)V", "dispose", "performUpdate", "ui"})
final class Updater<T extends Component> {
    @NotNull
    private final T component;
    private boolean isDisposed;
    @NotNull
    private final AtomicBoolean isUpdateScheduled;
    @NotNull
    private final SnapshotStateObserver snapshotObserver;
    @NotNull
    private final Function1<T, Unit> scheduleUpdate;
    @NotNull
    private Function1<? super T, Unit> update;

    public Updater(@NotNull T component, @NotNull Function1<? super T, Unit> update) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter(update, (String)"update");
        this.component = component;
        this.isUpdateScheduled = new AtomicBoolean();
        this.snapshotObserver = new SnapshotStateObserver((Function1)snapshotObserver.1.INSTANCE);
        this.scheduleUpdate = new Function1<T, Unit>(this){
            final /* synthetic */ Updater<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull T t) {
                Intrinsics.checkNotNullParameter(t, (String)"<anonymous parameter 0>");
                if (!Updater.access$isUpdateScheduled$p(this.this$0).getAndSet(true)) {
                    SwingUtilities.invokeLater(() -> scheduleUpdate.1.invoke$lambda$0(this.this$0));
                }
            }

            private static final void invoke$lambda$0(Updater this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Updater.access$isUpdateScheduled$p(this$0).set(false);
                if (!Updater.access$isDisposed$p(this$0)) {
                    Updater.access$performUpdate(this$0);
                }
            }
        };
        this.update = update;
        this.snapshotObserver.start();
        this.performUpdate();
    }

    @NotNull
    public final Function1<T, Unit> getUpdate() {
        return this.update;
    }

    public final void setUpdate(@NotNull Function1<? super T, Unit> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (!Intrinsics.areEqual(this.update, value)) {
            this.update = value;
            this.performUpdate();
        }
    }

    private final void performUpdate() {
        this.snapshotObserver.observeReads(this.component, this.scheduleUpdate, (Function0)new Function0<Unit>(this){
            final /* synthetic */ Updater<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getUpdate().invoke((Object)Updater.access$getComponent$p(this.this$0));
            }
        });
    }

    public final void dispose() {
        this.snapshotObserver.stop();
        this.snapshotObserver.clear();
        this.isDisposed = true;
    }

    public static final /* synthetic */ Component access$getComponent$p(Updater $this) {
        return $this.component;
    }

    public static final /* synthetic */ AtomicBoolean access$isUpdateScheduled$p(Updater $this) {
        return $this.isUpdateScheduled;
    }

    public static final /* synthetic */ boolean access$isDisposed$p(Updater $this) {
        return $this.isDisposed;
    }

    public static final /* synthetic */ void access$performUpdate(Updater $this) {
        $this.performUpdate();
    }
}

