/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login.ui;

import com.google.gct.login.CredentialedUser;
import com.google.gct.login.GoogleLogin;
import com.google.gct.login.ui.GoogleLoginUsersPanel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.RoundedIcon;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import icons.GoogleLoginIcons;
import java.awt.Component;
import java.awt.Image;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;

public class GoogleLoginAction
extends AnAction
implements RightAlignedToolbarAction {
    private static final String SIGN_IN_MESSAGE = "Sign in to Google...";

    public void actionPerformed(AnActionEvent e) {
        GoogleLoginAction.showPopup(e);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        CredentialedUser activeUser = GoogleLogin.getInstance().getActiveUser();
        if (activeUser == null) {
            presentation.setText(SIGN_IN_MESSAGE);
            presentation.setIcon(GoogleLoginIcons.LOGGED_OUT_USER_AVATAR);
        } else {
            presentation.setText(activeUser.getEmail());
            boolean isNewUi = ExperimentalUI.isNewUI();
            int iconSize = JBUIScale.scale((int)(isNewUi ? 20 : 16));
            Icon icon = GoogleLoginAction.getPictureIcon(activeUser.getPicture(), iconSize, isNewUi);
            Icon safeIcon = Objects.requireNonNullElse(icon, GoogleLoginIcons.LOGGED_IN_FALLBACK_USER_AVATAR);
            presentation.setIcon(safeIcon);
        }
    }

    private static Icon getPictureIcon(Image image, int size, boolean isNewUi) {
        if (image == null) {
            return null;
        }
        int scaledSize = JBUIScale.scale((int)size);
        Image scaledImage = ImageUtil.scaleImage((Image)image, (int)scaledSize, (int)scaledSize);
        JBImageIcon icon = new JBImageIcon(scaledImage);
        return isNewUi ? new RoundedIcon((Icon)icon, 1.0) : icon;
    }

    private static void showPopup(AnActionEvent event) {
        GoogleLoginUsersPanel usersPanel = new GoogleLoginUsersPanel();
        ComponentPopupBuilder popupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)usersPanel, (JComponent)usersPanel.getList());
        JBPopup popup = popupBuilder.setCancelOnWindowDeactivation(true).createPopup();
        JComponent source = (JComponent)event.getInputEvent().getSource();
        popup.showUnderneathOf((Component)source);
    }
}

