/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login;

import com.android.tools.analytics.UsageTracker;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.auth.oauth2.GoogleRefreshTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.google.gct.login.GoogleLogin;
import com.google.gct.login.common.LoginListener;
import com.google.gct.login.common.OAuthData;
import com.google.gct.login.common.OAuthDataStore;
import com.google.gct.login.common.UiFacade;
import com.google.gct.login.common.VerificationCodeHolder;
import com.google.gson.Gson;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GoogleLoginPluginEvent;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.SortedSet;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class GoogleLoginState {
    private static final String GET_EMAIL_URL = "https://openidconnect.googleapis.com/v1/userinfo";
    private static final String EXPIRED_OR_REVOKED_MESSAGE = "Token has been expired or revoked.";
    private static final NotificationGroup notificationGroup = NotificationGroup.findRegisteredGroup((String)"Google Login");
    private static boolean isNotificationShowing = false;
    private static final JsonFactory jsonFactory = new JacksonFactory();
    private static final HttpTransport transport = new NetHttpTransport();
    private final String clientId;
    private final String clientSecret;
    private final SortedSet<String> oAuthScopes;
    private final OAuthDataStore authDataStore;
    private final UiFacade uiFacade;
    private Credential oAuth2Credential;
    private String accessToken;
    private long accessTokenExpiryTime;
    private String refreshToken;
    private boolean isLoggedIn;
    private String email;
    private boolean connected;
    private final Function<VerificationCodeHolder, GoogleAuthorizationCodeTokenRequest> authCodeTokenRequestFactory;
    private final Collection<LoginListener> listeners;

    static void trackEvent(GoogleLoginPluginEvent.EventKind eventKind) {
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.GOOGLE_LOGIN_EVENT).setGoogleLoginEvent(GoogleLoginPluginEvent.newBuilder().setEvent(eventKind).build()));
    }

    public GoogleLoginState(String clientId, String clientSecret, SortedSet<String> oAuthScopes, OAuthDataStore authDataStore, UiFacade uiFacade, boolean trackLogin) {
        this(clientId, clientSecret, oAuthScopes, authDataStore, uiFacade, trackLogin, verificationCodeHolder -> new GoogleAuthorizationCodeTokenRequest(transport, jsonFactory, clientId, clientSecret, verificationCodeHolder.getVerificationCode(), verificationCodeHolder.getRedirectUrl()));
    }

    @VisibleForTesting
    public GoogleLoginState(String clientId, String clientSecret, SortedSet<String> oAuthScopes, OAuthDataStore authDataStore, UiFacade uiFacade, boolean trackLogin, Function<VerificationCodeHolder, GoogleAuthorizationCodeTokenRequest> authCodeTokenRequestFactory) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.oAuthScopes = oAuthScopes;
        this.authDataStore = authDataStore;
        this.uiFacade = uiFacade;
        this.isLoggedIn = false;
        this.email = "";
        this.authCodeTokenRequestFactory = authCodeTokenRequestFactory;
        this.connected = true;
        this.listeners = Lists.newLinkedList();
        this.retrieveSavedCredentials(trackLogin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoginListener(LoginListener listener) {
        Collection<LoginListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(listener);
        }
    }

    public HttpRequestFactory createRequestFactory(@Nullable String message) {
        if (!this.checkLoggedIn(message)) {
            return null;
        }
        return transport.createRequestFactory((HttpRequestInitializer)this.oAuth2Credential);
    }

    public synchronized String fetchAccessToken() throws IOException {
        if (!this.isLoggedIn) {
            return null;
        }
        if (this.accessTokenExpiryTime != 0L) {
            long currentTime = new GregorianCalendar().getTimeInMillis() / 1000L;
            if (currentTime >= this.accessTokenExpiryTime) {
                this.fetchOAuth2Token();
            }
        } else {
            this.fetchOAuth2Token();
        }
        return this.accessToken;
    }

    public String fetchOAuth2ClientId() {
        return this.clientId;
    }

    public String fetchOAuth2ClientSecret() {
        return this.clientSecret;
    }

    public String fetchOAuth2RefreshToken() {
        if (!this.checkLoggedIn(null)) {
            return null;
        }
        return this.refreshToken;
    }

    private void fetchOAuth2Token() throws IOException {
        if (!this.checkLoggedIn(null)) {
            return;
        }
        try {
            GoogleRefreshTokenRequest request = new GoogleRefreshTokenRequest(transport, jsonFactory, this.refreshToken, this.clientId, this.clientSecret);
            GoogleTokenResponse authResponse = request.execute();
            this.accessToken = authResponse.getAccessToken();
            this.oAuth2Credential.setAccessToken(this.accessToken);
            this.accessTokenExpiryTime = new GregorianCalendar().getTimeInMillis() / 1000L + authResponse.getExpiresInSeconds();
        }
        catch (TokenResponseException e) {
            if (e.getDetails().getErrorDescription().equals(EXPIRED_OR_REVOKED_MESSAGE)) {
                GoogleLoginState.getLogger().warn(EXPIRED_OR_REVOKED_MESSAGE, (Throwable)e);
                if (!isNotificationShowing) {
                    isNotificationShowing = true;
                    GoogleLogin.getInstance().logOut(false);
                    notificationGroup.createNotification("Authentication error", "Your session has expired. Please login again", NotificationType.WARNING).addAction((AnAction)NotificationAction.createExpiring((String)"Login...", (action, notification) -> GoogleLogin.getInstance().logIn())).whenExpired(() -> {
                        isNotificationShowing = false;
                    }).notify(null);
                }
                throw e;
            }
        }
        catch (IOException e) {
            GoogleLoginState.getLogger().warn("Could not obtain an OAuth2 access token.", (Throwable)e);
            throw e;
        }
        this.saveCredentials();
    }

    public Credential getCredential() {
        if (this.oAuth2Credential == null) {
            this.oAuth2Credential = this.makeCredential();
        }
        return this.oAuth2Credential;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    public boolean logIn(@Nullable String title) {
        GoogleTokenResponse authResponse;
        if (this.isLoggedIn) {
            return true;
        }
        this.connected = true;
        VerificationCodeHolder verificationCodeHolder = this.uiFacade.obtainVerificationCodeFromExternalUserInteraction(title);
        if (verificationCodeHolder == null) {
            return false;
        }
        GoogleAuthorizationCodeTokenRequest authRequest = this.authCodeTokenRequestFactory.apply(verificationCodeHolder);
        try {
            authResponse = authRequest.execute();
        }
        catch (IOException e) {
            this.uiFacade.showErrorDialog("Error while signing in", "An error occurred while trying to sign in: " + e.getMessage());
            GoogleLoginState.getLogger().warn("Could not sign in", (Throwable)e);
            return false;
        }
        this.isLoggedIn = true;
        GoogleLoginState.trackEvent(GoogleLoginPluginEvent.EventKind.LOGIN_WITH_SUCCESS);
        this.updateUserCredentials(authResponse);
        return true;
    }

    public boolean logOut(boolean showPrompt) {
        if (!this.isLoggedIn) {
            return true;
        }
        boolean logOut = true;
        if (showPrompt) {
            logOut = this.uiFacade.askYesOrNo("Sign out?", "Are you sure you want to sign out?");
        }
        if (logOut) {
            this.email = "";
            this.isLoggedIn = false;
            GoogleLoginState.trackEvent(GoogleLoginPluginEvent.EventKind.LOGOUT_WITH_SUCCESS);
            this.authDataStore.clearStoredOAuthData();
            this.notifyLoginStatusChange(false);
            this.uiFacade.notifyStatusIndicator();
            return true;
        }
        return false;
    }

    public Credential makeCredential() {
        GoogleCredential cred = new GoogleCredential.Builder().setJsonFactory(jsonFactory).setTransport(transport).setClientSecrets(this.clientId, this.clientSecret).build();
        cred.setAccessToken(this.accessToken);
        cred.setRefreshToken(this.refreshToken);
        return cred;
    }

    private void updateUserCredentials(GoogleTokenResponse tokenResponse) {
        this.refreshToken = tokenResponse.getRefreshToken();
        this.accessToken = tokenResponse.getAccessToken();
        this.oAuth2Credential = this.makeCredential();
        this.accessTokenExpiryTime = System.currentTimeMillis() / 1000L + tokenResponse.getExpiresInSeconds();
        this.email = GoogleLoginState.queryEmail(this.createRequestFactory(null));
        this.saveCredentials();
        this.uiFacade.notifyStatusIndicator();
        this.notifyLoginStatusChange(true);
    }

    private void retrieveSavedCredentials(boolean trackLogin) {
        OAuthData savedAuthState = this.authDataStore.loadOAuthData();
        if (savedAuthState.getRefreshToken() == null || savedAuthState.getStoredScopes() == null) {
            this.authDataStore.clearStoredOAuthData();
            return;
        }
        this.accessToken = savedAuthState.getAccessToken();
        this.refreshToken = savedAuthState.getRefreshToken();
        this.accessTokenExpiryTime = savedAuthState.getAccessTokenExpiryTime();
        this.email = savedAuthState.getStoredEmail();
        this.isLoggedIn = true;
        if (trackLogin) {
            GoogleLoginState.trackEvent(GoogleLoginPluginEvent.EventKind.LOGIN_WITH_SUCCESS);
        }
        if (!this.oAuthScopes.equals(savedAuthState.getStoredScopes())) {
            GoogleLoginState.getLogger().warn("OAuth scope set for stored credentials no longer valid, logging out.");
            GoogleLoginState.getLogger().warn(this.oAuthScopes + " vs. " + savedAuthState.getStoredScopes());
            this.logOut(false);
        }
        this.oAuth2Credential = this.makeCredential();
    }

    private boolean checkLoggedIn(String msg) {
        if (!this.isLoggedIn) {
            boolean rc = this.logIn(msg);
            if (!rc) {
                return false;
            }
            this.uiFacade.notifyStatusIndicator();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyLoginStatusChange(boolean login) {
        Collection<LoginListener> collection = this.listeners;
        synchronized (collection) {
            for (LoginListener listener : this.listeners) {
                try {
                    listener.statusChanged(login);
                }
                catch (Throwable t) {
                    GoogleLoginState.getLogger().error("Exception in LoginListener", t);
                }
            }
        }
    }

    @VisibleForTesting
    protected static String queryEmail(HttpRequestFactory requestFactory) {
        String url = GET_EMAIL_URL;
        try {
            HttpRequest get = requestFactory.buildGetRequest(new GenericUrl(url));
            HttpResponse resp = get.execute();
            Type responseData = new TypeToken<LoginResponseHolder>(){}.getType();
            LoginResponseHolder loginResponseHolder = (LoginResponseHolder)new Gson().fromJson((Reader)new InputStreamReader(resp.getContent(), StandardCharsets.UTF_8), responseData);
            String userEmail = loginResponseHolder.getEmail();
            if (userEmail == null) {
                throw new Exception("Response from server is invalid.");
            }
            return userEmail;
        }
        catch (Exception e) {
            GoogleLoginState.getLogger().error("Could not parse email after Google service sign-in", (Throwable)e);
            return null;
        }
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(GoogleLoginState.class);
    }

    private void saveCredentials() {
        if (!this.isLoggedIn) {
            this.authDataStore.clearStoredOAuthData();
        } else {
            OAuthData creds = new OAuthData(this.accessToken, this.refreshToken, this.email, this.oAuthScopes, this.accessTokenExpiryTime);
            this.authDataStore.saveOAuthData(creds);
        }
    }

    private static class LoginResponseHolder {
        private String sub;
        private String picture;
        private String email;
        private String email_verified;
        private String hd;

        private LoginResponseHolder() {
        }

        private String getSub() {
            return this.sub;
        }

        private String getPicture() {
            return this.picture;
        }

        private String getEmail() {
            return this.email;
        }

        private String getEmail_verified() {
            return this.email_verified;
        }

        private String getHd() {
            return this.hd;
        }
    }
}

