/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.AndroidXmlFiles;
import com.android.tools.idea.rendering.parsers.PsiXmlFile;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.util.CommonAndroidUtil;
import com.android.utils.TraceUtils;
import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.tree.java.IKeywordElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetProperties;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidUtils
extends CommonAndroidUtil {
    private static final Logger LOG = Logger.getInstance(AndroidUtils.class);
    @NonNls
    public static final String NAMESPACE_KEY = "android";
    @NonNls
    public static final String SYSTEM_RESOURCE_PACKAGE = "android";
    @NonNls
    public static final String VIEW_CLASS_NAME = "android.view.View";
    @NonNls
    public static final String APPLICATION_CLASS_NAME = "android.app.Application";
    @NonNls
    public static final String ACTIVITY_BASE_CLASS_NAME = "android.app.Activity";
    @NonNls
    public static final String R_CLASS_NAME = "R";
    @NonNls
    public static final String MANIFEST_CLASS_NAME = "Manifest";
    @NonNls
    public static final String LAUNCH_ACTION_NAME = "android.intent.action.MAIN";
    @NonNls
    public static final String WALLPAPER_SERVICE_ACTION_NAME = "android.service.wallpaper.WallpaperService";
    @NonNls
    public static final String LAUNCH_CATEGORY_NAME = "android.intent.category.LAUNCHER";
    @NonNls
    public static final String LEANBACK_LAUNCH_CATEGORY_NAME = "android.intent.category.LEANBACK_LAUNCHER";
    @NonNls
    public static final String DEFAULT_CATEGORY_NAME = "android.intent.category.DEFAULT";
    @NonNls
    public static final String WATCHFACE_CATEGORY_NAME = "com.google.android.wearable.watchface.category.WATCH_FACE";
    @NonNls
    public static final String INSTRUMENTATION_RUNNER_BASE_CLASS = "android.app.Instrumentation";
    @NonNls
    public static final String SERVICE_CLASS_NAME = "android.app.Service";
    @NonNls
    public static final String RECEIVER_CLASS_NAME = "android.content.BroadcastReceiver";
    @NonNls
    public static final String PROVIDER_CLASS_NAME = "android.content.ContentProvider";
    @NonNls
    public static final String ANDROID_LIBRARY_PROPERTY = "android.library";
    @NonNls
    public static final String ANDROID_PROJECT_TYPE_PROPERTY = "project.type";
    @NonNls
    public static final String ANDROID_MANIFEST_MERGER_PROPERTY = "manifestmerger.enabled";
    @NonNls
    public static final String ANDROID_DEX_DISABLE_MERGER = "dex.disable.merger";
    @NonNls
    public static final String ANDROID_DEX_FORCE_JUMBO_PROPERTY = "dex.force.jumbo";
    @NonNls
    public static final String ANDROID_TARGET_PROPERTY = "target";
    @NonNls
    public static final String ANDROID_LIBRARY_REFERENCE_PROPERTY_PREFIX = "android.library.reference.";
    @NonNls
    public static final String TAG_LINEAR_LAYOUT = "LinearLayout";
    private static final String[] ANDROID_COMPONENT_CLASSES = new String[]{"android.app.Activity", "android.app.Service", "android.content.BroadcastReceiver", "android.content.ContentProvider"};
    private static final int PACKAGE_LENGTH_LIMIT = 100;

    private AndroidUtils() {
    }

    public boolean isAndroidProject(@NotNull Project project) {
        return AndroidUtils.hasAndroidFacets(project);
    }

    @Nullable
    public static <T extends DomElement> T loadDomElement(@NotNull Module module2, @NotNull VirtualFile file2, @NotNull Class<T> aClass) {
        return AndroidUtils.loadDomElement(module2.getProject(), file2, aClass);
    }

    @Nullable
    public static <T extends DomElement> T loadDomElement(@NotNull Project project, @NotNull VirtualFile file2, @NotNull Class<T> aClass) {
        return (T)((DomElement)ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed() || !file2.isValid()) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
            if (psiFile instanceof XmlFile) {
                return AndroidUtils.loadDomElementWithReadPermission(project, (XmlFile)psiFile, aClass);
            }
            return null;
        }));
    }

    @Nullable
    public static <T extends DomElement> T loadDomElementWithReadPermission(@NotNull Project project, @NotNull XmlFile xmlFile, @NotNull Class<T> aClass) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ProgressManager.checkCanceled();
        DomManager domManager = DomManager.getDomManager((Project)project);
        ProgressManager.checkCanceled();
        DomFileElement element2 = domManager.getFileElement(xmlFile, aClass);
        return (T)(element2 == null ? null : element2.getRootElement());
    }

    public static boolean isAbstract(@NotNull PsiClass c) {
        return c.isInterface() || c.hasModifierProperty("abstract");
    }

    @Nullable
    public static Module getAndroidModule(ConfigurationContext context2) {
        Module module2 = context2.getModule();
        if (module2 == null || AndroidFacet.getInstance((Module)module2) == null) {
            return null;
        }
        return module2;
    }

    public static VirtualFile createChildDirectoryIfNotExist(Project project, VirtualFile parent2, String name2) throws IOException {
        VirtualFile child = parent2.findChild(name2);
        return child == null ? parent2.createChildDirectory((Object)project, name2) : child;
    }

    @Nullable
    public static PsiFile getContainingFile(@NotNull PsiElement element2) {
        return element2 instanceof PsiFile ? (PsiFile)element2 : element2.getContainingFile();
    }

    public static void navigateTo(@NotNull PsiElement[] targets, @Nullable RelativePoint pointToShowPopup) {
        if (targets.length == 0) {
            JComponent renderer2 = HintUtil.createErrorLabel((String)"Empty text");
            JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder(renderer2, renderer2).createPopup();
            if (pointToShowPopup != null) {
                popup2.show(pointToShowPopup);
            }
            return;
        }
        if (targets.length == 1 || pointToShowPopup == null) {
            PsiNavigateUtil.navigate((PsiElement)targets[0]);
        } else {
            DefaultPsiElementCellRenderer renderer3 = new DefaultPsiElementCellRenderer(){

                public String getElementText(PsiElement element2) {
                    PsiFile file2 = AndroidUtils.getContainingFile(element2);
                    return file2 != null ? file2.getName() : super.getElementText(element2);
                }

                public String getContainerText(PsiElement element2, String name2) {
                    PsiFile file2 = AndroidUtils.getContainingFile(element2);
                    PsiDirectory dir = file2 != null ? file2.getContainingDirectory() : null;
                    return dir == null ? "" : "(" + dir.getName() + ")";
                }
            };
            JBPopup popup3 = NavigationUtil.getPsiElementPopup((PsiElement[])targets, (PsiElementListCellRenderer)renderer3, null);
            popup3.show(pointToShowPopup);
        }
    }

    @NotNull
    public static String getSimpleNameByRelativePath(@NotNull String relativePath) {
        int index2 = (relativePath = FileUtil.toSystemIndependentName((String)relativePath)).lastIndexOf(47);
        if (index2 < 0) {
            return relativePath;
        }
        return relativePath.substring(index2 + 1);
    }

    @Nullable
    public static String getUnqualifiedName(@NotNull String qualifiedName) {
        int start2 = qualifiedName.lastIndexOf(46);
        if (start2 == -1 || start2 + 1 == qualifiedName.length()) {
            return null;
        }
        return qualifiedName.substring(start2 + 1);
    }

    public static void setUpAndroidFacetConfiguration(@NotNull Module module2, @NotNull AndroidFacetConfiguration androidFacetConfiguration, @NotNull String baseDirectoryPath) {
        String s = AndroidRootUtil.getPathRelativeToModuleDir(module2, baseDirectoryPath);
        if (s == null || s.isEmpty()) {
            return;
        }
        AndroidFacetProperties properties2 = androidFacetConfiguration.getState();
        properties2.GEN_FOLDER_RELATIVE_PATH_APT = "/" + s + properties2.GEN_FOLDER_RELATIVE_PATH_APT;
        properties2.GEN_FOLDER_RELATIVE_PATH_AIDL = "/" + s + properties2.GEN_FOLDER_RELATIVE_PATH_AIDL;
        properties2.MANIFEST_FILE_RELATIVE_PATH = "/" + s + properties2.MANIFEST_FILE_RELATIVE_PATH;
        properties2.RES_FOLDER_RELATIVE_PATH = "/" + s + properties2.RES_FOLDER_RELATIVE_PATH;
        properties2.ASSETS_FOLDER_RELATIVE_PATH = "/" + s + properties2.ASSETS_FOLDER_RELATIVE_PATH;
        properties2.LIBS_FOLDER_RELATIVE_PATH = "/" + s + properties2.LIBS_FOLDER_RELATIVE_PATH;
        properties2.PROGUARD_LOGS_FOLDER_RELATIVE_PATH = "/" + s + properties2.PROGUARD_LOGS_FOLDER_RELATIVE_PATH;
        properties2.RES_OVERLAY_FOLDERS.replaceAll(overlayFolder -> "/" + s + overlayFolder);
    }

    @Nullable
    public static VirtualFile findFileByAbsoluteOrRelativePath(@Nullable VirtualFile baseDir2, @NotNull String path2) {
        VirtualFile libDir = LocalFileSystem.getInstance().findFileByPath(path2);
        if (libDir != null) {
            return libDir;
        }
        if (baseDir2 != null) {
            return LocalFileSystem.getInstance().findFileByPath(baseDir2.getPath() + "/" + path2);
        }
        return null;
    }

    @Nullable
    public static TargetSelectionMode getDefaultTargetSelectionMode(@NotNull Module module2, @NotNull ConfigurationType type, @NonNls ConfigurationType alternativeType) {
        RunManager runManager = RunManager.getInstance((Project)module2.getProject());
        List configurations = runManager.getConfigurationsList(type);
        TargetSelectionMode alternative = null;
        if (!configurations.isEmpty()) {
            for (RunConfiguration configuration : configurations) {
                if (!(configuration instanceof AndroidRunConfigurationBase)) continue;
                AndroidRunConfigurationBase runConfig = (AndroidRunConfigurationBase)configuration;
                TargetSelectionMode targetMode = runConfig.getDeployTargetContext().getTargetSelectionMode();
                if (runConfig.getConfigurationModule() == module2) {
                    return targetMode;
                }
                alternative = targetMode;
            }
        }
        if (alternative != null) {
            return alternative;
        }
        configurations = runManager.getConfigurationsList(alternativeType);
        if (!configurations.isEmpty()) {
            for (RunConfiguration configuration : configurations) {
                if (!(configuration instanceof AndroidRunConfigurationBase)) continue;
                return ((AndroidRunConfigurationBase)configuration).getDeployTargetContext().getTargetSelectionMode();
            }
        }
        return null;
    }

    public static boolean equal(@Nullable String s1, @Nullable String s2, boolean distinguishDelimiters) {
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        int n = s1.length();
        for (int i = 0; i < n; ++i) {
            char c1 = s1.charAt(i);
            char c2 = s2.charAt(i);
            if (!distinguishDelimiters && (!Character.isLetterOrDigit(c1) || !Character.isLetterOrDigit(c2)) || c1 == c2) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static List<AndroidFacet> getApplicationFacets(@NotNull Project project) {
        return ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID).stream().filter(facet2 -> ((AndroidFacetConfiguration)facet2.getConfiguration()).isAppProject()).sorted(Comparator.comparing(facet2 -> facet2.getModule().getName())).collect(Collectors.toList());
    }

    @NotNull
    public static List<AndroidFacet> getAndroidLibraryDependencies(@NotNull Module module2) {
        ArrayList<AndroidFacet> depFacets = new ArrayList<AndroidFacet>();
        for (OrderEntry orderEntry : ModuleRootManager.getInstance((Module)module2).getOrderEntries()) {
            AndroidFacet depFacet;
            Module depModule;
            ModuleOrderEntry moduleOrderEntry;
            if (!(orderEntry instanceof ModuleOrderEntry) || (moduleOrderEntry = (ModuleOrderEntry)orderEntry).getScope() != DependencyScope.COMPILE || (depModule = moduleOrderEntry.getModule()) == null || (depFacet = AndroidFacet.getInstance((Module)depModule)) == null || !((AndroidFacetConfiguration)depFacet.getConfiguration()).canBeDependency()) continue;
            depFacets.add(depFacet);
        }
        return depFacets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkNewPassword(JPasswordField passwordField, JPasswordField confirmedPasswordField) throws CommitStepException {
        char[] password = passwordField.getPassword();
        char[] confirmedPassword = confirmedPasswordField.getPassword();
        try {
            AndroidUtils.checkPassword(password);
            if (password.length < 6) {
                throw new CommitStepException(AndroidBundle.message("android.export.package.incorrect.password.length", new Object[0]));
            }
            if (!Arrays.equals(password, confirmedPassword)) {
                throw new CommitStepException(AndroidBundle.message("android.export.package.passwords.not.match.error", new Object[0]));
            }
        }
        finally {
            Arrays.fill(password, '\u0000');
            Arrays.fill(confirmedPassword, '\u0000');
        }
    }

    public static void checkPassword(char[] password) throws CommitStepException {
        if (password.length == 0) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.password.error", new Object[0]));
        }
    }

    public static void reportError(@NotNull Project project, @NotNull String message2) {
        AndroidUtils.reportError(project, message2, CommonBundle.getErrorTitle());
    }

    public static void reportError(@NotNull Project project, @NotNull String message2, @NotNull String title) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IncorrectOperationException(message2);
        }
        Messages.showErrorDialog((Project)project, (String)message2, (String)title);
    }

    public static void showStackStace(@Nullable Project project, @NotNull Throwable[] throwables) {
        final StringBuilder messageBuilder = new StringBuilder();
        for (Throwable t : throwables) {
            if (messageBuilder.length() > 0) {
                messageBuilder.append("\n\n");
            }
            messageBuilder.append(TraceUtils.getStackTrace((Throwable)t));
        }
        DialogWrapper wrapper = new DialogWrapper(project, false){
            {
                super(project, canBeParent);
                this.init();
            }

            protected JComponent createCenterPanel() {
                JPanel panel2 = new JPanel(new BorderLayout());
                JTextArea textArea = new JTextArea(messageBuilder.toString());
                textArea.setEditable(false);
                textArea.setRows(40);
                textArea.setColumns(70);
                panel2.add(ScrollPaneFactory.createScrollPane((Component)textArea));
                return panel2;
            }
        };
        wrapper.setTitle("Stack Trace");
        wrapper.show();
    }

    public static boolean isValidAndroidPackageName(@NotNull String name2) {
        return AndroidUtils.validateAndroidPackageName(name2) == null;
    }

    public static boolean isValidJavaPackageName(@NotNull String name2) {
        int index2 = 0;
        while (true) {
            int index1;
            if ((index1 = name2.indexOf(46, index2)) < 0) {
                index1 = name2.length();
            }
            if (!AndroidUtils.isIdentifier(name2.substring(index2, index1))) {
                return false;
            }
            if (index1 == name2.length()) {
                return true;
            }
            index2 = index1 + 1;
        }
    }

    @Nullable
    public static String validateAndroidPackageName(@NotNull String name2) {
        if (name2.isEmpty()) {
            return "Package name is missing";
        }
        String packageManagerCheck = AndroidUtils.validateName(name2);
        if (packageManagerCheck != null) {
            return packageManagerCheck;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int index2 = 0;
        while (true) {
            String error;
            int index1;
            if ((index1 = name2.indexOf(46, index2)) < 0) {
                index1 = name2.length();
            }
            if ((error = AndroidUtils.isReservedKeyword(name2.substring(index2, index1))) != null) {
                return error;
            }
            if (index1 == name2.length()) break;
            index2 = index1 + 1;
        }
        return null;
    }

    @Nullable
    public static String validatePackageName(@Nullable String packageName2) {
        String string = packageName2 = packageName2 == null ? "" : packageName2;
        if (packageName2.length() >= 100) {
            return AndroidBundle.message("android.wizard.module.package.too.long", new Object[0]);
        }
        return AndroidUtils.validateAndroidPackageName(packageName2);
    }

    @Nullable
    public static String isReservedKeyword(@NotNull String string) {
        Lexer lexer = LazyHolder.JAVA_LEXER;
        lexer.start((CharSequence)string);
        if (lexer.getTokenType() != JavaTokenType.IDENTIFIER) {
            if (lexer.getTokenType() instanceof IKeywordElementType) {
                return "Package names cannot contain Java keywords like '" + string + "'";
            }
            if (string.isEmpty()) {
                return "Package segments must be of non-zero length";
            }
            return string + " is not a valid identifier";
        }
        return null;
    }

    @Nullable
    private static String validateName(String name2) {
        int N = name2.length();
        boolean hasSep = false;
        boolean front = true;
        for (int i = 0; i < N; ++i) {
            char c = name2.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                front = false;
                continue;
            }
            if (c >= '0' && c <= '9' || c == '_') {
                if (!front) continue;
                if (c == '_') {
                    return "The character '_' cannot be the first character in a package segment";
                }
                return "A digit cannot be the first character in a package segment";
            }
            if (c == '.') {
                hasSep = true;
                front = true;
                continue;
            }
            return "The character '" + c + "' is not allowed in Android application package names";
        }
        return hasSep ? null : "The package must have at least one '.' separator";
    }

    public static boolean isIdentifier(@NotNull String candidate) {
        return StringUtil.isJavaIdentifier((String)candidate) && !JavaLexer.isKeyword((String)candidate, (LanguageLevel)LanguageLevel.JDK_1_5);
    }

    public static void reportImportErrorToEventLog(String message2, String modName, Project project, NotificationListener listener2) {
        Notification notification = new Notification(NotificationGroup.createIdWithTitle((String)"Importing Error", (String)AndroidBundle.message("android.facet.importing.notification.group", new Object[0])), AndroidBundle.message("android.facet.importing.title", modName), message2, NotificationType.ERROR);
        if (listener2 != null) {
            notification.setListener(listener2);
        }
        notification.notify(project);
        LOG.debug(message2);
    }

    public static boolean isPackagePrefix(@NotNull String prefix, @NotNull String name2) {
        return name2.equals(prefix) || name2.startsWith(prefix + ".");
    }

    @NotNull
    public static Set<Module> getSetWithBackwardDependencies(@NotNull Module module2) {
        Graph graph = ModuleManager.getInstance((Project)module2.getProject()).moduleGraph();
        HashSet<Module> set = new HashSet<Module>();
        GraphAlgorithms.getInstance().collectOutsRecursively(graph, (Object)module2, set);
        return set;
    }

    @NotNull
    public static List<String> urlsToOsPaths(@NotNull List<String> urls, @Nullable String sdkHomeCanonicalPath) {
        if (urls.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result2 = new ArrayList<String>(urls.size());
        for (String url : urls) {
            if (sdkHomeCanonicalPath != null) {
                url = StringUtil.replace((String)url, (String)"%MODULE_SDK_HOME%", (String)sdkHomeCanonicalPath);
            }
            result2.add(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url)));
        }
        return result2;
    }

    public static boolean isAndroidComponent(@NotNull PsiClass c) {
        Project project = c.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        for (String componentClassName : ANDROID_COMPONENT_CLASSES) {
            PsiClass componentClass = facade.findClass(componentClassName, ProjectScope.getAllScope((Project)project));
            if (componentClass == null || !c.isInheritor(componentClass, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAndroidFacets(@NotNull Project project) {
        ProjectFacetManager facetManager = ProjectFacetManager.getInstance((Project)project);
        return facetManager.hasFacets(AndroidFacet.ID) || facetManager.hasFacets(ApkFacet.ID) || facetManager.hasFacets(GradleFacet.getFacetTypeId());
    }

    @Nullable
    public static String getDeclaredContextFqcn(@NotNull Module module2, @NotNull XmlFile xmlFile) {
        return AndroidXmlFiles.getDeclaredContextFqcn(ProjectSystemUtil.getModuleSystem(module2).getPackageName(), new PsiXmlFile(xmlFile));
    }

    @Nullable
    public static PsiClass getContextClass(@NotNull Module module2, @NotNull XmlFile xmlFile) {
        String fqn = AndroidUtils.getDeclaredContextFqcn(module2, xmlFile);
        if (fqn != null) {
            Project project = module2.getProject();
            return JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.allScope((Project)project));
        }
        return null;
    }

    private static class LazyHolder {
        static final Lexer JAVA_LEXER = JavaParserDefinition.createLexer((LanguageLevel)LanguageLevel.JDK_1_5);

        private LazyHolder() {
        }
    }
}

