/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.ddmlib.MultiLineReceiver;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AndroidOutputReceiver
extends MultiLineReceiver {
    private static final String BAD_ACCESS_ERROR = "Bad address (14)";
    private boolean myTryAgain;

    public AndroidOutputReceiver() {
        this.setTrimLine(false);
    }

    public final void processNewLines(String[] lines2) {
        if (this.myTryAgain) {
            return;
        }
        ArrayList<String> newLines = new ArrayList<String>();
        for (String line2 : lines2) {
            newLines.add(line2);
            if (!line2.contains(BAD_ACCESS_ERROR)) continue;
            this.myTryAgain = true;
            break;
        }
        this.processNewLines(newLines);
    }

    public boolean isTryAgain() {
        return this.myTryAgain;
    }

    public void invalidate() {
        this.myTryAgain = false;
    }

    protected abstract void processNewLines(@NotNull List<String> var1);
}

