/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview.classloading;

import com.android.tools.idea.rendering.classloading.loaders.DelegatingClassLoader;
import com.android.tools.idea.res.ResourceClassRegistry;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.classloading.LibraryResourceClassLoaderKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0014\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00040\u00040\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/android/uipreview/classloading/LibraryResourceClassLoader;", "Ljava/lang/ClassLoader;", "parent", "module", "Lcom/intellij/openapi/module/Module;", "childLoader", "Lcom/android/tools/idea/rendering/classloading/loaders/DelegatingClassLoader$Loader;", "(Ljava/lang/ClassLoader;Lcom/intellij/openapi/module/Module;Lcom/android/tools/idea/rendering/classloading/loaders/DelegatingClassLoader$Loader;)V", "moduleRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "getModuleRef", "()Ljava/lang/ref/WeakReference;", "findClass", "Ljava/lang/Class;", "name", "", "findResourceClass", "intellij.android.core"})
public final class LibraryResourceClassLoader
extends ClassLoader {
    @NotNull
    private final DelegatingClassLoader.Loader childLoader;
    @NotNull
    private final WeakReference<Module> moduleRef;

    public LibraryResourceClassLoader(@Nullable ClassLoader parent2, @NotNull Module module2, @NotNull DelegatingClassLoader.Loader childLoader) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)childLoader, (String)"childLoader");
        super(parent2);
        this.childLoader = childLoader;
        this.moduleRef = new WeakReference<Module>(module2);
        LibraryResourceClassLoaderKt.access$registerResources(module2);
    }

    @NotNull
    public final WeakReference<Module> getModuleRef() {
        return this.moduleRef;
    }

    private final Class<?> findResourceClass(String name2) {
        Module module2 = (Module)this.moduleRef.get();
        if (module2 == null) {
            throw new ClassNotFoundException(name2);
        }
        Module module3 = module2;
        if (!LibraryResourceClassLoaderKt.access$isResourceClassName(name2)) {
            throw new ClassNotFoundException(name2);
        }
        if (ResourceIdManager.Companion.get(module3).getFinalIdsUsed() && this.childLoader.loadClass(name2) != null) {
            throw new ClassNotFoundException(name2);
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module3);
        if (androidFacet == null) {
            throw new ClassNotFoundException(name2);
        }
        AndroidFacet facet2 = androidFacet;
        StudioResourceRepositoryManager studioResourceRepositoryManager = StudioResourceRepositoryManager.getInstance(facet2);
        Intrinsics.checkNotNullExpressionValue((Object)studioResourceRepositoryManager, (String)"getInstance(facet)");
        StudioResourceRepositoryManager repositoryManager = studioResourceRepositoryManager;
        byte[] byArray = ResourceClassRegistry.get(module3.getProject()).findClassDefinition(name2, repositoryManager);
        if (byArray == null) {
            throw new ClassNotFoundException(name2);
        }
        byte[] data = byArray;
        Logger.getInstance(LibraryResourceClassLoader.class).debug("  Defining class from AAR registry");
        Class<?> clazz = this.defineClass(name2, data, 0, data.length);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"defineClass(name, data, 0, data.size)");
        return clazz;
    }

    @Override
    @NotNull
    protected Class<?> findClass(@NotNull String name2) {
        Class<?> clazz;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        try {
            Class<?> clazz2 = super.findClass(name2);
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"{\n      super.findClass(name)\n    }");
            clazz = clazz2;
        }
        catch (ClassNotFoundException e) {
            clazz = this.findResourceClass(name2);
        }
        return clazz;
    }
}

