/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.AndroidXConstants;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.log.LogAnonymizerUtil;
import com.android.tools.idea.rendering.IRenderLogger;
import com.android.tools.idea.rendering.RenderModelModule;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.res.ResourceIdManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.util.ArrayUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewLoader {
    private static final Logger LOG = Logger.getInstance(ViewLoader.class);
    private static final int ALLOWED_NESTED_VIEWS = 100;
    @NotNull
    private final RenderModelModule myModule;
    @NotNull
    private final Map<String, Class<?>> myLoadedClasses = Maps.newHashMap();
    @NotNull
    private final Multiset<Class<?>> myLoadingClasses = HashMultiset.create((int)5);
    @Nullable
    private final Object myCredential;
    @NotNull
    private final LayoutLibrary myLayoutLibrary;
    @NotNull
    private IRenderLogger myLogger;
    @NotNull
    private final ClassLoader myClassLoader;

    public ViewLoader(@NotNull LayoutLibrary layoutLib, @NotNull RenderModelModule module2, @NotNull IRenderLogger logger2, @Nullable Object credential, @NotNull ClassLoader classLoader) {
        this.myLayoutLibrary = layoutLib;
        this.myModule = module2;
        this.myLogger = logger2;
        this.myCredential = credential;
        this.myClassLoader = classLoader;
    }

    public void setLogger(@NotNull IRenderLogger logger2) {
        this.myLogger = logger2;
    }

    @Nullable
    public Object loadClass(String className, Class<?>[] constructorSignature, Object[] constructorArgs) {
        if (AndroidXConstants.CLASS_RECYCLER_VIEW_ADAPTER.newName().equals(className)) {
            className = "com.android.layoutlib.bridge.android.androidx.Adapter";
            constructorSignature = ArrayUtil.EMPTY_CLASS_ARRAY;
            constructorArgs = ArrayUtil.EMPTY_OBJECT_ARRAY;
        } else if (AndroidXConstants.CLASS_RECYCLER_VIEW_ADAPTER.oldName().equals(className)) {
            className = "com.android.layoutlib.bridge.android.support.Adapter";
            constructorSignature = ArrayUtil.EMPTY_CLASS_ARRAY;
            constructorArgs = ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        return this.loadClass(className, constructorSignature, constructorArgs, false);
    }

    @Nullable
    public Object loadView(@NotNull String className, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorArgs) throws ClassNotFoundException {
        Object aClass = this.loadClass(className, constructorSignature, constructorArgs, true);
        if (aClass != null) {
            return aClass;
        }
        try {
            Object o = this.createViewFromSuperclass(className, constructorSignature, constructorArgs);
            if (o != null) {
                return o;
            }
            return this.myLayoutLibrary.createMockView(ViewLoader.getShortClassName(className), (Class[])constructorSignature, constructorArgs);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ClassNotFoundException(className, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object loadClass(@NotNull String className, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorArgs, boolean isView) {
        block12: {
            Object object;
            Class<?> aClass = this.myLoadedClasses.get(className);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("loadClassA(%s)", LogAnonymizerUtil.anonymizeClassName(className)));
            }
            if (aClass != null) {
                return this.createNewInstance(aClass, constructorSignature, constructorArgs, isView);
            }
            aClass = this.loadClass(className, isView);
            if (aClass == null) break block12;
            if (this.myLoadingClasses.count(aClass) > 100) {
                throw new InstantiationException("The layout involves creation of " + className + " over 100 levels deep. Infinite recursion?");
            }
            this.myLoadingClasses.add(aClass);
            try {
                Object viewObject = this.createNewInstance(aClass, constructorSignature, constructorArgs, isView);
                this.myLoadedClasses.put(className, aClass);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  instance created");
                }
                object = viewObject;
            }
            catch (Throwable throwable) {
                try {
                    this.myLoadingClasses.remove(aClass);
                    throw throwable;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError | NoSuchMethodException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(e);
                    }
                    this.myLogger.addBrokenClass(className, e);
                    break block12;
                }
                catch (InvocationTargetException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Throwable)e);
                    }
                    Throwable cause = e.getCause();
                    this.myLogger.addBrokenClass(className, cause);
                }
            }
            this.myLoadingClasses.remove(aClass);
            return object;
        }
        return null;
    }

    public boolean isClassLoaded(String name2) {
        return this.myLoadedClasses.containsKey(name2);
    }

    @VisibleForTesting
    @NotNull
    static String getShortClassName(@NotNull String fqcn) {
        int first = fqcn.indexOf(46);
        int last = fqcn.lastIndexOf(46);
        if (fqcn.startsWith("android.") ? last > first : last > (first = fqcn.indexOf(46, first + 1)) && first >= 0) {
            return fqcn.substring(0, first) + ".." + fqcn.substring(last);
        }
        return fqcn;
    }

    @NotNull
    private Object createNewInstance(@NotNull Class<?> clazz, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorParameters, boolean isView) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Constructor<?> constructor;
        block10: {
            constructor = null;
            try {
                constructor = clazz.getConstructor(constructorSignature);
            }
            catch (NoSuchMethodException e) {
                int paramsCount;
                if (!isView) {
                    throw e;
                }
                int n = paramsCount = constructorSignature != null ? constructorSignature.length : 0;
                if (paramsCount == 0) {
                    throw e;
                }
                assert (constructorParameters != null);
                for (int i = 3; i >= 1; --i) {
                    if (i == paramsCount) continue;
                    int k = paramsCount < i ? paramsCount : i;
                    Class[] sig = new Class[i];
                    System.arraycopy(constructorSignature, 0, sig, 0, k);
                    Object[] params2 = new Object[i];
                    System.arraycopy(constructorParameters, 0, params2, 0, k);
                    for (int j = k + 1; j <= i; ++j) {
                        if (j == 2) {
                            sig[j - 1] = this.myLayoutLibrary.getClassLoader().loadClass("android.util.AttributeSet");
                            params2[j - 1] = null;
                            continue;
                        }
                        if (j != 3) continue;
                        sig[j - 1] = Integer.TYPE;
                        params2[j - 1] = 0;
                    }
                    constructorSignature = sig;
                    constructorParameters = params2;
                    try {
                        constructor = clazz.getConstructor(constructorSignature);
                        if (constructor == null) continue;
                        if (constructorSignature.length >= 2) break;
                        LOG.info("wrong_constructor: Custom view " + clazz.getSimpleName() + " is not using the 2- or 3-argument View constructors; XML attributes will not work");
                        this.myLogger.warning("wrongconstructor", String.format("Custom view %1$s is not using the 2- or 3-argument View constructors; XML attributes will not work", clazz.getSimpleName()), null, null);
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (constructor != null) break block10;
                throw e;
            }
        }
        constructor.setAccessible(true);
        return constructor.newInstance(constructorParameters);
    }

    @Nullable
    public Class<?> loadClass(@NotNull String className, boolean logError) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("loadClassB(%s)", LogAnonymizerUtil.anonymizeClassName(className)));
        }
        try {
            return this.myClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (logError && !className.equals("fragment")) {
                this.myLogger.addMissingClass(className);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object createViewFromSuperclass(@NotNull String className, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorArgs) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("createViewFromSuperClass(%s)", LogAnonymizerUtil.anonymizeClassName(className)));
        }
        Ref token = new Ref();
        token.set((Object)RenderSecurityManager.enterSafeRegion(this.myCredential));
        try {
            Object object = DumbService.getInstance((Project)this.myModule.getProject()).runReadActionInSmartMode(() -> {
                PsiClass psiClass = this.myModule.getDependencies().findPsiClassInModuleAndDependencies(className);
                if (psiClass == null) {
                    return null;
                }
                HashSet<String> visited = new HashSet<String>();
                for (psiClass = psiClass.getSuperClass(); psiClass != null; psiClass = psiClass.getSuperClass()) {
                    Object object;
                    String qName = psiClass.getQualifiedName();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("  parent " + LogAnonymizerUtil.anonymizeClassName(qName));
                    }
                    if (qName == null || !visited.add(qName) || "android.view.View".equals(psiClass.getQualifiedName())) break;
                    if (AndroidUtils.isAbstract(psiClass)) continue;
                    Class<?> aClass = this.myLoadedClasses.get(qName);
                    if (aClass == null && (aClass = this.myLayoutLibrary.getClassLoader().loadClass(qName)) != null) {
                        this.myLoadedClasses.put(qName, aClass);
                    }
                    if (aClass == null) continue;
                    try {
                        RenderSecurityManager.exitSafeRegion((Boolean)token.get());
                        object = this.createNewInstance(aClass, constructorSignature, constructorArgs, true);
                    }
                    catch (Throwable throwable) {
                        try {
                            token.set((Object)RenderSecurityManager.enterSafeRegion(this.myCredential));
                            throw throwable;
                        }
                        catch (Throwable e) {
                            LOG.debug(e);
                        }
                    }
                    token.set((Object)RenderSecurityManager.enterSafeRegion(this.myCredential));
                    return object;
                }
                return null;
            });
            return object;
        }
        finally {
            RenderSecurityManager.exitSafeRegion((Boolean)token.get());
        }
    }

    public void loadAndParseRClassSilently() {
        ResourceIdManager idManager = this.myModule.getResourceIdManager();
        idManager.resetCompiledIds(this::loadRClasses);
    }

    private void loadRClasses(@NotNull ResourceIdManager.RClassParser rClassParser) {
        this.myModule.getDependencies().getRClassesNames().forEach(rClassName -> {
            try {
                if (rClassName == null) {
                    LOG.info(String.format("loadAndParseRClass: failed to find manifest package for project %1$s", this.myModule.getProject().getName()));
                    return;
                }
                this.myLogger.setResourceClass((String)rClassName);
                this.loadAndParseRClass((String)rClassName, rClassParser);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                this.myLogger.setMissingResourceClass();
            }
        });
    }

    @VisibleForTesting
    void loadAndParseRClass(@NotNull String className, @NotNull ResourceIdManager.RClassParser rClassParser) throws ClassNotFoundException {
        Class<?> aClass;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("loadAndParseRClass(%s)", LogAnonymizerUtil.anonymizeClassName(className)));
        }
        if ((aClass = this.myLoadedClasses.get(className)) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  The R class is not loaded.");
            }
            boolean isClassLoaded = this.hasLoadedClass(className);
            aClass = this.myClassLoader.loadClass(className);
            if (!isClassLoaded) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("  Class found in module %s, first time load.", LogAnonymizerUtil.anonymize(this.myModule)));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("  Class already loaded in module %s.", LogAnonymizerUtil.anonymize(this.myModule)));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("  Class loaded");
            }
            this.myLoadedClasses.put(className, aClass);
            this.myLogger.setHasLoadedClasses();
        }
        rClassParser.parse(aClass);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("END loadAndParseRClass(%s)", LogAnonymizerUtil.anonymizeClassName(className)));
        }
    }

    public boolean hasLoadedClass(@NotNull String classFqn) {
        return this.myLoadedClasses.containsKey(classFqn);
    }
}

