/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.tools.idea.rendering.classloading.ClassTransform;
import com.android.utils.reflection.ReflectionUtilsKt;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.jetbrains.android.uipreview.ModuleClassLoaderHatchery;
import org.jetbrains.android.uipreview.ModuleClassLoaderProjectHelperService;
import org.jetbrains.android.uipreview.Preloader;
import org.jetbrains.android.uipreview.StudioModuleClassLoader;
import org.jetbrains.android.uipreview.StudioModuleClassLoaderManager;
import org.jetbrains.android.uipreview.StudioModuleClassLoaderManagerKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002\u001a\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0002\u001a\u001a\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u001a3\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u0017*\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00032\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001bH\u0002\u00a2\u0006\u0002\u0010\u001c\u001a\f\u0010\u001d\u001a\u00020\u0004*\u00020\u0018H\u0002\u001a$\u0010\u001e\u001a\u00020\u0014*\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"DUMMY_HOLDER", "", "HATCHERY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/android/uipreview/ModuleClassLoaderHatchery;", "getHATCHERY", "()Lcom/intellij/openapi/util/Key;", "PRELOADER", "Lorg/jetbrains/android/uipreview/Preloader;", "calculateTransformationsUniqueId", "", "projectClassesTransformationProvider", "Lcom/android/tools/idea/rendering/classloading/ClassTransform;", "nonProjectClassesTransformationProvider", "throwIfNotUnitTest", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "areTransformationsUpToDate", "", "Lorg/jetbrains/android/uipreview/StudioModuleClassLoader;", "getOrCreate", "T", "Lcom/intellij/openapi/util/UserDataHolder;", "key", "factory", "Lkotlin/Function0;", "(Lcom/intellij/openapi/util/UserDataHolder;Lcom/intellij/openapi/util/Key;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getOrCreateHatchery", "isCompatible", "parent", "Ljava/lang/ClassLoader;", "projectTransformations", "nonProjectTransformations", "intellij.android.core"})
public final class StudioModuleClassLoaderManagerKt {
    @NotNull
    private static final Object DUMMY_HOLDER = new Object();
    @NotNull
    private static final Key<Preloader> PRELOADER;
    @NotNull
    private static final Key<ModuleClassLoaderHatchery> HATCHERY;

    private static final void throwIfNotUnitTest(Exception e) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw e;
        }
        Logger.getInstance(ModuleClassLoaderProjectHelperService.class).info("ModuleClassLoaderProjectHelperService is disabled for unit testing since there is no ProjectSystemBuildManager");
    }

    @NotNull
    public static final Key<ModuleClassLoaderHatchery> getHATCHERY() {
        return HATCHERY;
    }

    private static final String calculateTransformationsUniqueId(ClassTransform projectClassesTransformationProvider, ClassTransform nonProjectClassesTransformationProvider) {
        return Hashing.goodFastHash((int)64).newHasher().putString((CharSequence)projectClassesTransformationProvider.getId(), Charsets.UTF_8).putString((CharSequence)nonProjectClassesTransformationProvider.getId(), Charsets.UTF_8).hash().toString();
    }

    public static final boolean areTransformationsUpToDate(@NotNull StudioModuleClassLoader $this$areTransformationsUpToDate, @NotNull ClassTransform projectClassesTransformationProvider, @NotNull ClassTransform nonProjectClassesTransformationProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$areTransformationsUpToDate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)projectClassesTransformationProvider, (String)"projectClassesTransformationProvider");
        Intrinsics.checkNotNullParameter((Object)nonProjectClassesTransformationProvider, (String)"nonProjectClassesTransformationProvider");
        ClassTransform classTransform = $this$areTransformationsUpToDate.getProjectClassesTransform();
        Intrinsics.checkNotNullExpressionValue((Object)classTransform, (String)"this.projectClassesTransform");
        ClassTransform classTransform2 = $this$areTransformationsUpToDate.getNonProjectClassesTransform();
        Intrinsics.checkNotNullExpressionValue((Object)classTransform2, (String)"this.nonProjectClassesTransform");
        return Intrinsics.areEqual((Object)StudioModuleClassLoaderManagerKt.calculateTransformationsUniqueId(classTransform, classTransform2), (Object)StudioModuleClassLoaderManagerKt.calculateTransformationsUniqueId(projectClassesTransformationProvider, nonProjectClassesTransformationProvider));
    }

    public static final boolean isCompatible(@NotNull StudioModuleClassLoader $this$isCompatible, @Nullable ClassLoader parent2, @NotNull ClassTransform projectTransformations, @NotNull ClassTransform nonProjectTransformations) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isCompatible, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)projectTransformations, (String)"projectTransformations");
        Intrinsics.checkNotNullParameter((Object)nonProjectTransformations, (String)"nonProjectTransformations");
        if (!$this$isCompatible.isCompatibleParentClassLoader(parent2)) {
            StudioModuleClassLoaderManager.Companion.getLOG().debug("Parent has changed, discarding ModuleClassLoader");
            bl = false;
        } else if (!StudioModuleClassLoaderManagerKt.areTransformationsUpToDate($this$isCompatible, projectTransformations, nonProjectTransformations)) {
            StudioModuleClassLoaderManager.Companion.getLOG().debug("Transformations have changed, discarding ModuleClassLoader");
            bl = false;
        } else if (!$this$isCompatible.areDependenciesUpToDate()) {
            StudioModuleClassLoaderManager.Companion.getLOG().debug("Files have changed, discarding ModuleClassLoader");
            bl = false;
        } else {
            StudioModuleClassLoaderManager.Companion.getLOG().debug("ModuleClassLoader is up to date");
            bl = true;
        }
        return bl;
    }

    private static final <T> T getOrCreate(UserDataHolder $this$getOrCreate, Key<T> key, Function0<? extends T> factory2) {
        Object object;
        Object object2 = $this$getOrCreate.getUserData(key);
        if (object2 != null) {
            Object it = object2;
            boolean bl = false;
            return (T)it;
        }
        Object it = object = factory2.invoke();
        boolean bl = false;
        $this$getOrCreate.putUserData(key, it);
        return (T)object;
    }

    private static final ModuleClassLoaderHatchery getOrCreateHatchery(UserDataHolder $this$getOrCreateHatchery) {
        return StudioModuleClassLoaderManagerKt.getOrCreate($this$getOrCreateHatchery, HATCHERY, getOrCreateHatchery.1.INSTANCE);
    }

    public static final /* synthetic */ void access$throwIfNotUnitTest(Exception e) {
        StudioModuleClassLoaderManagerKt.throwIfNotUnitTest(e);
    }

    public static final /* synthetic */ Key access$getPRELOADER$p() {
        return PRELOADER;
    }

    public static final /* synthetic */ ModuleClassLoaderHatchery access$getOrCreateHatchery(UserDataHolder $receiver) {
        return StudioModuleClassLoaderManagerKt.getOrCreateHatchery($receiver);
    }

    public static final /* synthetic */ Object access$getDUMMY_HOLDER$p() {
        return DUMMY_HOLDER;
    }

    static {
        Key key = Key.create((String)ReflectionUtilsKt.getQualifiedName((KProperty)((KProperty)PRELOADER.1.INSTANCE)));
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(::PRELOADER.qualifiedName)");
        PRELOADER = key;
        Key key2 = Key.create((String)ReflectionUtilsKt.getQualifiedName((KProperty)((KProperty)HATCHERY.1.INSTANCE)));
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(::HATCHERY.qualifiedName)");
        HATCHERY = key2;
    }
}

