/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.layoutlib.reflection.TrackingThreadLocal;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.classloading.ClassConverter;
import com.android.tools.idea.rendering.classloading.ClassTransform;
import com.android.tools.idea.rendering.classloading.CooperativeInterruptTransform;
import com.android.tools.idea.rendering.classloading.FilteringClassLoader;
import com.android.tools.idea.rendering.classloading.FirewalledResourcesClassLoader;
import com.android.tools.idea.rendering.classloading.PreviewAnimationClockMethodTransform;
import com.android.tools.idea.rendering.classloading.ReflectionUtilKt;
import com.android.tools.idea.rendering.classloading.RenderActionAllocationLimiterTransform;
import com.android.tools.idea.rendering.classloading.RepackageTransform;
import com.android.tools.idea.rendering.classloading.RequestExecutorTransform;
import com.android.tools.idea.rendering.classloading.ResourcesCompatTransform;
import com.android.tools.idea.rendering.classloading.SdkIntReplacer;
import com.android.tools.idea.rendering.classloading.ThreadControllingTransform;
import com.android.tools.idea.rendering.classloading.ThreadLocalTrackingTransform;
import com.android.tools.idea.rendering.classloading.UtilKt;
import com.android.tools.idea.rendering.classloading.VersionClassTransform;
import com.android.tools.idea.rendering.classloading.ViewMethodWrapperTransform;
import com.android.tools.idea.rendering.classloading.ViewTreeLifecycleTransform;
import com.android.tools.idea.rendering.classloading.loaders.ProjectSystemClassLoader;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.WeakReferenceDisposableWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import kotlin.jvm.functions.Function1;
import org.jetbrains.android.uipreview.ClassBinaryCache;
import org.jetbrains.android.uipreview.ClassBinaryCacheManager;
import org.jetbrains.android.uipreview.ModuleClassLoader;
import org.jetbrains.android.uipreview.ModuleClassLoaderDiagnosticsRead;
import org.jetbrains.android.uipreview.ModuleClassLoaderDiagnosticsWrite;
import org.jetbrains.android.uipreview.ModuleClassLoaderImpl;
import org.jetbrains.android.uipreview.ModuleClassLoaderOverlays;
import org.jetbrains.android.uipreview.ModuleClassLoaderUtil;
import org.jetbrains.android.uipreview.ModuleProvider;
import org.jetbrains.android.uipreview.ModuleRenderContext;
import org.jetbrains.android.uipreview.classloading.LibraryResourceClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public final class StudioModuleClassLoader
extends ModuleClassLoader
implements ModuleProvider {
    private static final Logger LOG = Logger.getInstance(StudioModuleClassLoader.class);
    private static final ImmutableList<String> PACKAGES_TO_RENAME = ImmutableList.of((Object)"kotlin.", (Object)"kotlinx.", (Object)"android.support.constraint.solver.", (Object)"okio.");
    private static final ImmutableList<String> ALLOWED_PACKAGES_FROM_PLUGIN = ImmutableList.of((Object)"java.", (Object)"javax.", (Object)"jdk.", (Object)"sun.", (Object)"com.sun.", (Object)"org.w3c.", (Object)"org.xmlss.", (Object)"android.", (Object)"dalvik.", (Object)"org.apache.", (Object)"org.xmlpull.", (Object)"org.json.", (Object[])new String[]{"junit.", "com.android.", "org.jetbrains.android.uipreview.", "androidx.compose.animation.tooling."});
    static final ClassTransform PROJECT_DEFAULT_TRANSFORMS = UtilKt.toClassTransform(ViewMethodWrapperTransform::new, visitor2 -> new VersionClassTransform((ClassVisitor)visitor2, ClassConverter.getCurrentClassVersion(), 0), ThreadLocalTrackingTransform::new, ThreadControllingTransform::new, CooperativeInterruptTransform::new, visitor2 -> (Boolean)StudioFlags.COMPOSE_ALLOCATION_LIMITER.get() != false ? new RenderActionAllocationLimiterTransform((ClassVisitor)visitor2) : visitor2, SdkIntReplacer::new, visitor2 -> new RepackageTransform((ClassVisitor)visitor2, (Collection<String>)PACKAGES_TO_RENAME, "_layoutlib_._internal_."));
    static final ClassTransform NON_PROJECT_CLASSES_DEFAULT_TRANSFORMS = UtilKt.toClassTransform(ViewMethodWrapperTransform::new, visitor2 -> new VersionClassTransform((ClassVisitor)visitor2, ClassConverter.getCurrentClassVersion(), 0), ThreadLocalTrackingTransform::new, ThreadControllingTransform::new, PreviewAnimationClockMethodTransform::new, ResourcesCompatTransform::new, RequestExecutorTransform::new, ViewTreeLifecycleTransform::new, SdkIntReplacer::new, visitor2 -> new RepackageTransform((ClassVisitor)visitor2, (Collection<String>)PACKAGES_TO_RENAME, "_layoutlib_._internal_."));
    private static final ExecutorService ourDisposeService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"ModuleClassLoader Dispose Thread", (int)1);
    private final WeakReference<Module> myModuleReference;
    @NotNull
    private final ModuleClassLoaderDiagnosticsWrite myDiagnostics;
    private final Supplier<PsiFile> myPsiFileProvider;
    private final ModuleClassLoaderImpl myImpl;
    private final ClassLoader myParentAtConstruction;
    private final AtomicBoolean isDisposed = new AtomicBoolean(false);

    StudioModuleClassLoader(@Nullable ClassLoader parent2, @NotNull ModuleRenderContext renderContext, @NotNull ClassTransform projectTransformations, @NotNull ClassTransform nonProjectTransformations, @NotNull ModuleClassLoaderDiagnosticsWrite diagnostics) {
        this(parent2, renderContext, projectTransformations, nonProjectTransformations, (Boolean)StudioFlags.NELE_CLASS_BINARY_CACHE.get() != false ? ClassBinaryCacheManager.getInstance().getCache(renderContext.getModule()) : ClassBinaryCache.NO_CACHE, diagnostics);
    }

    private StudioModuleClassLoader(@Nullable ClassLoader parent2, @NotNull ModuleRenderContext renderContext, @NotNull ModuleClassLoaderImpl loader, @NotNull ModuleClassLoaderDiagnosticsWrite diagnostics) {
        super(new LibraryResourceClassLoader(new FirewalledResourcesClassLoader(FilteringClassLoader.allowedPrefixes(parent2, ALLOWED_PACKAGES_FROM_PLUGIN)), renderContext.getModule(), loader), loader);
        this.myParentAtConstruction = parent2;
        this.myImpl = loader;
        this.myModuleReference = new WeakReference<Module>(renderContext.getModule());
        Disposer.register((Disposable)renderContext.getModule(), (Disposable)new WeakReferenceDisposableWrapper((Disposable)this));
        this.myPsiFileProvider = renderContext.getFileProvider();
        this.myDiagnostics = diagnostics;
    }

    @NotNull
    private static ProjectSystemClassLoader createDefaultProjectSystemClassLoader(@NotNull Module theModule, @NotNull Supplier<PsiFile> psiFileProvider) {
        WeakReference<Module> moduleRef = new WeakReference<Module>(theModule);
        return new ProjectSystemClassLoader((Function1<? super String, ? extends VirtualFile>)((Function1)fqcn -> {
            Module module2 = (Module)moduleRef.get();
            if (module2 == null || module2.isDisposed()) {
                return null;
            }
            PsiFile psiFile = (PsiFile)psiFileProvider.get();
            VirtualFile virtualFile = psiFile != null ? psiFile.getVirtualFile() : null;
            return ProjectSystemUtil.getModuleSystem(module2).getClassFileFinderForSourceFile(virtualFile).findClassFile((String)fqcn);
        }));
    }

    private StudioModuleClassLoader(@Nullable ClassLoader parent2, @NotNull ModuleRenderContext renderContext, @NotNull ClassTransform projectTransformations, @NotNull ClassTransform nonProjectTransformations, @NotNull ClassBinaryCache cache2, @NotNull ModuleClassLoaderDiagnosticsWrite diagnostics) {
        this(parent2, renderContext, new ModuleClassLoaderImpl(renderContext.getModule(), StudioModuleClassLoader.createDefaultProjectSystemClassLoader(renderContext.getModule(), renderContext.getFileProvider()), parent2, projectTransformations, nonProjectTransformations, cache2, diagnostics), diagnostics);
    }

    boolean isCompatibleParentClassLoader(@Nullable ClassLoader parent2) {
        return this.getParentAtConstruction() == parent2;
    }

    @Nullable
    ClassLoader getParentAtConstruction() {
        return this.myParentAtConstruction;
    }

    @NotNull
    public Set<String> getNonProjectLoadedClasses() {
        return this.myImpl.getNonProjectLoadedClassNames();
    }

    @NotNull
    public Set<String> getProjectLoadedClasses() {
        return this.myImpl.getProjectLoadedClassNames();
    }

    @NotNull
    public ClassTransform getProjectClassesTransform() {
        return this.myImpl.getProjectTransforms();
    }

    @NotNull
    public ClassTransform getNonProjectClassesTransform() {
        return this.myImpl.getNonProjectTransforms();
    }

    public boolean areDependenciesUpToDate() {
        Module module2 = this.getModule();
        if (module2 == null) {
            return true;
        }
        List<Path> currentlyLoadedLibraries = this.myImpl.getExternalLibraries();
        List<Path> moduleLibraries = ModuleClassLoaderUtil.getExternalLibraries(module2);
        return currentlyLoadedLibraries.size() == moduleLibraries.size() && currentlyLoadedLibraries.containsAll(moduleLibraries);
    }

    @VisibleForTesting
    boolean isUserCodeUpToDateNonCached() {
        return ModuleClassLoaderUtil.isUserCodeUpToDate(this.myImpl);
    }

    @Override
    public boolean isUserCodeUpToDate() {
        Module module2 = this.getModule();
        if (module2 == null) {
            return true;
        }
        return (Boolean)CachedValuesManager.getManager((Project)module2.getProject()).getCachedValue((UserDataHolder)this.myImpl, () -> CachedValueProvider.Result.create((Object)this.isUserCodeUpToDateNonCached(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ModuleClassLoaderOverlays.getInstance(module2)}));
    }

    @Override
    public Enumeration<URL> getResources(String name2) throws IOException {
        return this.myImpl.getResources(name2);
    }

    @Override
    @Nullable
    public URL getResource(String name2) {
        return this.myImpl.getResource(name2);
    }

    public boolean isClassLoaded(@NotNull String className) {
        return this.findLoadedClass(className) != null;
    }

    @Override
    protected void onBeforeLoadClass(@NotNull String fqcn) {
        this.myDiagnostics.classLoadStart(fqcn);
    }

    @Override
    protected void onAfterLoadClass(@NotNull String fqcn, boolean loaded, long durationMs) {
        this.myDiagnostics.classLoadedEnd(fqcn, durationMs);
    }

    @Override
    protected void onBeforeFindClass(@NotNull String fqcn) {
        this.myDiagnostics.classFindStart(fqcn);
    }

    @Override
    protected void onAfterFindClass(@NotNull String fqcn, boolean found, long durationMs) {
        this.myDiagnostics.classFindEnd(fqcn, found, durationMs);
    }

    @Override
    @Nullable
    public Module getModule() {
        return (Module)this.myModuleReference.get();
    }

    @Override
    @NotNull
    public ModuleClassLoaderDiagnosticsRead getStats() {
        return this.myDiagnostics;
    }

    @Nullable
    public ModuleRenderContext getModuleContext() {
        Module module2 = this.getModule();
        return module2 == null ? null : ModuleRenderContext.forFile(() -> module2, this.myPsiFileProvider);
    }

    @TestOnly
    void injectProjectClassFile(@NotNull String fqcn, @NotNull VirtualFile file2) {
        this.myImpl.injectProjectClassFile(fqcn, file2);
    }

    @TestOnly
    void injectProjectOvelaryLoadedClass(@NotNull String fqcn) {
        this.myImpl.injectProjectOvelaryLoadedClass(fqcn);
    }

    private void waitForCoroutineThreadToStop() {
        try {
            Class<?> defaultExecutorClass = this.findLoadedClass("_layoutlib_._internal_.kotlinx.coroutines.DefaultExecutor");
            if (defaultExecutorClass == null) {
                return;
            }
            Method isThreadPresentMethod = ReflectionUtilKt.findMethodLike(defaultExecutorClass, "isThreadPresent");
            if (isThreadPresentMethod == null) {
                LOG.warn("Method to check coroutine thread existence is not found.");
                return;
            }
            Field instanceField = defaultExecutorClass.getDeclaredField("INSTANCE");
            Object defaultExecutorObj = instanceField.get(null);
            isThreadPresentMethod.setAccessible(true);
            int ITERATIONS = 11;
            for (int i = 0; i <= 11; ++i) {
                if (!((Boolean)isThreadPresentMethod.invoke(defaultExecutorObj, new Object[0])).booleanValue()) {
                    return;
                }
                if (i == 11) continue;
                Thread.sleep(100L);
            }
            LOG.warn("DefaultExecutor thread is still running");
        }
        catch (Throwable t) {
            LOG.warn(t);
        }
    }

    @Nullable
    StudioModuleClassLoader copy(@NotNull ModuleClassLoaderDiagnosticsWrite diagnostics) {
        ModuleRenderContext renderContext = this.getModuleContext();
        if (this.isDisposed() || renderContext == null || renderContext.isDisposed()) {
            return null;
        }
        return new StudioModuleClassLoader(this.myParentAtConstruction, renderContext, this.getProjectClassesTransform(), this.getNonProjectClassesTransform(), diagnostics);
    }

    public boolean isDisposed() {
        return this.isDisposed.get();
    }

    public void dispose() {
        this.isDisposed.set(true);
        this.myImpl.dispose();
        ourDisposeService.submit(() -> {
            this.waitForCoroutineThreadToStop();
            Set<ThreadLocal<?>> threadLocals = TrackingThreadLocal.clearThreadLocals(this);
            if (threadLocals == null || threadLocals.isEmpty()) {
                return;
            }
            RenderService.getRenderAsyncActionExecutor().runAsyncAction(() -> {
                for (ThreadLocal threadLocal : threadLocals) {
                    try {
                        threadLocal.remove();
                    }
                    catch (Exception e) {
                        LOG.warn((Throwable)e);
                    }
                }
            });
        });
    }
}

