/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.annotations.concurrency.AnyThread;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import com.intellij.openapi.module.Module;
import java.time.Duration;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.uipreview.ClassBinaryCache;
import org.jetbrains.android.uipreview.ClassBinaryCacheManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0015H\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u000b\u001aB\u0012\f\u0012\n \r*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e \r* \u0012\f\u0012\n \r*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00100\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0015\u0012\b\u0012\u00060\u0016R\u00020\u00000\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/android/uipreview/ClassBinaryCacheManager;", "", "ticker", "Lcom/google/common/base/Ticker;", "maxWeight", "", "expireMinutes", "(Lcom/google/common/base/Ticker;JJ)V", "classFqn2LibraryPath", "", "", "globalCache", "Lcom/google/common/cache/Cache;", "kotlin.jvm.PlatformType", "", "libraryPath2ClassFqns", "", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "moduleCaches", "Ljava/util/WeakHashMap;", "Lcom/intellij/openapi/module/Module;", "Lorg/jetbrains/android/uipreview/ClassBinaryCacheManager$ModuleClassCache;", "getCache", "Lorg/jetbrains/android/uipreview/ClassBinaryCache;", "module", "Companion", "ModuleClassCache", "intellij.android.core"})
public final class ClassBinaryCacheManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WeakHashMap<Module, ModuleClassCache> moduleCaches = new WeakHashMap();
    @NotNull
    private ReentrantLock lock = new ReentrantLock();
    @NotNull
    private final Map<String, Set<String>> libraryPath2ClassFqns = new LinkedHashMap();
    @NotNull
    private final Map<String, String> classFqn2LibraryPath = new LinkedHashMap();
    private final Cache<String, byte[]> globalCache;
    @NotNull
    private static final ClassBinaryCacheManager globalManager;

    private ClassBinaryCacheManager(Ticker ticker, long maxWeight, long expireMinutes) {
        this.globalCache = CacheBuilder.newBuilder().ticker(ticker).concurrencyLevel(1).maximumWeight(maxWeight).weigher((Weigher)globalCache.1.INSTANCE).expireAfterAccess(Duration.ofMinutes(expireMinutes)).removalListener(new RemovalListener(this){
            final /* synthetic */ ClassBinaryCacheManager this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void onRemoval(RemovalNotification<String, byte[]> it) {
                Lock lock = ClassBinaryCacheManager.access$getLock$p(this.this$0);
                ClassBinaryCacheManager classBinaryCacheManager = this.this$0;
                lock.lock();
                try {
                    boolean bl = false;
                    String string = (String)ClassBinaryCacheManager.access$getClassFqn2LibraryPath$p(classBinaryCacheManager).remove(it.getKey());
                    if (string != null) {
                        String url = string;
                        boolean bl2 = false;
                        Set set = (Set)ClassBinaryCacheManager.access$getLibraryPath2ClassFqns$p(classBinaryCacheManager).get(url);
                        if (set != null) {
                            set.remove(it.getKey());
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
        }).build();
    }

    @AnyThread
    @NotNull
    public final synchronized ClassBinaryCache getCache(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        ModuleClassCache moduleClassCache = this.moduleCaches.computeIfAbsent(module2, new Function(this){
            final /* synthetic */ ClassBinaryCacheManager this$0;
            {
                this.this$0 = $receiver;
            }

            public final ModuleClassCache apply(Module it) {
                return this.this$0.new ModuleClassCache();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)moduleClassCache, (String)"@Synchronized\n  @AnyThre\u2026 ModuleClassCache() }\n  }");
        return moduleClassCache;
    }

    @JvmStatic
    @NotNull
    public static final ClassBinaryCacheManager getInstance() {
        return Companion.getInstance();
    }

    public /* synthetic */ ClassBinaryCacheManager(Ticker ticker, long maxWeight, long expireMinutes, DefaultConstructorMarker $constructor_marker) {
        this(ticker, maxWeight, expireMinutes);
    }

    static {
        Ticker ticker = Ticker.systemTicker();
        Intrinsics.checkNotNullExpressionValue((Object)ticker, (String)"systemTicker()");
        globalManager = new ClassBinaryCacheManager(ticker, 100000000L, 30L);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0007J \u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/android/uipreview/ClassBinaryCacheManager$Companion;", "", "()V", "globalManager", "Lorg/jetbrains/android/uipreview/ClassBinaryCacheManager;", "getInstance", "getTestInstance", "ticker", "Lcom/google/common/base/Ticker;", "maxWeight", "", "expireMinutes", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ClassBinaryCacheManager getInstance() {
            return globalManager;
        }

        @TestOnly
        @NotNull
        public final ClassBinaryCacheManager getTestInstance(@NotNull Ticker ticker, long maxWeight, long expireMinutes) {
            Intrinsics.checkNotNullParameter((Object)ticker, (String)"ticker");
            return new ClassBinaryCacheManager(ticker, maxWeight, expireMinutes, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0016\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0017R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/android/uipreview/ClassBinaryCacheManager$ModuleClassCache;", "Lorg/jetbrains/android/uipreview/ClassBinaryCache;", "(Lorg/jetbrains/android/uipreview/ClassBinaryCacheManager;)V", "libraryPaths", "", "", "get", "", "fqcn", "transformationId", "getCachingKey", "notCurrentDependency", "", "path", "put", "", "libraryPath", "data", "setDependencies", "paths", "", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nClassBinaryCacheManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassBinaryCacheManager.kt\norg/jetbrains/android/uipreview/ClassBinaryCacheManager$ModuleClassCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1#2:132\n1851#3,2:133\n*S KotlinDebug\n*F\n+ 1 ClassBinaryCacheManager.kt\norg/jetbrains/android/uipreview/ClassBinaryCacheManager$ModuleClassCache\n*L\n95#1:133,2\n*E\n"})
    private final class ModuleClassCache
    implements ClassBinaryCache {
        @NotNull
        private Set<String> libraryPaths = SetsKt.emptySet();

        private final synchronized boolean notCurrentDependency(String path2) {
            return !CollectionsKt.contains((Iterable)this.libraryPaths, (Object)path2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public byte[] get(@NotNull String fqcn, @NotNull String transformationId) {
            String $i$a$-withLock-ClassBinaryCacheManager$ModuleClassCache$get$libraryPath$22;
            Intrinsics.checkNotNullParameter((Object)fqcn, (String)"fqcn");
            Intrinsics.checkNotNullParameter((Object)transformationId, (String)"transformationId");
            String key = this.getCachingKey(fqcn, transformationId);
            Object object = ClassBinaryCacheManager.this.lock;
            ClassBinaryCacheManager classBinaryCacheManager = ClassBinaryCacheManager.this;
            object.lock();
            try {
                boolean $i$a$-withLock-ClassBinaryCacheManager$ModuleClassCache$get$libraryPath$22 = false;
                $i$a$-withLock-ClassBinaryCacheManager$ModuleClassCache$get$libraryPath$22 = (String)classBinaryCacheManager.classFqn2LibraryPath.get(key);
            }
            finally {
                object.unlock();
            }
            String libraryPath = $i$a$-withLock-ClassBinaryCacheManager$ModuleClassCache$get$libraryPath$22;
            if (this.notCurrentDependency(libraryPath)) {
                String string = libraryPath;
                if (string != null) {
                    Set set;
                    object = string;
                    classBinaryCacheManager = ClassBinaryCacheManager.this;
                    Object it = object;
                    boolean bl = false;
                    Lock lock = classBinaryCacheManager.lock;
                    lock.lock();
                    try {
                        boolean $i$a$-withLock-ClassBinaryCacheManager$ModuleClassCache$get$1$22 = false;
                        Set $i$a$-withLock-ClassBinaryCacheManager$ModuleClassCache$get$1$22 = (Set)classBinaryCacheManager.libraryPath2ClassFqns.remove(libraryPath);
                        set = $i$a$-withLock-ClassBinaryCacheManager$ModuleClassCache$get$1$22;
                    }
                    finally {
                        lock.unlock();
                    }
                    if (set != null) {
                        Iterable $this$forEach$iv = set;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            String it2 = (String)element$iv;
                            boolean bl2 = false;
                            classBinaryCacheManager.globalCache.invalidate((Object)it2);
                        }
                    }
                }
                return null;
            }
            return (byte[])ClassBinaryCacheManager.this.globalCache.getIfPresent((Object)key);
        }

        private final String getCachingKey(String fqcn, String transformationId) {
            return transformationId + ":" + fqcn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(@NotNull String fqcn, @NotNull String transformationId, @NotNull String libraryPath, @NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)fqcn, (String)"fqcn");
            Intrinsics.checkNotNullParameter((Object)transformationId, (String)"transformationId");
            Intrinsics.checkNotNullParameter((Object)libraryPath, (String)"libraryPath");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            String key = this.getCachingKey(fqcn, transformationId);
            Lock lock = ClassBinaryCacheManager.this.lock;
            ClassBinaryCacheManager classBinaryCacheManager = ClassBinaryCacheManager.this;
            lock.lock();
            try {
                boolean bl = false;
                classBinaryCacheManager.classFqn2LibraryPath.put(key, libraryPath);
                boolean bl2 = ((Set)classBinaryCacheManager.libraryPath2ClassFqns.computeIfAbsent(libraryPath, put.1.1.INSTANCE)).add(fqcn);
            }
            finally {
                lock.unlock();
            }
            ClassBinaryCacheManager.this.globalCache.put((Object)key, (Object)data);
        }

        @Override
        @AnyThread
        public synchronized void setDependencies(@NotNull Collection<String> paths) {
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            this.libraryPaths = CollectionsKt.toSet((Iterable)paths);
        }
    }
}

