/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseClassDialog
extends DialogWrapper
implements ListSelectionListener {
    private final JList<PsiClass> myList = new JBList();
    private final JComponent myComponent = new JBScrollPane(this.myList, 20, 31);
    private String myResultClassName;

    private ChooseClassDialog(Module module2, String title, @NotNull Collection<PsiClass> classes2) {
        super(module2.getProject());
        new DoubleClickListener(){

            public boolean onDoubleClick(@NotNull MouseEvent e) {
                if (ChooseClassDialog.this.myList.getSelectedValue() != null) {
                    ChooseClassDialog.this.close(0);
                    return true;
                }
                return false;
            }
        }.installOn(this.myList);
        final DefaultListModel<PsiClass> model2 = new DefaultListModel<PsiClass>();
        model2.addAll(classes2);
        model2.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                this.remeasureDialog();
            }

            private void remeasureDialog() {
                model2.removeListDataListener(this);
                if (ChooseClassDialog.this.isVisible()) {
                    ChooseClassDialog.this.pack();
                }
            }
        });
        this.myList.setModel(model2);
        this.myList.setCellRenderer((ListCellRenderer<PsiClass>)new PsiClassListCellRenderer());
        ListSelectionModel selectionModel = this.myList.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(this);
        new ListSpeedSearch<PsiClass>(this.myList){

            protected boolean isMatchingElement(Object element2, String pattern) {
                PsiClass psiClass = (PsiClass)element2;
                assert (psiClass.getName() != null && psiClass.getQualifiedName() != null);
                return this.compare(psiClass.getName(), pattern) || this.compare(psiClass.getQualifiedName(), pattern);
            }
        };
        this.setTitle(title);
        this.setOKActionEnabled(false);
        this.init();
    }

    private void setSelectedClass(@NotNull String className) {
        ListModel<PsiClass> model2 = this.myList.getModel();
        for (int index2 = 0; index2 < this.myList.getModel().getSize(); ++index2) {
            if (!className.equals(model2.getElementAt(index2).getQualifiedName())) continue;
            this.myList.setSelectedIndex(index2);
            break;
        }
    }

    @NotNull
    protected static Collection<PsiClass> findClasses(@NotNull Module module2, boolean includeAll, @NotNull Predicate<PsiClass> filter2, @NotNull String[] classes2) {
        ArrayList<PsiClass> collection2 = new ArrayList<PsiClass>(classes2.length);
        for (String className : classes2) {
            for (PsiClass psiClass : ChooseClassDialog.findInheritors(module2, className, includeAll)) {
                if (!filter2.test(psiClass)) continue;
                collection2.add(psiClass);
            }
        }
        Collator collator = Collator.getInstance(Locale.US);
        return collection2.stream().sorted((psiClass1, psiClass2) -> collator.compare(SymbolPresentationUtil.getSymbolPresentableText((PsiElement)psiClass1), SymbolPresentationUtil.getSymbolPresentableText((PsiElement)psiClass2))).collect(Collectors.toUnmodifiableList());
    }

    private static Collection<PsiClass> findInheritors(Module module2, String name2, boolean includeAll) {
        PsiClass base = ChooseClassDialog.findClass(module2, name2);
        if (base != null) {
            Collection<Object> classes2;
            GlobalSearchScope scope2 = includeAll ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2, (boolean)false) : GlobalSearchScope.moduleScope((Module)module2);
            try {
                classes2 = ClassInheritorsSearch.search((PsiClass)base, (SearchScope)scope2, (boolean)true).findAll();
            }
            catch (IndexNotReadyException e) {
                classes2 = Collections.emptyList();
            }
            return classes2;
        }
        return Collections.emptyList();
    }

    @Nullable
    public static PsiClass findClass(Module module2, @Nullable String name2) {
        PsiClass aClass;
        if (name2 == null) {
            return null;
        }
        Project project = module2.getProject();
        try {
            aClass = JavaPsiFacade.getInstance((Project)project).findClass(name2, GlobalSearchScope.allScope((Project)project));
        }
        catch (IndexNotReadyException e) {
            aClass = null;
        }
        return aClass;
    }

    @Nullable
    public static String openDialog(@NotNull Module module2, @NotNull String title, @Nullable String currentValue, @Nullable Predicate<PsiClass> filter2, String ... classes2) {
        Project project = module2.getProject();
        DumbService dumbService = DumbService.getInstance((Project)project);
        if (dumbService.isDumb()) {
            dumbService.showDumbModeNotification(String.format("%1$s are not available while indices are updating.", title));
            return null;
        }
        Collection<PsiClass> filteredClasses = ChooseClassDialog.findClasses(module2, true, filter2 != null ? filter2 : aClass -> true, classes2);
        ChooseClassDialog dialog2 = new ChooseClassDialog(module2, title, filteredClasses);
        if (currentValue != null) {
            dialog2.setSelectedClass(currentValue);
        }
        if (!dialog2.hasChoices()) {
            String emptyErrorTitle = "No " + title + " Found";
            String emptyErrorMessage = "You must first create one or more " + title + " in code";
            Messages.showErrorDialog((String)emptyErrorMessage, (String)emptyErrorTitle);
            return null;
        }
        return dialog2.showAndGet() ? dialog2.getClassName() : null;
    }

    @NotNull
    public static Predicate<PsiClass> getIsPublicAndUnrestrictedFilter() {
        return psiClass -> {
            PsiModifierList modifiers = psiClass.getModifierList();
            if (modifiers == null) {
                return false;
            }
            if (!modifiers.hasModifierProperty("public")) {
                return false;
            }
            for (PsiAnnotation annotation : modifiers.getAnnotations()) {
                if (!AnnotationDetectorKt.RESTRICT_TO_ANNOTATION.isEquals(annotation.getQualifiedName())) continue;
                return false;
            }
            return true;
        };
    }

    @NotNull
    public static Predicate<PsiClass> qualifiedNameFilter(@NotNull Predicate<String> filter2) {
        return psiClass -> {
            String qualifiedName = psiClass.getQualifiedName();
            if (qualifiedName == null) {
                return false;
            }
            return filter2.test(qualifiedName);
        };
    }

    @NotNull
    public static Predicate<String> getIsUserDefinedFilter() {
        return qualifiedName -> !qualifiedName.startsWith("android.") && !qualifiedName.startsWith("android.support.") && !qualifiedName.startsWith("androidx.") && !qualifiedName.startsWith("com.google.android.");
    }

    @NotNull
    public static Predicate<PsiClass> getUserDefinedPublicAndUnrestrictedFilter() {
        return ChooseClassDialog.getIsPublicAndUnrestrictedFilter().and(ChooseClassDialog.qualifiedNameFilter(ChooseClassDialog.getIsUserDefinedFilter()));
    }

    private boolean hasChoices() {
        return this.myList.getModel().getSize() > 0;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    protected JComponent createCenterPanel() {
        return this.myComponent;
    }

    public String getClassName() {
        return this.myResultClassName;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        PsiClass psiClass = this.myList.getSelectedValue();
        this.setOKActionEnabled(psiClass != null);
        this.myResultClassName = psiClass == null ? null : psiClass.getQualifiedName();
    }
}

