/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.spellchecker;

import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/android/spellchecker/GoogleServicesJsonSpellcheckingStrategy;", "Lcom/intellij/spellchecker/tokenizer/SpellcheckingStrategy;", "()V", "getTokenizer", "Lcom/intellij/spellchecker/tokenizer/Tokenizer;", "element", "Lcom/intellij/psi/PsiElement;", "isMyContext", "", "Companion", "intellij.android.core"})
public final class GoogleServicesJsonSpellcheckingStrategy
extends SpellcheckingStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> IGNORE_SUFFIX;

    @NotNull
    public Tokenizer<?> getTokenizer(@Nullable PsiElement element2) {
        Tokenizer tokenizer;
        if (element2 instanceof JsonStringLiteral) {
            tokenizer = (Tokenizer)new Tokenizer<JsonStringLiteral>(){

                public void tokenize(@NotNull JsonStringLiteral element2, @NotNull TokenConsumer consumer) {
                    boolean bl;
                    block6: {
                        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
                        PsiElement $this$parentOfType_u24default$iv = (PsiElement)element2;
                        boolean withSelf$iv = false;
                        boolean $i$f$parentOfType = false;
                        JsonProperty jsonProperty = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, JsonProperty.class, (boolean)true);
                        if (jsonProperty == null) {
                            consumer.consumeToken((PsiElement)element2, (Splitter)PlainTextSplitter.getInstance());
                            return;
                        }
                        JsonProperty property2 = jsonProperty;
                        JsonValue jsonValue = property2.getNameElement();
                        Object object = jsonValue instanceof JsonStringLiteral ? (JsonStringLiteral)jsonValue : null;
                        if (object == null || (object = object.getValue()) == null) {
                            return;
                        }
                        Object name2 = object;
                        Iterable $this$none$iv = GoogleServicesJsonSpellcheckingStrategy.Companion.getIGNORE_SUFFIX();
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (E element$iv : $this$none$iv) {
                                String it = (String)element$iv;
                                boolean bl2 = false;
                                if (!StringsKt.endsWith$default((String)name2, (String)it, (boolean)false, (int)2, null)) continue;
                                bl = false;
                                break block6;
                            }
                            bl = true;
                        }
                    }
                    if (bl) {
                        consumer.consumeToken((PsiElement)element2, (Splitter)PlainTextSplitter.getInstance());
                    }
                }
            };
        } else {
            Tokenizer tokenizer2 = SpellcheckingStrategy.EMPTY_TOKENIZER;
            tokenizer = tokenizer2;
            Intrinsics.checkNotNullExpressionValue((Object)tokenizer2, (String)"{\n      EMPTY_TOKENIZER\n    }");
        }
        return tokenizer;
    }

    public boolean isMyContext(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiFile psiFile = element2.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile file2 = psiFile;
        return StringsKt.equals((String)file2.getVirtualFile().getName(), (String)"google-services.json", (!file2.getVirtualFile().isCaseSensitive() ? 1 : 0) != 0);
    }

    static {
        Object[] objectArray = new String[]{"_url", "_bucket", "_id", "_hash", "_key"};
        IGNORE_SUFFIX = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/android/spellchecker/GoogleServicesJsonSpellcheckingStrategy$Companion;", "", "()V", "IGNORE_SUFFIX", "", "", "getIGNORE_SUFFIX", "()Ljava/util/List;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getIGNORE_SUFFIX() {
            return IGNORE_SUFFIX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

