/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.spellchecker;

import com.android.utils.SdkUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.spellchecker.GroovySpellcheckingStrategy;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class AndroidGradleSpellcheckingStrategy
extends GroovySpellcheckingStrategy {
    public boolean isMyContext(@NotNull PsiElement element2) {
        return AndroidGradleSpellcheckingStrategy.isInGradleFile(element2);
    }

    @NotNull
    public Tokenizer getTokenizer(PsiElement element2) {
        if (TokenSets.STRING_LITERAL_SET.contains(element2.getNode().getElementType()) && !AndroidGradleSpellcheckingStrategy.isPrint(element2)) {
            return EMPTY_TOKENIZER;
        }
        return super.getTokenizer(element2);
    }

    private static boolean isPrint(PsiElement element2) {
        GrReferenceExpression propertyRef;
        String property2;
        GrApplicationStatement call;
        GrExpression propertyExpression;
        PsiElement parent0 = element2.getParent();
        if (parent0 == null) {
            return false;
        }
        PsiElement parent1 = parent0.getParent();
        if (parent1 == null) {
            return false;
        }
        PsiElement parent2 = parent1.getParent();
        if (parent2 == null) {
            return false;
        }
        if (parent2 instanceof GrCommandArgumentList) {
            parent2 = parent2.getParent();
        }
        return parent2 instanceof GrApplicationStatement && (propertyExpression = (call = (GrApplicationStatement)parent2).getInvokedExpression()) instanceof GrReferenceExpression && ("print".equals(property2 = (propertyRef = (GrReferenceExpression)propertyExpression).getReferenceName()) || "println".equals(property2));
    }

    private static boolean isInGradleFile(PsiElement element2) {
        String name2;
        PsiFile file2 = element2.getContainingFile();
        return file2 != null && SdkUtils.endsWithIgnoreCase((String)(name2 = file2.getName()), (String)".gradle");
    }
}

