/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.util.StudioPathManager;
import com.android.tools.sdk.CompatibilityRenderTarget;
import com.android.tools.sdk.EmbeddedRenderTarget;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.sdk.StudioEmbeddedRenderTarget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/android/sdk/StudioEmbeddedRenderTarget;", "", "()V", "Companion", "intellij.android.core"})
public final class StudioEmbeddedRenderTarget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    private static boolean ourDisableEmbeddedTargetForTesting;

    @JvmStatic
    @VisibleForTesting
    public static final void setDisableEmbeddedTarget(boolean value2) {
        Companion.setDisableEmbeddedTarget(value2);
    }

    @JvmStatic
    @NotNull
    public static final CompatibilityRenderTarget getCompatibilityTarget(@NotNull IAndroidTarget target2) {
        return Companion.getCompatibilityTarget(target2);
    }

    @JvmStatic
    @Nullable
    public static final String getEmbeddedLayoutLibPath() {
        return Companion.getEmbeddedLayoutLibPath();
    }

    static {
        Logger logger2 = Logger.getInstance(StudioEmbeddedRenderTarget.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(StudioEmbedd\u2026RenderTarget::class.java)");
        LOG = logger2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/android/sdk/StudioEmbeddedRenderTarget$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "ourDisableEmbeddedTargetForTesting", "", "getCompatibilityTarget", "Lcom/android/tools/sdk/CompatibilityRenderTarget;", "target", "Lcom/android/sdklib/IAndroidTarget;", "getEmbeddedLayoutLibPath", "", "setDisableEmbeddedTarget", "", "value", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @VisibleForTesting
        public final void setDisableEmbeddedTarget(boolean value2) {
            boolean bl = ApplicationManager.getApplication().isUnitTestMode();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            ourDisableEmbeddedTargetForTesting = value2;
        }

        @JvmStatic
        @NotNull
        public final CompatibilityRenderTarget getCompatibilityTarget(@NotNull IAndroidTarget target2) {
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            if (ourDisableEmbeddedTargetForTesting) {
                return new CompatibilityRenderTarget(target2, target2.getVersion().getApiLevel(), target2);
            }
            CompatibilityRenderTarget compatibilityRenderTarget = EmbeddedRenderTarget.getCompatibilityTarget(target2, getCompatibilityTarget.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)compatibilityRenderTarget, (String)"getCompatibilityTarget(t\u2026EmbeddedLayoutLibPath() }");
            return compatibilityRenderTarget;
        }

        @JvmStatic
        @Nullable
        public final String getEmbeddedLayoutLibPath() {
            VirtualFile root;
            String string = FileUtil.toSystemIndependentName((String)PluginPathManager.getPluginHomePath((String)"design-tools"));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(\u2026HomePath(\"design-tools\"))");
            String homePath = string;
            String[] stringArray = new String[]{homePath, "/resources/layoutlib/"};
            String string2 = FileUtil.join((String[])stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(homePath, \"/resources/layoutlib/\")");
            String path2 = string2;
            if (StudioPathManager.isRunningFromSources()) {
                path2 = ((Object)StudioPathManager.resolvePathFromSourcesRoot((String)"prebuilts/studio/layoutlib/")).toString();
            }
            if ((root = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path2))) != null) {
                File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)root);
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"virtualToIoFile(root)");
                File rootFile = file2;
                if (rootFile.exists() && rootFile.isDirectory()) {
                    LOG.debug("Embedded layoutlib found at " + path2);
                    return rootFile.getAbsolutePath() + File.separator;
                }
            }
            LOG.error("Unable to find embedded layoutlib in path: " + path2);
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

