/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.sdk.AndroidPlatform;
import com.android.tools.sdk.AndroidSdkData;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkAdditionalData
implements SdkAdditionalData {
    @NonNls
    private static final String BUILD_TARGET = "sdk";
    private final Sdk myAndroidSdk;
    private String myBuildTarget;
    private AndroidPlatform myAndroidPlatform = null;

    public AndroidSdkAdditionalData(@NotNull Sdk androidSdk) {
        this.myAndroidSdk = androidSdk;
    }

    public AndroidSdkAdditionalData(@NotNull Sdk androidSdk, @NotNull Element element2) {
        this.myAndroidSdk = androidSdk;
        this.myBuildTarget = element2.getAttributeValue(BUILD_TARGET);
    }

    public void setBuildTargetHashString(String targetHashString) {
        this.myBuildTarget = targetHashString;
        this.myAndroidPlatform = null;
    }

    public void setBuildTarget(IAndroidTarget target2) {
        this.myBuildTarget = target2 != null ? target2.hashString() : null;
        this.myAndroidPlatform = null;
    }

    public void save(Element element2) {
        if (this.myBuildTarget != null) {
            element2.setAttribute(BUILD_TARGET, this.myBuildTarget);
        }
    }

    @Nullable
    public IAndroidTarget getBuildTarget(@NotNull AndroidSdkData sdkData) {
        return this.myBuildTarget != null ? sdkData.findTargetByHashString(this.myBuildTarget) : null;
    }

    @Nullable
    public String getBuildTargetHashString() {
        return this.myBuildTarget;
    }

    @Nullable
    private static AndroidPlatform parse(@NotNull Sdk sdk) {
        IAndroidTarget target2;
        SdkAdditionalData data;
        if (!AndroidSdks.getInstance().isAndroidSdk(sdk)) {
            return null;
        }
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
        if (sdkData != null && (data = sdk.getSdkAdditionalData()) instanceof AndroidSdkAdditionalData && (target2 = ((AndroidSdkAdditionalData)data).getBuildTarget(sdkData)) != null) {
            return new AndroidPlatform(sdkData, target2);
        }
        return null;
    }

    @Nullable
    public AndroidPlatform getAndroidPlatform() {
        if (this.myAndroidPlatform == null) {
            this.myAndroidPlatform = AndroidSdkAdditionalData.parse(this.myAndroidSdk);
        }
        return this.myAndroidPlatform;
    }

    @Nullable
    public static AndroidSdkAdditionalData from(@NotNull Sdk sdk) {
        SdkAdditionalData data = sdk.getSdkAdditionalData();
        return data instanceof AndroidSdkAdditionalData ? (AndroidSdkAdditionalData)data : null;
    }
}

