/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.tools.dom.attrs.AttributeDefinitions;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.sdk.AndroidPlatform;
import com.android.tools.sdk.AndroidTargetData;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.ConvertContext;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.sdk.AndroidPlatforms;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkResourceManager
extends ResourceManager {
    @NotNull
    private final Module myModule;

    public FrameworkResourceManager(@NotNull Module module2) {
        super(module2.getProject());
        this.myModule = module2;
    }

    @Nullable
    private VirtualFile getResourceDir() {
        AndroidPlatform platform = this.getPlatform();
        if (platform == null) {
            return null;
        }
        Path resPath = platform.getTarget().getPath(11);
        return LocalFileSystem.getInstance().findFileByNioFile(resPath);
    }

    @Override
    public boolean isResourceDir(@NotNull VirtualFile dir) {
        return dir.equals(this.getResourceDir());
    }

    @Nullable
    public static FrameworkResourceManager getInstance(@NotNull ConvertContext context2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((ConvertContext)context2);
        return facet2 != null ? ModuleResourceManagers.getInstance(facet2).getFrameworkResourceManager() : null;
    }

    @Override
    @Nullable
    public AttributeDefinitions getAttributeDefinitions() {
        AndroidPlatform platform = this.getPlatform();
        if (platform == null) {
            return null;
        }
        return AndroidTargetData.get(platform.getSdkData(), platform.getTarget()).getPublicAttrDefs();
    }

    @Override
    @NotNull
    protected Collection<SingleNamespaceResourceRepository> getLeafResourceRepositories() {
        ResourceRepository repository2 = this.getResourceRepository();
        return repository2 == null ? ImmutableList.of() : repository2.getLeafResourceRepositories();
    }

    @Nullable
    private ResourceRepository getResourceRepository() {
        StudioResourceRepositoryManager repositoryManager = StudioResourceRepositoryManager.getInstance(this.myModule);
        return repositoryManager == null ? null : repositoryManager.getFrameworkResources((Set<String>)ImmutableSet.of());
    }

    @Nullable
    private AndroidPlatform getPlatform() {
        return AndroidPlatforms.getInstance(this.myModule);
    }
}

