/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.resources.ResourceFolderType;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.wrappers.ResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.AndroidInlineTestConfig;
import org.jetbrains.android.refactoring.AndroidInlineUtil;
import org.jetbrains.android.refactoring.LayoutUsageData;
import org.jetbrains.android.refactoring.errorreporter.ErrorReporter;
import org.jetbrains.android.refactoring.errorreporter.HintBasedErrorReporter;
import org.jetbrains.android.refactoring.errorreporter.ProjectBasedErrorReporter;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class AndroidInlineLayoutHandler
extends InlineActionHandler {
    private static AndroidInlineTestConfig ourTestConfig;

    @TestOnly
    public static void setTestConfig(@Nullable AndroidInlineTestConfig testConfig) {
        ourTestConfig = testConfig;
    }

    public boolean isEnabledForLanguage(Language l) {
        return l == XMLLanguage.INSTANCE;
    }

    public boolean isEnabledOnElement(PsiElement element2, @Nullable Editor editor) {
        return this.canInlineElementInEditor(element2, editor);
    }

    public boolean canInlineElement(PsiElement element2) {
        if (element2 instanceof ResourceElementWrapper) {
            element2 = ((ResourceElementWrapper)element2).getWrappedElement();
        }
        if (element2 instanceof XmlFile) {
            if (AndroidFacet.getInstance((PsiElement)element2) == null || ((XmlFile)element2).getRootTag() == null) {
                return false;
            }
            return AndroidResourceDomFileDescription.isFileInResourceFolderType((XmlFile)element2, ResourceFolderType.LAYOUT);
        }
        return false;
    }

    public boolean canInlineElementInEditor(PsiElement element2, Editor editor) {
        return this.canInlineElement(element2) || AndroidInlineLayoutHandler.getLayoutUsageDataFromContext(editor) != null;
    }

    @Nullable
    private static LayoutUsageData getLayoutUsageDataFromContext(Editor editor) {
        if (editor == null) {
            return null;
        }
        PsiElement element2 = PsiUtilBase.getElementAtCaret((Editor)editor);
        if (!(element2 instanceof XmlToken) || AndroidFacet.getInstance((PsiElement)element2) == null) {
            return null;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlTag.class);
        return tag != null ? AndroidInlineUtil.getLayoutUsageData(tag) : null;
    }

    public void inlineElement(Project project, Editor editor, PsiElement element2) {
        if (element2 instanceof ResourceElementWrapper) {
            element2 = ((ResourceElementWrapper)element2).getWrappedElement();
        }
        if (element2 instanceof XmlFile) {
            PsiReference reference;
            PsiElement usageElement = null;
            if (editor != null && (reference = TargetElementUtil.findReference((Editor)editor)) != null) {
                usageElement = reference.getElement();
            }
            AndroidInlineUtil.doInlineLayoutFile(project, (XmlFile)element2, usageElement, ourTestConfig);
            return;
        }
        LayoutUsageData usageData = AndroidInlineLayoutHandler.getLayoutUsageDataFromContext(editor);
        assert (usageData != null);
        AndroidResourceReferenceBase ref = usageData.getReference();
        PsiElement[] elements = ref.computeTargetElements();
        ErrorReporter errorReporter = editor != null ? new HintBasedErrorReporter(editor) : new ProjectBasedErrorReporter(project);
        String title = AndroidBundle.message("android.inline.layout.title", new Object[0]);
        if (elements.length == 0) {
            String resName = ref.getResourceValue().getResourceName();
            Object message2 = resName != null ? "Cannot find layout '" + resName + "'" : "Error: cannot find the layout";
            errorReporter.report((String)message2, title);
            return;
        }
        if (elements.length > 1) {
            errorReporter.report("Error: unambiguous reference", title);
            return;
        }
        PsiElement resolvedElement = elements[0];
        if (!(resolvedElement instanceof XmlFile)) {
            errorReporter.report("Cannot inline reference '" + ref.getValue() + "'", title);
            return;
        }
        AndroidInlineUtil.doInlineLayoutFile(project, (XmlFile)resolvedElement, ref.getElement(), ourTestConfig);
    }

    @Nullable
    public String getActionName(PsiElement element2) {
        return "Inline Android Layout";
    }
}

