/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.dom.resources.StyleItem;
import org.jetbrains.android.refactoring.AndroidBaseLayoutRefactoringAction;
import org.jetbrains.android.refactoring.AndroidFindStyleApplicationsAction;
import org.jetbrains.android.refactoring.ExtractStyleDialog;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class AndroidExtractStyleAction
extends AndroidBaseLayoutRefactoringAction {
    @NonNls
    public static final String ACTION_ID = "AndroidExtractStyleAction";
    private static String[] NON_EXTRACTABLE_ATTRIBUTES = new String[]{"id", "text", "hint", "src", "onClick"};
    private final MyTestConfig myTestConfig;

    public AndroidExtractStyleAction() {
        this.myTestConfig = null;
    }

    @TestOnly
    public AndroidExtractStyleAction(@NotNull MyTestConfig testConfig) {
        this.myTestConfig = testConfig;
    }

    @Override
    protected boolean isEnabledForTags(@NotNull XmlTag[] tags) {
        return tags.length == 1 && AndroidExtractStyleAction.doIsEnabled(tags[0]);
    }

    public static boolean doIsEnabled(@NotNull XmlTag tag) {
        return AndroidExtractStyleAction.getLayoutViewElement(tag) != null && !AndroidExtractStyleAction.getExtractableAttributes(tag).isEmpty();
    }

    @Nullable
    public static String doExtractStyle(@NotNull Module module2, final @NotNull XmlTag viewTag, final boolean addStyleAttributeToTag, @Nullable MyTestConfig testConfig) {
        AndroidFindStyleApplicationsAction.MyStyleData createdStyleData;
        XmlTag createdStyleTag;
        String styleName;
        List<Object> styledAttributes;
        VirtualFile chosenDirectory;
        boolean searchStyleApplications;
        String parentStyle;
        final PsiFile file2 = viewTag.getContainingFile();
        if (file2 == null) {
            return null;
        }
        String dialogTitle = AndroidBundle.message("android.extract.style.title", new Object[0]);
        String fileName = IdeResourcesUtil.getDefaultResourceFileName(ResourceType.STYLE);
        assert (fileName != null);
        List<String> dirNames = Collections.singletonList(ResourceFolderType.VALUES.getName());
        List<XmlAttribute> extractableAttributes = AndroidExtractStyleAction.getExtractableAttributes(viewTag);
        Project project = module2.getProject();
        if (extractableAttributes.isEmpty()) {
            AndroidUtils.reportError(project, "The tag doesn't contain any attributes that can be extracted", dialogTitle);
            return null;
        }
        LayoutViewElement viewElement = AndroidExtractStyleAction.getLayoutViewElement(viewTag);
        assert (viewElement != null);
        final ResourceValue parentStyleValue = (ResourceValue)viewElement.getStyle().getValue();
        boolean supportImplicitParent = false;
        if (parentStyleValue != null) {
            parentStyle = parentStyleValue.getResourceName();
            if (ResourceType.STYLE != parentStyleValue.getType() || parentStyle == null || parentStyle.isEmpty()) {
                AndroidUtils.reportError(project, "Invalid parent style reference " + parentStyleValue.toString(), dialogTitle);
                return null;
            }
            supportImplicitParent = parentStyleValue.getPackage() == null;
        } else {
            parentStyle = null;
        }
        if (testConfig == null) {
            ExtractStyleDialog dialog2 = new ExtractStyleDialog(module2, fileName, supportImplicitParent ? parentStyle : null, dirNames, extractableAttributes);
            dialog2.setTitle(dialogTitle);
            if (!dialog2.showAndGet()) {
                return null;
            }
            searchStyleApplications = dialog2.isToSearchStyleApplications();
            chosenDirectory = dialog2.getResourceDirectory();
            if (chosenDirectory == null) {
                AndroidUtils.reportError(project, AndroidBundle.message("check.resource.dir.error", module2.getName()));
                return null;
            }
            styledAttributes = dialog2.getStyledAttributes();
            styleName = dialog2.getStyleName();
        } else {
            testConfig.validate(extractableAttributes);
            chosenDirectory = testConfig.getResourceDirectory();
            styleName = testConfig.getStyleName();
            HashSet<String> attrsToExtract = new HashSet<String>(Arrays.asList(testConfig.getAttributesToExtract()));
            styledAttributes = new ArrayList();
            for (XmlAttribute attribute2 : extractableAttributes) {
                if (!attrsToExtract.contains(attribute2.getName())) continue;
                styledAttributes.add(attribute2);
            }
            searchStyleApplications = false;
        }
        boolean[] success2 = new boolean[]{false};
        final Ref createdStyleRef = Ref.create();
        final boolean finalSupportImplicitParent = supportImplicitParent;
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file2}).withName("Extract Android Style '" + styleName + "'").withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).run(() -> {
            final ArrayList attributesToDelete = new ArrayList();
            if (!IdeResourcesUtil.createValueResource(project, chosenDirectory, styleName, null, ResourceType.STYLE, fileName, dirNames, new Processor<ResourceElement>(){

                public boolean process(ResourceElement element2) {
                    assert (element2 instanceof Style);
                    Style style = (Style)element2;
                    createdStyleRef.set((Object)style);
                    for (XmlAttribute attribute2 : styledAttributes) {
                        if (!"http://schemas.android.com/apk/res/android".equals(attribute2.getNamespace())) continue;
                        StyleItem item2 = style.addItem();
                        item2.getName().setStringValue("android:" + attribute2.getLocalName());
                        item2.setStringValue(attribute2.getValue());
                        attributesToDelete.add(attribute2);
                    }
                    if (!(parentStyleValue == null || finalSupportImplicitParent && styleName.startsWith(parentStyle + "."))) {
                        String aPackage = parentStyleValue.getPackage();
                        style.getParentStyle().setStringValue((String)(aPackage != null ? aPackage + ":" : "") + parentStyle);
                    }
                    return true;
                }
            })) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    for (XmlAttribute attribute2 : attributesToDelete) {
                        attribute2.delete();
                    }
                    if (addStyleAttributeToTag) {
                        LayoutViewElement viewElement = AndroidBaseLayoutRefactoringAction.getLayoutViewElement(viewTag);
                        assert (viewElement != null);
                        viewElement.getStyle().setStringValue("@style/" + styleName);
                    }
                }
            });
            success2[0] = true;
        });
        if (!success2[0]) {
            return null;
        }
        Style createdStyle = (Style)createdStyleRef.get();
        XmlTag xmlTag = createdStyleTag = createdStyle != null ? createdStyle.getXmlTag() : null;
        if (createdStyleTag != null && (createdStyleData = AndroidFindStyleApplicationsAction.getStyleData(createdStyleTag)) != null && searchStyleApplications) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    AndroidFindStyleApplicationsAction.doRefactoringForTag(createdStyleTag, createdStyleData, file2, null);
                }
            });
        }
        return styleName;
    }

    @NotNull
    static List<XmlAttribute> getExtractableAttributes(@NotNull XmlTag viewTag) {
        ArrayList<XmlAttribute> extractableAttributes = new ArrayList<XmlAttribute>();
        for (XmlAttribute attribute2 : viewTag.getAttributes()) {
            if (!AndroidExtractStyleAction.canBeExtracted(attribute2)) continue;
            extractableAttributes.add(attribute2);
        }
        return extractableAttributes;
    }

    private static boolean canBeExtracted(@NotNull XmlAttribute attribute2) {
        if (!"http://schemas.android.com/apk/res/android".equals(attribute2.getNamespace())) {
            return false;
        }
        String name2 = attribute2.getLocalName();
        if (ArrayUtilRt.find((Object[])NON_EXTRACTABLE_ATTRIBUTES, (Object)name2) >= 0) {
            return false;
        }
        return !name2.startsWith("style");
    }

    @Override
    protected void doRefactorForTags(@NotNull Project project, @NotNull XmlTag[] tags) {
        assert (tags.length == 1);
        XmlTag tag = tags[0];
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)tag);
        assert (module2 != null);
        AndroidExtractStyleAction.doExtractStyle(module2, tag, true, this.myTestConfig);
    }

    static class MyTestConfig {
        private final String myStyleName;
        private final String[] myAttributesToExtract;
        private VirtualFile myResourceDirectory;

        MyTestConfig(@NotNull VirtualFile resourceDirectory, @NotNull String styleName, @NotNull String[] attributesToExtract) {
            this.myResourceDirectory = resourceDirectory;
            this.myStyleName = styleName;
            this.myAttributesToExtract = attributesToExtract;
        }

        @NotNull
        public String getStyleName() {
            return this.myStyleName;
        }

        @NotNull
        public String[] getAttributesToExtract() {
            return this.myAttributesToExtract;
        }

        public void validate(@NotNull List<XmlAttribute> extractableAttributes) {
        }

        public VirtualFile getResourceDirectory() {
            return this.myResourceDirectory;
        }
    }
}

