/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.resources.ResourceFolderType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.refactoring.AndroidBaseXmlRefactoringAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidBaseLayoutRefactoringAction
extends AndroidBaseXmlRefactoringAction {
    @Override
    protected boolean isEnabledForTags(@NotNull XmlTag[] tags) {
        for (XmlTag tag : tags) {
            if (AndroidBaseLayoutRefactoringAction.getLayoutViewElement(tag) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isMyFile(PsiFile file2) {
        return file2 instanceof XmlFile && AndroidResourceDomFileDescription.isFileInResourceFolderType((XmlFile)file2, ResourceFolderType.LAYOUT);
    }

    @Nullable
    public static LayoutViewElement getLayoutViewElement(@NotNull XmlTag tag) {
        DomElement domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
        return domElement instanceof LayoutViewElement ? (LayoutViewElement)domElement : null;
    }
}

