/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.newProject;

import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AndroidProjectStructureDetector
extends ProjectStructureDetector {
    @NotNull
    public ProjectStructureDetector.DirectoryProcessingResult detectRoots(@NotNull File dir, @NotNull File[] children2, @NotNull File base, @NotNull List<DetectedProjectRoot> result2) {
        for (File child : children2) {
            if (!child.isFile() || !"AndroidManifest.xml".equals(child.getName())) continue;
            result2.add(new AndroidProjectRoot(dir));
            return ProjectStructureDetector.DirectoryProcessingResult.SKIP_CHILDREN;
        }
        return ProjectStructureDetector.DirectoryProcessingResult.PROCESS_CHILDREN;
    }

    public void setupProjectStructure(@NotNull Collection<DetectedProjectRoot> roots, @NotNull ProjectDescriptor projectDescriptor, @NotNull ProjectFromSourcesBuilder builder2) {
        ArrayList<File> existingRoots = new ArrayList<File>();
        for (ProjectStructureDetector detector : (ProjectStructureDetector[])ProjectStructureDetector.EP_NAME.getExtensions()) {
            if (detector == this) continue;
            for (DetectedProjectRoot root : builder2.getProjectRoots(detector)) {
                existingRoots.add(root.getDirectory());
            }
        }
        ArrayList<ModuleDescriptor> modules = new ArrayList<ModuleDescriptor>();
        for (DetectedProjectRoot root : roots) {
            File dir = root.getDirectory();
            boolean javaSrcRootInside = false;
            for (File javaSourceRoot : existingRoots) {
                if (!FileUtil.isAncestor((File)dir, (File)javaSourceRoot, (boolean)false)) continue;
                javaSrcRootInside = true;
            }
            if (javaSrcRootInside) continue;
            modules.add(new ModuleDescriptor(root.getDirectory(), JavaModuleType.getModuleType(), Collections.emptyList()));
        }
        projectDescriptor.setModules(modules);
    }

    private static class AndroidProjectRoot
    extends DetectedProjectRoot {
        public AndroidProjectRoot(@NotNull File directory) {
            super(directory);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getRootTypeName() {
            return AndroidBundle.message("group.Internal.Android.text", new Object[0]);
        }
    }
}

