/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import java.util.HashSet;
import javax.swing.JList;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class AndroidAddLibraryDependencyAction
extends AbstractIntentionAction
implements HighPriorityAction {
    @NotNull
    public String getText() {
        return AndroidBundle.message("add.dependency.intention.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Nullable
    private static GradleBuildModel getGradleBuildModel(@NotNull Project project, @NotNull PsiFile file2) {
        ProjectFileIndex index2 = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module2 = index2.getModuleForFile(file2.getVirtualFile());
        if (module2 == null) {
            return null;
        }
        return GradleBuildModel.get(module2);
    }

    @NotNull
    private static ImmutableCollection<String> findAllDependencies(@NotNull GradleBuildModel buildModel) {
        HashSet existingDependencies = Sets.newHashSet();
        for (ArtifactDependencyModel dependency : buildModel.dependencies().artifacts()) {
            existingDependencies.add(dependency.group().toString() + ":" + dependency.name().toString());
        }
        ImmutableList.Builder dependenciesBuilder = ImmutableList.builder();
        RepositoryUrlManager repositoryUrlManager2 = RepositoryUrlManager.get();
        for (GoogleMavenArtifactId id2 : GoogleMavenArtifactId.values()) {
            GradleCoordinate resolvedCoordinate;
            GradleCoordinate coordinate = id2.getCoordinate("+");
            if (existingDependencies.contains(coordinate.getId()) || (resolvedCoordinate = repositoryUrlManager2.resolveDynamicCoordinate(coordinate, buildModel.getProject(), null)) == null) continue;
            dependenciesBuilder.add((Object)resolvedCoordinate.toString());
        }
        return dependenciesBuilder.build();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if ((file2 instanceof GroovyFile || file2 instanceof KtFile) && (file2.getName().endsWith("gradle") || file2.getName().endsWith("gradle.kts"))) {
            return AndroidFacet.getInstance((PsiElement)file2) != null;
        }
        return false;
    }

    private static void addDependency(@NotNull Project project, final @NotNull GradleBuildModel buildModel, @NotNull String coordinateString) {
        GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)coordinateString);
        if (coordinate == null || coordinate.getArtifactId() == null) {
            return;
        }
        final ArtifactDependencySpec newDependency = ArtifactDependencySpec.create(coordinate.getArtifactId(), coordinate.getGroupId(), coordinate.getRevision());
        WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

            @Override
            public void run() {
                buildModel.dependencies().addArtifact("implementation", newDependency);
                buildModel.applyChanges();
            }
        });
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        GradleBuildModel buildModel = AndroidAddLibraryDependencyAction.getGradleBuildModel(project, file2);
        if (buildModel == null) {
            return;
        }
        ImmutableCollection<String> dependencies2 = AndroidAddLibraryDependencyAction.findAllDependencies(buildModel);
        if (dependencies2.isEmpty()) {
            return;
        }
        JBList list2 = new JBList(dependencies2);
        JBPopup popup2 = new PopupChooserBuilder((JList)list2).setItemChoosenCallback(new Runnable(){
            final /* synthetic */ JList val$list;
            final /* synthetic */ Project val$project;
            final /* synthetic */ GradleBuildModel val$buildModel;
            {
                this.val$list = jList;
                this.val$project = project;
                this.val$buildModel = gradleBuildModel;
            }

            @Override
            public void run() {
                for (Object selectedValue : this.val$list.getSelectedValues()) {
                    if (selectedValue == null) {
                        return;
                    }
                    AndroidAddLibraryDependencyAction.addDependency(this.val$project, this.val$buildModel, (String)selectedValue);
                }
            }
        }).createPopup();
        popup2.showInBestPositionFor(editor);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

