/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.Receiver;
import org.jetbrains.android.intentions.AbstractRegisterComponentAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AddBroadcastReceiverToManifest
extends AbstractRegisterComponentAction {
    @Nls
    @NotNull
    public String getText() {
        return "Add broadcast receiver to manifest";
    }

    @Override
    boolean isAvailable(@NotNull PsiClass psiClass, @NotNull Manifest manifest) {
        if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (boolean)true, (String)"android.content.BroadcastReceiver")) {
            return false;
        }
        return !AddBroadcastReceiverToManifest.isRegisteredBroadcastReceiver(psiClass, manifest.getApplication());
    }

    @Override
    void invoke(@NotNull PsiClass psiClass, @NotNull Manifest manifest) {
        Application application = manifest.getApplication();
        application.addReceiver().getReceiverClass().setValue(psiClass);
    }

    private static boolean isRegisteredBroadcastReceiver(PsiClass psiClass, Application application) {
        for (Receiver receiver2 : application.getReceivers()) {
            if (!psiClass.isEquivalentTo((PsiElement)receiver2.getReceiverClass().getValue())) continue;
            return true;
        }
        return false;
    }
}

