/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.sdklib.SdkVersionInfo;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;

public class VersionChecks {
    public static boolean isPrecededByVersionCheckExit(PsiElement element2, int api) {
        PsiStatement prev;
        Object current = PsiTreeUtil.getParentOfType((PsiElement)element2, PsiStatement.class);
        if (current != null) {
            prev = VersionChecks.getPreviousStatement(current);
            current = prev == null ? PsiTreeUtil.getParentOfType((PsiElement)current, PsiStatement.class, (boolean)true, (Class[])new Class[]{PsiMethod.class, PsiClass.class}) : prev;
        }
        while (current != null) {
            if (current instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)current;
                PsiStatement thenBranch = ifStatement.getThenBranch();
                PsiStatement elseBranch = ifStatement.getElseBranch();
                PsiExpression condition = ifStatement.getCondition();
                if (condition != null) {
                    Boolean ok;
                    if (thenBranch != null && (ok = VersionChecks.isVersionCheckConditional(api, (PsiElement)condition, true, (PsiElement)thenBranch, null)) != null && VersionChecks.isUnconditionalReturn(thenBranch)) {
                        return true;
                    }
                    if (elseBranch != null && (ok = VersionChecks.isVersionCheckConditional(api, (PsiElement)condition, false, (PsiElement)elseBranch, null)) != null && VersionChecks.isUnconditionalReturn(elseBranch)) {
                        return true;
                    }
                }
            }
            if ((prev = VersionChecks.getPreviousStatement(current)) == null) {
                if ((current = PsiTreeUtil.getParentOfType((PsiElement)current, PsiStatement.class, (boolean)true, (Class[])new Class[]{PsiMethod.class, PsiClass.class})) != null) continue;
                return false;
            }
            current = prev;
        }
        return false;
    }

    private static boolean isUnconditionalReturn(PsiStatement statement) {
        PsiBlockStatement blockStatement;
        PsiCodeBlock block;
        PsiStatement[] statements;
        if (statement instanceof PsiBlockStatement && (statements = (block = (blockStatement = (PsiBlockStatement)statement).getCodeBlock()).getStatements()).length == 1 && statements[0] instanceof PsiReturnStatement) {
            return true;
        }
        return statement instanceof PsiReturnStatement;
    }

    public static PsiStatement getPreviousStatement(PsiElement element2) {
        PsiElement prevStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)element2, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
        return prevStatement instanceof PsiStatement ? (PsiStatement)prevStatement : null;
    }

    public static boolean isWithinVersionCheckConditional(PsiElement element2, int api) {
        PsiElement current = PsiUtil.skipParenthesizedExprUp((PsiElement)element2.getParent());
        PsiElement prev = element2;
        while (current != null) {
            if (current instanceof PsiIfStatement) {
                ifStatement = (PsiIfStatement)current;
                condition = ifStatement.getCondition();
                if (prev != condition && condition != null && (ok = VersionChecks.isVersionCheckConditional(api, (PsiElement)condition, fromThen = prev == ifStatement.getThenBranch(), prev, null)) != null) {
                    return ok;
                }
            } else if (current instanceof PsiConditionalExpression) {
                ifStatement = (PsiConditionalExpression)current;
                condition = ifStatement.getCondition();
                if (prev != condition && (ok = VersionChecks.isVersionCheckConditional(api, (PsiElement)condition, fromThen = prev == ifStatement.getThenExpression(), prev, null)) != null) {
                    return ok;
                }
            } else {
                if (current instanceof PsiPolyadicExpression && (VersionChecks.isAndedWithConditional(current, api, prev) || VersionChecks.isOredWithConditional(current, api, prev))) {
                    return true;
                }
                if (current instanceof PsiMethod || current instanceof PsiFile) {
                    return false;
                }
            }
            prev = current;
            current = PsiUtil.skipParenthesizedExprUp((PsiElement)current.getParent());
        }
        return false;
    }

    private static Boolean isVersionCheckConditional(int api, PsiElement element2, boolean and, PsiElement prev, ApiLevelLookup apiLookup) {
        Boolean ok;
        PsiExpression operand;
        PsiPrefixExpression prefixExpression;
        if (element2 instanceof PsiPolyadicExpression) {
            Boolean ok2;
            if (element2 instanceof PsiBinaryExpression && (ok2 = VersionChecks.isVersionCheckConditional(api, and, (PsiBinaryExpression)element2, apiLookup)) != null) {
                return ok2;
            }
            PsiPolyadicExpression expression2 = (PsiPolyadicExpression)element2;
            IElementType tokenType = expression2.getOperationTokenType();
            if (and && tokenType == JavaTokenType.ANDAND ? VersionChecks.isAndedWithConditional(element2, api, prev) : !and && tokenType == JavaTokenType.OROR && VersionChecks.isOredWithConditional(element2, api, prev)) {
                return true;
            }
        } else if (element2 instanceof PsiMethodCallExpression) {
            ApiLevelLookup lookup;
            Boolean ok3;
            Boolean ok4;
            PsiCodeBlock body;
            PsiClass containingClass;
            PsiMethodCallExpression call = (PsiMethodCallExpression)element2;
            PsiMethod method2 = call.resolveMethod();
            if (method2 == null) {
                return null;
            }
            String name2 = method2.getName();
            if (name2.startsWith("isAtLeast") && (containingClass = method2.getContainingClass()) != null && "android.support.v4.os.BuildCompat".equals(containingClass.getQualifiedName())) {
                if (name2.equals("isAtLeastN")) {
                    return api <= 24;
                }
                if (name2.equals("isAtLeastNMR1")) {
                    return api <= 25;
                }
            }
            if ((body = method2.getBody()) == null) {
                return null;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length != 1) {
                return null;
            }
            PsiStatement statement = statements[0];
            if (!(statement instanceof PsiReturnStatement)) {
                return null;
            }
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (returnValue == null) {
                return null;
            }
            PsiExpression[] expressions = call.getArgumentList().getExpressions();
            if (expressions.length == 0 && (ok4 = VersionChecks.isVersionCheckConditional(api, (PsiElement)returnValue, and, null, null)) != null) {
                return ok4;
            }
            if (expressions.length == 1 && (ok3 = VersionChecks.isVersionCheckConditional(api, (PsiElement)returnValue, and, null, lookup = arg -> {
                PsiElement resolved;
                if (arg instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)arg).resolve()) instanceof PsiParameter) {
                    int index2;
                    PsiParameter parameter = (PsiParameter)resolved;
                    PsiParameterList parameterList = (PsiParameterList)PsiTreeUtil.getParentOfType((PsiElement)resolved, PsiParameterList.class);
                    if (parameterList != null && (index2 = parameterList.getParameterIndex(parameter)) != -1 && index2 < expressions.length) {
                        return VersionChecks.getApiLevel(expressions[index2], null);
                    }
                }
                return -1;
            })) != null) {
                return ok3;
            }
        } else if (element2 instanceof PsiReferenceExpression) {
            Boolean ok5;
            PsiExpression initializer2;
            PsiField field2;
            PsiModifierList modifierList;
            PsiReferenceExpression refExpression = (PsiReferenceExpression)element2;
            PsiElement resolved = refExpression.resolve();
            if (resolved instanceof PsiField && (modifierList = (field2 = (PsiField)resolved).getModifierList()) != null && modifierList.hasExplicitModifier("static") && (initializer2 = field2.getInitializer()) != null && (ok5 = VersionChecks.isVersionCheckConditional(api, (PsiElement)initializer2, and, null, null)) != null) {
                return ok5;
            }
        } else if (element2 instanceof PsiPrefixExpression && (prefixExpression = (PsiPrefixExpression)element2).getOperationTokenType() == JavaTokenType.EXCL && (operand = prefixExpression.getOperand()) != null && (ok = VersionChecks.isVersionCheckConditional(api, (PsiElement)operand, !and, null, null)) != null) {
            return ok;
        }
        return null;
    }

    private static boolean isSdkInt(PsiElement element2) {
        PsiMethodCallExpression callExpression;
        if (element2 instanceof PsiReferenceExpression) {
            PsiExpression initializer2;
            PsiReferenceExpression ref = (PsiReferenceExpression)element2;
            if ("SDK_INT".equals(ref.getReferenceName())) {
                return true;
            }
            PsiElement resolved = ref.resolve();
            if (resolved instanceof PsiVariable && (initializer2 = ((PsiVariable)resolved).getInitializer()) != null) {
                return VersionChecks.isSdkInt((PsiElement)initializer2);
            }
        } else if (element2 instanceof PsiMethodCallExpression && "getBuildSdkInt".equals((callExpression = (PsiMethodCallExpression)element2).getMethodExpression().getReferenceName())) {
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Boolean isVersionCheckConditional(int api, boolean fromThen, PsiBinaryExpression binary, ApiLevelLookup apiLevelLookup) {
        int level;
        IElementType tokenType = binary.getOperationTokenType();
        if (tokenType != JavaTokenType.GT && tokenType != JavaTokenType.GE && tokenType != JavaTokenType.LE && tokenType != JavaTokenType.LT && tokenType != JavaTokenType.EQEQ) return null;
        PsiExpression left2 = binary.getLOperand();
        if (!VersionChecks.isSdkInt((PsiElement)left2)) {
            PsiExpression right = binary.getROperand();
            if (right == null || !VersionChecks.isSdkInt((PsiElement)right)) return null;
            fromThen = !fromThen;
            level = VersionChecks.getApiLevel(left2, apiLevelLookup);
        } else {
            PsiExpression right = binary.getROperand();
            level = VersionChecks.getApiLevel(right, apiLevelLookup);
        }
        if (level == -1) return null;
        if (tokenType == JavaTokenType.GE) {
            return level >= api && fromThen;
        }
        if (tokenType == JavaTokenType.GT) {
            return level >= api - 1 && fromThen;
        }
        if (tokenType == JavaTokenType.LE) {
            return level >= api - 1 && !fromThen;
        }
        if (tokenType == JavaTokenType.LT) {
            return level >= api && !fromThen;
        }
        if (tokenType == JavaTokenType.EQEQ) {
            return level >= api && fromThen;
        }
        assert (false) : tokenType;
        return null;
    }

    private static int getApiLevel(PsiExpression element2, ApiLevelLookup apiLevelLookup) {
        PsiLiteralExpression lit;
        Object value2;
        int level = -1;
        if (element2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression ref2 = (PsiReferenceExpression)element2;
            String codeName = ref2.getReferenceName();
            if (codeName != null) {
                level = SdkVersionInfo.getApiByBuildCode((String)codeName, (boolean)false);
            }
        } else if (element2 instanceof PsiLiteralExpression && (value2 = (lit = (PsiLiteralExpression)element2).getValue()) instanceof Integer) {
            level = (Integer)value2;
        }
        if (level == -1 && apiLevelLookup != null && element2 != null) {
            level = apiLevelLookup.getApiLevel((PsiElement)element2);
        }
        return level;
    }

    private static boolean isOredWithConditional(PsiElement element2, int api, PsiElement before) {
        PsiPolyadicExpression ppe;
        if (element2 instanceof PsiBinaryExpression) {
            Boolean value2;
            PsiExpression left2;
            PsiBinaryExpression inner = (PsiBinaryExpression)element2;
            if (inner.getOperationTokenType() == JavaTokenType.OROR && before != (left2 = inner.getLOperand())) {
                Boolean ok = VersionChecks.isVersionCheckConditional(api, (PsiElement)left2, false, null, null);
                if (ok != null) {
                    return ok;
                }
                PsiExpression right = inner.getROperand();
                if (right != null && (ok = VersionChecks.isVersionCheckConditional(api, (PsiElement)right, false, null, null)) != null) {
                    return ok;
                }
            }
            return (value2 = VersionChecks.isVersionCheckConditional(api, false, inner, null)) != null && value2 != false;
        }
        if (element2 instanceof PsiPolyadicExpression && (ppe = (PsiPolyadicExpression)element2).getOperationTokenType() == JavaTokenType.OROR) {
            for (PsiExpression operand : ppe.getOperands()) {
                if (operand == before) break;
                if (!VersionChecks.isOredWithConditional((PsiElement)operand, api, before)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isAndedWithConditional(PsiElement element2, int api, PsiElement before) {
        PsiPolyadicExpression ppe;
        if (element2 instanceof PsiBinaryExpression) {
            Boolean value2;
            PsiExpression left2;
            PsiBinaryExpression inner = (PsiBinaryExpression)element2;
            if (inner.getOperationTokenType() == JavaTokenType.ANDAND && before != (left2 = inner.getLOperand())) {
                Boolean ok = VersionChecks.isVersionCheckConditional(api, (PsiElement)left2, true, null, null);
                if (ok != null) {
                    return ok;
                }
                PsiExpression right = inner.getROperand();
                if (right != null && (ok = VersionChecks.isVersionCheckConditional(api, (PsiElement)right, true, null, null)) != null) {
                    return ok;
                }
            }
            return (value2 = VersionChecks.isVersionCheckConditional(api, true, inner, null)) != null && value2 != false;
        }
        if (element2 instanceof PsiPolyadicExpression && (ppe = (PsiPolyadicExpression)element2).getOperationTokenType() == JavaTokenType.ANDAND) {
            for (PsiExpression operand : ppe.getOperands()) {
                if (operand == before) break;
                if (!VersionChecks.isAndedWithConditional((PsiElement)operand, api, before)) continue;
                return true;
            }
        }
        return false;
    }

    private static interface ApiLevelLookup {
        public int getApiLevel(PsiElement var1);
    }
}

