/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.AndroidXConstants;
import com.android.resources.ResourceType;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.codeInspection.magicConstant.MagicCompletionContributor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.TypeConversionUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;

public class ResourceTypeCompletionContributor
extends CompletionContributor {
    private static final int PRIORITY = 100;

    public void fillCompletionVariants(final @NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        PsiElement pos = parameters2.getPosition();
        if (JavaKeywordCompletion.AFTER_DOT.accepts((Object)pos)) {
            return;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)pos);
        if (facet2 == null) {
            return;
        }
        Constraints allowedValues = ResourceTypeCompletionContributor.getAllowedValues(pos);
        if (allowedValues == null) {
            return;
        }
        THashSet allowed = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<PsiElement>(){

            public int computeHashCode(PsiElement object) {
                return 0;
            }

            public boolean equals(PsiElement o1, PsiElement o2) {
                return parameters2.getOriginalFile().getManager().areElementsEquivalent(o1, o2);
            }
        });
        if (allowedValues instanceof ResourceTypeAllowedValues) {
            for (ResourceType resourceType : ((ResourceTypeAllowedValues)allowedValues).types) {
                if (resourceType.isSynthetic()) continue;
                PsiElementFactory factory2 = JavaPsiFacade.getElementFactory((Project)pos.getProject());
                String code = "R." + resourceType.getName();
                String fqcn = ProjectSystemUtil.getModuleSystem(facet2).getPackageName();
                String qualifiedCode = fqcn + "." + code;
                Project project = facet2.getModule().getProject();
                PsiClass cls = JavaPsiFacade.getInstance((Project)project).findClass(qualifiedCode, GlobalSearchScope.allScope((Project)project));
                if (cls != null) {
                    result2.addElement((LookupElement)new JavaPsiClassReferenceElement(cls));
                    continue;
                }
                PsiExpression type = factory2.createExpressionFromText(code, pos);
                result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)type, (String)code), (double)99.0));
                allowed.add(type);
            }
        } else if (allowedValues instanceof AllowedValues) {
            AllowedValues a = (AllowedValues)allowedValues;
            if (a.canBeOred) {
                PsiElementFactory factory3 = JavaPsiFacade.getElementFactory((Project)pos.getProject());
                PsiExpression zero = factory3.createExpressionFromText("0", pos);
                result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)zero, (String)"0"), (double)99.0));
                PsiExpression minusOne = factory3.createExpressionFromText("-1", pos);
                result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)minusOne, (String)"-1"), (double)99.0));
                allowed.add(zero);
                allowed.add(minusOne);
            }
            List<ExpectedTypeInfo> types2 = Arrays.asList(JavaSmartCompletionContributor.getExpectedTypes((CompletionParameters)parameters2));
            for (PsiAnnotationMemberValue value2 : a.values) {
                PsiNamedElement namedElement = ResourceTypeCompletionContributor.getNamedElementFromAnnotationMember(value2);
                if (namedElement != null) {
                    LookupElement lookupElement = LookupItemUtil.objectToLookupItem((Object)namedElement);
                    if (lookupElement instanceof VariableLookupItem) {
                        VariableLookupItem variableLookupItem = (VariableLookupItem)lookupElement;
                        variableLookupItem.setSubstitutor(PsiSubstitutor.EMPTY);
                    }
                    LookupElement element2 = PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)100.0);
                    result2.addElement(ResourceTypeCompletionContributor.decorate(parameters2, types2, element2));
                    allowed.add(namedElement);
                    continue;
                }
                LookupElement element3 = ResourceTypeCompletionContributor.decorate(parameters2, types2, (LookupElement)LookupElementBuilder.create((Object)value2, (String)value2.getText()));
                result2.addElement(ResourceTypeCompletionContributor.decorate(parameters2, types2, element3));
                allowed.add(value2);
            }
        }
        result2.runRemainingContributors(parameters2, arg_0 -> ResourceTypeCompletionContributor.lambda$fillCompletionVariants$0((Set)allowed, result2, arg_0));
    }

    @Nullable
    private static PsiNamedElement getNamedElementFromAnnotationMember(PsiAnnotationMemberValue v) {
        if (v instanceof PsiReference) {
            PsiElement psiElement = ((PsiReference)v).resolve();
            if (psiElement instanceof PsiNamedElement) {
                PsiNamedElement named = (PsiNamedElement)psiElement;
                return named;
            }
        } else if (v instanceof LightElement) {
            PsiElement element2;
            PsiReference psiReference;
            PsiElement navigationElement = v.getNavigationElement();
            if (navigationElement instanceof KtDotQualifiedExpression) {
                KtDotQualifiedExpression dotQualifiedExpression = (KtDotQualifiedExpression)navigationElement;
                navigationElement = dotQualifiedExpression.getSelectorExpression();
            }
            if ((psiReference = navigationElement.getReference()) != null && (element2 = psiReference.resolve()) instanceof KtElement) {
                KtElement ktElement = (KtElement)element2;
                return LightClassUtilsKt.toLightElements((KtElement)ktElement).stream().findFirst().orElse(null);
            }
        }
        return null;
    }

    @Nullable
    private static Constraints getAllowedValues(@NotNull PsiElement pos) {
        Constraints allowedValues = null;
        for (Pair pair : MagicCompletionContributor.getMembersWithAllowedValues((PsiElement)pos)) {
            Constraints values = ResourceTypeCompletionContributor.getAllowedValues((PsiModifierListOwner)pair.first, (PsiType)pair.second, null);
            if (values == null) continue;
            if (allowedValues == null) {
                allowedValues = values;
                continue;
            }
            if (allowedValues.equals(values)) continue;
            return null;
        }
        return allowedValues;
    }

    private static LookupElement decorate(CompletionParameters parameters2, List<ExpectedTypeInfo> types2, LookupElement element2) {
        if (!types2.isEmpty() && parameters2.getCompletionType() == CompletionType.SMART) {
            element2 = JavaSmartCompletionContributor.decorate((LookupElement)element2, types2);
        }
        return element2;
    }

    @Nullable
    public static Constraints getAllowedValues(@NotNull PsiModifierListOwner element2, @Nullable PsiType type, @Nullable Set<PsiClass> visited) {
        PsiAnnotation[] annotations = ResourceTypeCompletionContributor.getAllAnnotations(element2);
        PsiManager manager = element2.getManager();
        ArrayList<ResourceType> resourceTypes = null;
        Constraints constraint = null;
        for (PsiAnnotation annotation : annotations) {
            PsiClass aClass;
            PsiElement resolved;
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName == null) continue;
            if (AndroidXConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(qualifiedName) || qualifiedName.startsWith("test.pkg.")) {
                ResourceType resourceType;
                if (AndroidXConstants.INT_DEF_ANNOTATION.isEquals(qualifiedName) || AndroidXConstants.STRING_DEF_ANNOTATION.isEquals(qualifiedName) || AndroidXConstants.LONG_DEF_ANNOTATION.isEquals(qualifiedName)) {
                    if (type != null && !(annotation instanceof PsiCompiledElement)) {
                        constraint = ResourceTypeCompletionContributor.merge(ResourceTypeCompletionContributor.getAllowedValuesFromTypedef(type, annotation, manager), constraint);
                    }
                } else if (ResourceEvaluator.COLOR_INT_ANNOTATION.isEquals(qualifiedName)) {
                    constraint = ResourceTypeCompletionContributor.merge(new ResourceTypeAllowedValues(Collections.singletonList(ResourceEvaluator.COLOR_INT_MARKER_TYPE)), constraint);
                } else if (ResourceEvaluator.PX_ANNOTATION.isEquals(qualifiedName) || ResourceEvaluator.DIMENSION_ANNOTATION.isEquals(qualifiedName)) {
                    constraint = ResourceTypeCompletionContributor.merge(new ResourceTypeAllowedValues(Collections.singletonList(ResourceEvaluator.DIMENSION_MARKER_TYPE)), constraint);
                } else if (qualifiedName.endsWith("Res") && (resourceType = ResourceTypeCompletionContributor.getResourceTypeFromAnnotation(qualifiedName)) != null) {
                    if (resourceTypes == null) {
                        resourceTypes = new ArrayList<ResourceType>();
                    }
                    resourceTypes.add(resourceType);
                }
            }
            if (constraint != null) continue;
            PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
            PsiElement psiElement = resolved = ref == null ? null : ref.resolve();
            if (resolved != null) {
                resolved = resolved.getNavigationElement();
            }
            if (resolved instanceof KtClass) {
                KtClass ktClass = (KtClass)resolved;
                resolved = LightClassUtilsKt.toLightClass((KtClassOrObject)ktClass);
            }
            if (!(resolved instanceof PsiClass) || !(aClass = (PsiClass)resolved).isAnnotationType()) continue;
            if (visited == null) {
                visited = new HashSet<PsiClass>();
            }
            if (!visited.add(aClass)) continue;
            constraint = ResourceTypeCompletionContributor.getAllowedValues((PsiModifierListOwner)aClass, type, visited);
        }
        if (resourceTypes != null) {
            constraint = ResourceTypeCompletionContributor.merge(new ResourceTypeAllowedValues(resourceTypes), constraint);
        }
        return constraint;
    }

    @Nullable
    private static Constraints merge(@Nullable Constraints head2, @Nullable Constraints tail) {
        if (head2 != null) {
            if (tail != null) {
                head2.next = tail;
                if (tail instanceof AllowedValues) {
                    head2.next = tail.next;
                    tail.next = head2;
                    head2 = tail;
                }
            }
            return head2;
        }
        return tail;
    }

    @NotNull
    public static PsiAnnotation[] getAllAnnotations(@NotNull PsiModifierListOwner element2) {
        return (PsiAnnotation[])CachedValuesManager.getCachedValue((PsiElement)element2, () -> CachedValueProvider.Result.create((Object)AnnotationUtil.getAllAnnotations((PsiModifierListOwner)element2, (boolean)true, null), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private static Constraints getAllowedValuesFromTypedef(@NotNull PsiType type, @NotNull PsiAnnotation magic, @NotNull PsiManager manager) {
        boolean canBeOred;
        PsiAnnotationMemberValue[] allowedValues;
        boolean isString;
        if (type instanceof PsiEllipsisType) {
            type = ((PsiEllipsisType)type).getComponentType();
        } else if (type instanceof PsiArrayType) {
            type = ((PsiArrayType)type).getComponentType();
        }
        boolean isInt = TypeConversionUtil.getTypeRank((PsiType)type) <= 5;
        boolean bl = isString = !isInt && type.equals(PsiType.getJavaLangString((PsiManager)manager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)manager.getProject())));
        if (isInt || isString) {
            PsiAnnotationMemberValue orValue;
            PsiAnnotationMemberValue intValues = magic.findAttributeValue("value");
            PsiAnnotationMemberValue[] psiAnnotationMemberValueArray = allowedValues = intValues instanceof PsiArrayInitializerMemberValue ? ((PsiArrayInitializerMemberValue)intValues).getInitializers() : PsiAnnotationMemberValue.EMPTY_ARRAY;
            canBeOred = isInt ? (orValue = magic.findAttributeValue("flag")) instanceof PsiLiteral && Boolean.TRUE.equals(((PsiLiteral)orValue).getValue()) : false;
        } else {
            return null;
        }
        if (allowedValues.length != 0) {
            return new AllowedValues(allowedValues, canBeOred);
        }
        return null;
    }

    private static boolean same(@Nullable PsiElement e1, @Nullable PsiElement e2, @NotNull PsiManager manager) {
        if (e1 instanceof PsiLiteralExpression && e2 instanceof PsiLiteralExpression) {
            return Objects.equals(((PsiLiteralExpression)e1).getValue(), ((PsiLiteralExpression)e2).getValue());
        }
        if (e1 instanceof PsiPrefixExpression && e2 instanceof PsiPrefixExpression && ((PsiPrefixExpression)e1).getOperationTokenType() == ((PsiPrefixExpression)e2).getOperationTokenType()) {
            return ResourceTypeCompletionContributor.same((PsiElement)((PsiPrefixExpression)e1).getOperand(), (PsiElement)((PsiPrefixExpression)e2).getOperand(), manager);
        }
        if (e1 instanceof PsiReference && e2 instanceof PsiReference) {
            e1 = ((PsiReference)e1).resolve();
            e2 = ((PsiReference)e2).resolve();
        }
        return manager.areElementsEquivalent(e2, e1);
    }

    @Nullable
    public static ResourceType getResourceTypeFromAnnotation(@NotNull String qualifiedName) {
        String resourceTypeName = qualifiedName.startsWith(AndroidXConstants.SUPPORT_ANNOTATIONS_PREFIX.oldName()) ? Character.toLowerCase(qualifiedName.charAt(AndroidXConstants.SUPPORT_ANNOTATIONS_PREFIX.oldName().length())) + qualifiedName.substring(AndroidXConstants.SUPPORT_ANNOTATIONS_PREFIX.oldName().length() + 1, qualifiedName.length() - "Res".length()) : Character.toLowerCase(qualifiedName.charAt(AndroidXConstants.SUPPORT_ANNOTATIONS_PREFIX.newName().length())) + qualifiedName.substring(AndroidXConstants.SUPPORT_ANNOTATIONS_PREFIX.newName().length() + 1, qualifiedName.length() - "Res".length());
        return ResourceType.fromClassName((String)resourceTypeName);
    }

    private static /* synthetic */ void lambda$fillCompletionVariants$0(Set allowed, CompletionResultSet result2, CompletionResult completionResult) {
        Object object = completionResult.getLookupElement().getObject();
        if (object instanceof PsiElement && allowed.contains(object)) {
            return;
        }
        result2.passResult(completionResult);
    }

    static class Constraints {
        @Nullable
        public Constraints next;

        Constraints() {
        }

        public boolean isSubsetOf(@NotNull Constraints other, @NotNull PsiManager manager) {
            return false;
        }
    }

    static class ResourceTypeAllowedValues
    extends Constraints {
        @NotNull
        final List<ResourceType> types;

        public ResourceTypeAllowedValues(@NotNull List<ResourceType> types2) {
            this.types = types2;
        }

        public boolean isTypeAllowed(@NotNull ResourceType type) {
            return this.isTypeAllowed(type.getName());
        }

        public boolean isTypeAllowed(@NotNull String typeName) {
            for (ResourceType type : this.types) {
                if (!type.getName().equals(typeName) && (type != ResourceType.DRAWABLE || !ResourceType.COLOR.getName().equals(typeName) && !ResourceType.MIPMAP.getName().equals(typeName))) continue;
                return true;
            }
            return false;
        }

        public boolean isCompatibleWith(@NotNull ResourceTypeAllowedValues other) {
            for (ResourceType type : other.types) {
                if (!this.isTypeAllowed(type)) continue;
                return true;
            }
            return false;
        }
    }

    static class AllowedValues
    extends Constraints {
        final PsiAnnotationMemberValue[] values;
        final boolean canBeOred;

        private AllowedValues(@NotNull PsiAnnotationMemberValue[] values, boolean canBeOred) {
            this.values = values;
            this.canBeOred = canBeOred;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AllowedValues a2 = (AllowedValues)o;
            if (this.canBeOred != a2.canBeOred) {
                return false;
            }
            HashSet<PsiAnnotationMemberValue> v1 = new HashSet<PsiAnnotationMemberValue>(Arrays.asList(this.values));
            HashSet<PsiAnnotationMemberValue> v2 = new HashSet<PsiAnnotationMemberValue>(Arrays.asList(a2.values));
            if (v1.size() != v2.size()) {
                return false;
            }
            block0: for (PsiAnnotationMemberValue value2 : v1) {
                for (PsiAnnotationMemberValue value22 : v2) {
                    if (!ResourceTypeCompletionContributor.same((PsiElement)value2, (PsiElement)value22, value2.getManager())) continue;
                    v2.remove(value22);
                    continue block0;
                }
            }
            return v2.isEmpty();
        }

        public int hashCode() {
            int result2 = Arrays.hashCode(this.values);
            result2 = 31 * result2 + (this.canBeOred ? 1 : 0);
            return result2;
        }

        @Override
        public boolean isSubsetOf(@NotNull Constraints other, @NotNull PsiManager manager) {
            if (!(other instanceof AllowedValues)) {
                return false;
            }
            AllowedValues o = (AllowedValues)other;
            for (PsiAnnotationMemberValue value2 : this.values) {
                boolean found = false;
                for (PsiAnnotationMemberValue otherValue : o.values) {
                    if (!ResourceTypeCompletionContributor.same((PsiElement)value2, (PsiElement)otherValue, manager)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
    }
}

