/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.formatter;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class AttributeComparator<A>
implements Comparator<A> {
    private final Function<A, String> myGetLocalPart;

    public AttributeComparator(@NotNull Function<A, String> getLocalPart) {
        this.myGetLocalPart = getLocalPart;
    }

    @Override
    public int compare(A attribute1, A attribute2) {
        return new Attribute(this.myGetLocalPart.apply(attribute1)).compareTo(new Attribute(this.myGetLocalPart.apply(attribute2)));
    }

    private static final class Attribute
    implements Comparable<Attribute> {
        private static final Comparator<Attribute> COMPARATOR = Comparator.comparing(attribute2 -> attribute2.myType).thenComparing(attribute2 -> attribute2.myLocalPartWithoutSpecifier).thenComparing(attribute2 -> attribute2.mySpecifier);
        private final Type myType;
        private final String myLocalPartWithoutSpecifier;
        private final Specifier mySpecifier;

        private Attribute(@NotNull String localPart) {
            this.myType = Type.get(localPart);
            Specifier specifier = Specifier.get(localPart);
            this.myLocalPartWithoutSpecifier = specifier.removeFrom(localPart);
            this.mySpecifier = specifier;
        }

        @Override
        public int compareTo(@NotNull Attribute attribute2) {
            return COMPARATOR.compare(this, attribute2);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Specifier {
        NULL(""){

            @Override
            @NotNull
            String removeFrom(@NotNull String localPart) {
                return localPart;
            }
        }
        ,
        WIDTH("Width"),
        HEIGHT("Height"),
        IN_PARENT("InParent"),
        HORIZONTAL("Horizontal"),
        VERTICAL("Vertical"),
        BASELINE("Baseline"),
        START("Start"),
        LEFT("Left"),
        TOP("Top"),
        END("End"),
        RIGHT("Right"),
        BOTTOM("Bottom"),
        UP("Up"),
        DOWN("Down");

        private static final Collection<Specifier> SPECIFIERS;
        private final Pattern myPattern;

        private Specifier(String name2) {
            this.myPattern = Pattern.compile(name2, 16);
        }

        @NotNull
        private static Specifier get(@NotNull String localPart) {
            Optional<Specifier> optionalSpecifier = SPECIFIERS.stream().filter(specifier -> localPart.contains(specifier.myPattern.toString())).findFirst();
            return optionalSpecifier.orElse(NULL);
        }

        @NotNull
        String removeFrom(@NotNull String localPart) {
            return this.myPattern.matcher(localPart).replaceFirst("");
        }

        static {
            SPECIFIERS = Sets.immutableEnumSet(EnumSet.complementOf(EnumSet.of(NULL)));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Type {
        LAYOUT_WIDTH{

            @Override
            boolean matches(@NotNull String localPart) {
                return localPart.equals("layout_width");
            }
        }
        ,
        LAYOUT_HEIGHT{

            @Override
            boolean matches(@NotNull String localPart) {
                return localPart.equals("layout_height");
            }
        }
        ,
        LAYOUT_ROW{

            @Override
            boolean matches(@NotNull String localPart) {
                return localPart.startsWith("layout_row");
            }
        }
        ,
        LAYOUT_COLUMN{

            @Override
            boolean matches(@NotNull String localPart) {
                return localPart.startsWith("layout_column");
            }
        }
        ,
        LAYOUT_ALIGN_WITH_PARENT_IF_MISSING{

            @Override
            boolean matches(@NotNull String localPart) {
                return localPart.equals("layout_alignWithParentIfMissing");
            }
        }
        ,
        LAYOUT_ABOVE{

            @Override
            boolean matches(@NotNull String localPart) {
                return localPart.equals("layout_above");
            }
        }
        ,
        LAYOUT_BELOW{

            @Override
            boolean matches(@NotNull String localPart) {
                return localPart.equals("layout_below");
            }
        }
        ,
        LAYOUT{

            @Override
            boolean matches(@NotNull String localPart) {
                return localPart.startsWith("layout_");
            }
        }
        ,
        WIDTH{

            @Override
            boolean matches(@NotNull String localPart) {
                return localPart.equals("width");
            }
        }
        ,
        HEIGHT{

            @Override
            boolean matches(@NotNull String localPart) {
                return localPart.equals("height");
            }
        }
        ,
        NON_LAYOUT{

            @Override
            boolean matches(@NotNull String localPart) {
                throw new UnsupportedOperationException();
            }
        };

        private static final Collection<Type> TYPES;

        @NotNull
        private static Type get(@NotNull String localPart) {
            Optional<Type> optionalType = TYPES.stream().filter(type -> type.matches(localPart)).findFirst();
            return optionalType.orElse(NON_LAYOUT);
        }

        abstract boolean matches(@NotNull String var1);

        static {
            TYPES = Sets.immutableEnumSet(EnumSet.complementOf(EnumSet.of(NON_LAYOUT)));
        }
    }
}

