/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.android.tools.idea.res.AndroidProjectRootListener;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.google.common.base.Splitter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 -2\u00020\u0001:\u0003-./B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u000bH\u0016Jc\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\r2\u001d\u0010\"\u001a\u0019\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060#\u00a2\u0006\u0002\b$2)\u0010%\u001a%\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\u001a0&\u00a2\u0006\u0002\b$H\u0082\bJ\u0010\u0010(\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020*2\u0006\u0010+\u001a\u00020,H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00078FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\t\u00a8\u00060"}, d2={"Lorg/jetbrains/android/facet/ResourceFolderManager;", "Lcom/intellij/openapi/util/ModificationTracker;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;)V", "folders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFolders", "()Ljava/util/List;", "generation", "", "mainAndTestFolders", "Lorg/jetbrains/android/facet/ResourceFolderManager$Folders;", "getMainAndTestFolders", "()Lorg/jetbrains/android/facet/ResourceFolderManager$Folders;", "getModule", "()Lcom/intellij/openapi/module/Module;", "primaryFolder", "getPrimaryFolder$annotations", "()V", "getPrimaryFolder", "()Lcom/intellij/openapi/vfs/VirtualFile;", "testFolders", "getTestFolders", "checkForChanges", "", "computeFolders", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "getModificationCount", "notifyIfChanged", "before", "after", "filesToCheck", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "callback", "Lkotlin/Function3;", "Lorg/jetbrains/android/facet/ResourceFolderManager$ResourceFolderListener;", "readFromFacetState", "toVirtualFiles", "", "manager", "Lcom/intellij/openapi/vfs/VirtualFileManager;", "Companion", "Folders", "ResourceFolderListener", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nResourceFolderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceFolderManager.kt\norg/jetbrains/android/facet/ResourceFolderManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n130#1,8:186\n130#1,8:194\n1603#2,9:202\n1851#2:211\n1852#2:213\n1612#2:214\n1#3:212\n*S KotlinDebug\n*F\n+ 1 ResourceFolderManager.kt\norg/jetbrains/android/facet/ResourceFolderManager\n*L\n120#1:186,8\n121#1:194,8\n182#1:202,9\n182#1:211\n182#1:213\n182#1:214\n182#1:212\n*E\n"})
public final class ResourceFolderManager
implements ModificationTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Module module;
    private volatile long generation;
    @NotNull
    private static final Key<Folders> FOLDERS_KEY;
    @NotNull
    private static final Folders emptyFolders;
    @JvmField
    @NotNull
    public static final Topic<ResourceFolderListener> TOPIC;

    public ResourceFolderManager(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        this.module = module2;
        AndroidProjectRootListener.ensureSubscribed(this.module.getProject());
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    public long getModificationCount() {
        return this.generation;
    }

    @NotNull
    public final List<VirtualFile> getFolders() {
        return this.getMainAndTestFolders().getMain();
    }

    @NotNull
    public final List<VirtualFile> getTestFolders() {
        return this.getMainAndTestFolders().getTest();
    }

    private final Folders getMainAndTestFolders() {
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((Module)this.module);
        if (androidFacet == null) {
            return emptyFolders;
        }
        AndroidFacet facet2 = androidFacet;
        Folders folders = (Folders)facet2.getUserData(FOLDERS_KEY);
        if (folders == null) {
            Object object = facet2.putUserDataIfAbsent(FOLDERS_KEY, (Object)this.computeFolders(facet2));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"facet.putUserDataIfAbsen\u2026Y, computeFolders(facet))");
            folders = (Folders)object;
        }
        return folders;
    }

    @Nullable
    public final VirtualFile getPrimaryFolder() {
        return (VirtualFile)CollectionsKt.firstOrNull(this.getFolders());
    }

    @Deprecated(message="Instead of calling this, ask the user which resource folder should be used.")
    public static /* synthetic */ void getPrimaryFolder$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    public final void checkForChanges() {
        List<VirtualFile> p2;
        Object p0;
        List<VirtualFile> list2;
        Object object;
        AndroidFacet androidFacet;
        long l;
        if (this.module.isDisposed()) {
            return;
        }
        AndroidFacet androidFacet2 = ModuleExtensionsKt.getAndroidFacet((Module)this.module);
        if (androidFacet2 == null) {
            return;
        }
        AndroidFacet facet2 = androidFacet2;
        Folders folders = (Folders)facet2.getUserData(FOLDERS_KEY);
        if (folders == null) {
            return;
        }
        Folders before = folders;
        facet2.putUserData(FOLDERS_KEY, null);
        Folders after = this.getMainAndTestFolders();
        ResourceFolderManager this_$iv = this;
        boolean $i$f$notifyIfChanged = false;
        Folders p02 = before;
        boolean bl = false;
        List<VirtualFile> filesBefore$iv = p02.getMain();
        Folders p03 = after;
        $i$a$-notifyIfChanged-ResourceFolderManager$checkForChanges$1 = false;
        List<VirtualFile> filesAfter$iv = p03.getMain();
        if (!Intrinsics.areEqual(filesBefore$iv, filesAfter$iv)) {
            l = this_$iv.generation;
            this_$iv.generation = l + 1L;
            AndroidFacet androidFacet3 = ModuleExtensionsKt.getAndroidFacet((Module)this_$iv.module);
            if (androidFacet3 != null) {
                void p1;
                AndroidFacet facet$iv = androidFacet3;
                Object object2 = this_$iv.module.getProject().getMessageBus().syncPublisher(TOPIC);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"module.project.messageBus.syncPublisher(TOPIC)");
                Folders folders2 = after;
                androidFacet = facet$iv;
                object = object2;
                androidFacet4 = false;
                List<VirtualFile> list3 = list2 = ((Folders)p0).getMain();
                AndroidFacet androidFacet4 = androidFacet;
                p0 = (ResourceFolderListener)object;
                boolean bl2 = false;
                p0.mainResourceFoldersChanged((AndroidFacet)p1, (List<? extends VirtualFile>)p2);
            }
        }
        this_$iv = this;
        $i$f$notifyIfChanged = false;
        p02 = before;
        boolean bl3 = false;
        filesBefore$iv = p02.getTest();
        p0 = after;
        $i$a$-notifyIfChanged-ResourceFolderManager$checkForChanges$3 = false;
        filesAfter$iv = p0.getTest();
        if (!Intrinsics.areEqual(filesBefore$iv, filesAfter$iv)) {
            l = this_$iv.generation;
            this_$iv.generation = l + 1L;
            AndroidFacet androidFacet5 = ModuleExtensionsKt.getAndroidFacet((Module)this_$iv.module);
            if (androidFacet5 != null) {
                void p1;
                AndroidFacet facet$iv = androidFacet5;
                Object object3 = this_$iv.module.getProject().getMessageBus().syncPublisher(TOPIC);
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"module.project.messageBus.syncPublisher(TOPIC)");
                p0 = after;
                androidFacet = facet$iv;
                object = object3;
                androidFacet6 = false;
                p2 = list2 = ((Folders)p0).getTest();
                AndroidFacet androidFacet6 = androidFacet;
                p0 = (ResourceFolderListener)object;
                boolean bl4 = false;
                p0.testResourceFoldersChanged((AndroidFacet)p1, p2);
            }
        }
    }

    private final void notifyIfChanged(Folders before, Folders after, Function1<? super Folders, ? extends List<? extends VirtualFile>> filesToCheck, Function3<? super ResourceFolderListener, ? super AndroidFacet, ? super List<? extends VirtualFile>, Unit> callback2) {
        List filesAfter;
        boolean $i$f$notifyIfChanged = false;
        List filesBefore = (List)filesToCheck.invoke((Object)before);
        if (!Intrinsics.areEqual((Object)filesBefore, (Object)(filesAfter = (List)filesToCheck.invoke((Object)after)))) {
            long l = this.generation;
            this.generation = l + 1L;
            AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((Module)this.module);
            if (androidFacet == null) {
                return;
            }
            AndroidFacet facet2 = androidFacet;
            Object object = this.module.getProject().getMessageBus().syncPublisher(TOPIC);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"module.project.messageBus.syncPublisher(TOPIC)");
            callback2.invoke(object, (Object)facet2, filesToCheck.invoke((Object)after));
        }
    }

    private final Folders computeFolders(AndroidFacet facet2) {
        return !AndroidModel.isRequired(facet2) ? new Folders(CollectionsKt.toList(SourceProviderManager.Companion.getInstance(facet2).getMainIdeaSourceProvider().getResDirectories()), CollectionsKt.emptyList()) : this.readFromFacetState(facet2);
    }

    private final Folders readFromFacetState(AndroidFacet facet2) {
        Folders folders;
        String mainFolders;
        Module module2 = facet2.getMainModule();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.mainModule");
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((Module)module2);
        String string = androidFacet != null && (androidFacet = (AndroidFacetConfiguration)androidFacet.getConfiguration()) != null && (androidFacet = androidFacet.getState()) != null ? androidFacet.RES_FOLDERS_RELATIVE_PATH : (mainFolders = null);
        if (mainFolders != null) {
            List<VirtualFile> list2;
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance()");
            VirtualFileManager manager = virtualFileManager;
            List<VirtualFile> list3 = this.toVirtualFiles(mainFolders, manager);
            Object object = facet2.getAndroidTestModule();
            if ((object != null && (object = ModuleExtensionsKt.getAndroidFacet((Module)object)) != null && (object = (AndroidFacetConfiguration)object.getConfiguration()) != null && (object = object.getState()) != null && (object = object.TEST_RES_FOLDERS_RELATIVE_PATH) != null ? this.toVirtualFiles((String)object, manager) : (list2 = null)) == null) {
                list2 = CollectionsKt.emptyList();
            }
            folders = new Folders(list3, list2);
        } else {
            VirtualFile virtualFile = AndroidRootUtil.getFileByRelativeModulePath(facet2.getModule(), "/src/main/res", true);
            if (virtualFile == null && (virtualFile = AndroidRootUtil.getFileByRelativeModulePath(facet2.getModule(), "/res", true)) == null) {
                return emptyFolders;
            }
            folders = new Folders(CollectionsKt.listOf((Object)virtualFile), CollectionsKt.emptyList());
        }
        return folders;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> toVirtualFiles(String $this$toVirtualFiles, VirtualFileManager manager) {
        void $this$mapNotNullTo$iv$iv;
        Iterable iterable = Splitter.on((String)";").omitEmptyStrings().trimResults().split((CharSequence)$this$toVirtualFiles);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"on(AndroidFacetPropertie\u2026ults()\n      .split(this)");
        Iterable $this$mapNotNull$iv = iterable;
        boolean $i$f$mapNotNull = false;
        Iterable iterable2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String p0 = (String)element$iv$iv;
            boolean bl2 = false;
            if (manager.findFileByUrl(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @NotNull
    public static final ResourceFolderManager getInstance(@NotNull AndroidFacet facet2) {
        return Companion.getInstance(facet2);
    }

    static {
        String string = Reflection.getOrCreateKotlinClass(ResourceFolderManager.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        Key key = Key.create((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create<Folders>(Resource\u2026r::class.qualifiedName!!)");
        FOLDERS_KEY = key;
        emptyFolders = new Folders(CollectionsKt.emptyList(), CollectionsKt.emptyList());
        String string2 = Reflection.getOrCreateKotlinClass(ResourceFolderManager.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string2);
        Topic topic = Topic.create((String)string2, ResourceFolderListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.NONE);
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"create(ResourceFolderMan\u2026.BroadcastDirection.NONE)");
        TOPIC = topic;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\u0002\b\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/android/facet/ResourceFolderManager$Companion;", "", "()V", "FOLDERS_KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/android/facet/ResourceFolderManager$Folders;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lorg/jetbrains/android/facet/ResourceFolderManager$ResourceFolderListener;", "emptyFolders", "getInstance", "Lorg/jetbrains/android/facet/ResourceFolderManager;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ResourceFolderManager getInstance(@NotNull AndroidFacet facet2) {
            Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
            Object object = facet2.getModule().getService(ResourceFolderManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"facet.module.getService(\u2026olderManager::class.java)");
            return (ResourceFolderManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/android/facet/ResourceFolderManager$Folders;", "", "main", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "test", "(Ljava/util/List;Ljava/util/List;)V", "getMain", "()Ljava/util/List;", "getTest", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.android.core"})
    private static final class Folders {
        @NotNull
        private final List<VirtualFile> main;
        @NotNull
        private final List<VirtualFile> test;

        public Folders(@NotNull List<? extends VirtualFile> main, @NotNull List<? extends VirtualFile> test) {
            Intrinsics.checkNotNullParameter(main, (String)"main");
            Intrinsics.checkNotNullParameter(test, (String)"test");
            this.main = main;
            this.test = test;
        }

        @NotNull
        public final List<VirtualFile> getMain() {
            return this.main;
        }

        @NotNull
        public final List<VirtualFile> getTest() {
            return this.test;
        }

        @NotNull
        public final List<VirtualFile> component1() {
            return this.main;
        }

        @NotNull
        public final List<VirtualFile> component2() {
            return this.test;
        }

        @NotNull
        public final Folders copy(@NotNull List<? extends VirtualFile> main, @NotNull List<? extends VirtualFile> test) {
            Intrinsics.checkNotNullParameter(main, (String)"main");
            Intrinsics.checkNotNullParameter(test, (String)"test");
            return new Folders(main, test);
        }

        public static /* synthetic */ Folders copy$default(Folders folders, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = folders.main;
            }
            if ((n & 2) != 0) {
                list3 = folders.test;
            }
            return folders.copy(list2, list3);
        }

        @NotNull
        public String toString() {
            return "Folders(main=" + this.main + ", test=" + this.test + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.main).hashCode();
            result2 = result2 * 31 + ((Object)this.test).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Folders)) {
                return false;
            }
            Folders folders = (Folders)other;
            if (!Intrinsics.areEqual(this.main, folders.main)) {
                return false;
            }
            return Intrinsics.areEqual(this.test, folders.test);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H&J\u001e\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H&\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lorg/jetbrains/android/facet/ResourceFolderManager$ResourceFolderListener;", "", "mainResourceFoldersChanged", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "folders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "testResourceFoldersChanged", "intellij.android.core"})
    public static interface ResourceFolderListener {
        public void mainResourceFoldersChanged(@NotNull AndroidFacet var1, @NotNull List<? extends VirtualFile> var2);

        public void testResourceFoldersChanged(@NotNull AndroidFacet var1, @NotNull List<? extends VirtualFile> var2);
    }
}

