/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.ScopeType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.InheritanceUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a \u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u0018\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a+\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0010\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0001\u00a8\u0006\u0013"}, d2={"findClassByName", "Lcom/intellij/psi/PsiClass;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "name", "", "baseClassName", "findClassValidInXMLByName", "findViewClassByName", "findViewValidInXMLByName", "getTagNamesByClass", "", "c", "apiLevel", "", "parentClassQualifiedName", "(Lcom/intellij/psi/PsiClass;ILjava/lang/String;)[Ljava/lang/String;", "isVisibleInXml", "", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nAndroidClassesForXmlUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidClassesForXmlUtil.kt\norg/jetbrains/android/facet/AndroidClassesForXmlUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 actions.kt\ncom/intellij/openapi/application/ActionsKt\n*L\n1#1,108:1\n1#2:109\n21#3:110\n*S KotlinDebug\n*F\n+ 1 AndroidClassesForXmlUtil.kt\norg/jetbrains/android/facet/AndroidClassesForXmlUtilKt\n*L\n83#1:110\n*E\n"})
public final class AndroidClassesForXmlUtilKt {
    private static final PsiClass findClassByName(AndroidFacet facet2, String name2, String baseClassName) {
        PsiClass psiClass;
        block5: {
            Module module2 = facet2.getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
            Module module3 = module2;
            Project project = module3.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
            Project project2 = project;
            PsiClass psiClass2 = JavaPsiFacade.getInstance((Project)project2).findClass(baseClassName, module3.getModuleWithLibrariesScope());
            if (psiClass2 == null) {
                return null;
            }
            PsiClass baseClass = psiClass2;
            if (!StringsKt.contains$default((CharSequence)name2, (CharSequence)".", (boolean)false, (int)2, null)) {
                PsiClass[] classes2;
                PsiClass[] psiClassArray = PsiShortNamesCache.getInstance((Project)project2).getClassesByName(name2, module3.getModuleWithLibrariesScope());
                Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getInstance(project).get\u2026moduleWithLibrariesScope)");
                PsiClass[] psiClassArray2 = classes2 = psiClassArray;
                int n = psiClassArray2.length;
                for (int i = 0; i < n; ++i) {
                    PsiClass psiClass3;
                    PsiClass it = psiClass3 = psiClassArray2[i];
                    boolean bl = false;
                    boolean bl2 = it.getQualifiedName() != null && InheritanceUtil.isInheritorOrSelf((PsiClass)it, (PsiClass)baseClass, (boolean)true);
                    if (!bl2) continue;
                    psiClass = psiClass3;
                    break block5;
                }
                psiClass = null;
            } else {
                PsiClass[] classes3 = JavaPsiFacade.getInstance((Project)project2).findClasses(name2, ProjectSystemUtil.getModuleSystem(module3).getResolveScope(ScopeType.MAIN));
                Intrinsics.checkNotNullExpressionValue((Object)classes3, (String)"classes");
                PsiClass[] psiClassArray = classes3;
                int n = psiClassArray.length;
                for (int i = 0; i < n; ++i) {
                    PsiClass psiClass4;
                    PsiClass it = psiClass4 = psiClassArray[i];
                    boolean bl = false;
                    if (!InheritanceUtil.isInheritorOrSelf((PsiClass)it, (PsiClass)baseClass, (boolean)true)) continue;
                    psiClass = psiClass4;
                    break block5;
                }
                psiClass = null;
            }
        }
        return psiClass;
    }

    @Nullable
    public static final PsiClass findClassValidInXMLByName(@NotNull AndroidFacet facet2, @NotNull String name2, @NotNull String baseClassName) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)baseClassName, (String)"baseClassName");
        PsiClass psiClass = AndroidClassesForXmlUtilKt.findClassByName(facet2, name2, baseClassName);
        if (psiClass == null) {
            return null;
        }
        PsiClass candidate = psiClass;
        if (!AndroidClassesForXmlUtilKt.isVisibleInXml(candidate)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)candidate.getName(), (Object)name2)) {
            String string = candidate.getQualifiedName();
            Intrinsics.checkNotNull((Object)string);
            if (IdeResourcesUtil.isClassPackageNeeded(string, candidate, StudioAndroidModuleInfo.getInstance(facet2).getModuleMinApi(), baseClassName)) {
                return null;
            }
        }
        return candidate;
    }

    @Nullable
    public static final PsiClass findViewClassByName(@NotNull AndroidFacet facet2, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return AndroidClassesForXmlUtilKt.findClassByName(facet2, name2, "android.view.View");
    }

    @Nullable
    public static final PsiClass findViewValidInXMLByName(@NotNull AndroidFacet facet2, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return AndroidClassesForXmlUtilKt.findClassValidInXMLByName(facet2, name2, "android.view.View");
    }

    @NotNull
    public static final String[] getTagNamesByClass(@NotNull PsiClass c, int apiLevel, @Nullable String parentClassQualifiedName) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        boolean $i$f$runReadAction = false;
        return (String[])ApplicationManager.getApplication().runReadAction(new Computable(c, apiLevel, parentClassQualifiedName){
            final /* synthetic */ PsiClass $c$inlined;
            final /* synthetic */ int $apiLevel$inlined;
            final /* synthetic */ String $parentClassQualifiedName$inlined;
            {
                this.$c$inlined = psiClass;
                this.$apiLevel$inlined = n;
                this.$parentClassQualifiedName$inlined = string;
            }

            public final T compute() {
                String[] stringArray;
                boolean bl = false;
                String name2 = this.$c$inlined.getName();
                if (name2 == null || !AndroidClassesForXmlUtilKt.isVisibleInXml(this.$c$inlined)) {
                    boolean $i$f$emptyArray = false;
                    stringArray = new String[]{};
                } else {
                    String string = this.$c$inlined.getQualifiedName();
                    if (string == null) {
                        String[] stringArray2 = new String[]{name2};
                        stringArray = stringArray2;
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"c.qualifiedName ?: retur\u2026nReadAction arrayOf(name)");
                        String qualifiedName = string;
                        if (IdeResourcesUtil.isClassPackageNeeded(qualifiedName, this.$c$inlined, this.$apiLevel$inlined, this.$parentClassQualifiedName$inlined)) {
                            String[] stringArray3 = new String[]{qualifiedName};
                            stringArray = stringArray3;
                        } else {
                            String[] stringArray4 = new String[]{name2, qualifiedName};
                            stringArray = stringArray4;
                        }
                    }
                }
                return (T)stringArray;
            }
        });
    }

    public static final boolean isVisibleInXml(@NotNull PsiClass $this$isVisibleInXml) {
        Intrinsics.checkNotNullParameter((Object)$this$isVisibleInXml, (String)"<this>");
        PsiModifierList psiModifierList = $this$isVisibleInXml.getModifierList();
        if (psiModifierList == null) {
            return false;
        }
        PsiModifierList modifierList = psiModifierList;
        boolean isPublic = modifierList.hasModifierProperty("public");
        boolean isRestricted = modifierList.hasAnnotation(AnnotationDetectorKt.RESTRICT_TO_ANNOTATION.oldName()) || modifierList.hasAnnotation(AnnotationDetectorKt.RESTRICT_TO_ANNOTATION.newName());
        return isPublic && !isRestricted && !AndroidUtils.isAbstract($this$isVisibleInXml);
    }
}

