/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.exportSignedPackage;

import com.android.tools.idea.gradle.actions.GoToApkLocationTask;
import com.android.tools.idea.gradle.actions.GoToBundleLocationTask;
import com.android.tools.idea.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.model.IdeVariantBuildInformation;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPath;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPathKt;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.SigningWizardEvent;
import com.google.wireless.android.vending.developer.signing.tools.extern.export.ExportEncryptedPrivateKeyTool;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.android.exportSignedPackage.ApkStep;
import org.jetbrains.android.exportSignedPackage.ChooseBundleOrApkStep;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizardStep;
import org.jetbrains.android.exportSignedPackage.GenerateSignedApkSettings;
import org.jetbrains.android.exportSignedPackage.GradleSignStep;
import org.jetbrains.android.exportSignedPackage.GradleSigningInfo;
import org.jetbrains.android.exportSignedPackage.KeystoreStep;
import org.jetbrains.android.exportSignedPackage.SigningWizardUsageTrackerUtilsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExportSignedPackageWizard
extends AbstractWizard<ExportSignedPackageWizardStep> {
    public static final String BUNDLE = "bundle";
    public static final String APK = "apk";
    private static final String ENCRYPTED_PRIVATE_KEY_FILE = "private_key.pepk";
    private static final String GOOGLE_PUBLIC_KEY = "eb10fe8f7c7c9df715022017b00c6471f8ba8170b13049a11e6c09ffe3056a104a3bbe4ac5a955f4ba4fe93fc8cef27558a3eb9d2a529a2092761fb833b656cd48b9de6a";
    @NotNull
    private final Project myProject;
    private AndroidFacet myFacet;
    private PrivateKey myPrivateKey;
    private X509Certificate myCertificate;
    private boolean mySigned;
    private CompileScope myCompileScope;
    private String myApkPath;
    private String myExportKeyPath;
    @NotNull
    private String myTargetType = "apk";
    @NotNull
    private ExportEncryptedPrivateKeyTool myEncryptionTool;
    private boolean myExportPrivateKey;
    private List<String> myBuildVariants;
    private GradleSigningInfo myGradleSigningInfo;

    private static Logger getLog() {
        return Logger.getInstance(ExportSignedPackageWizard.class);
    }

    public ExportSignedPackageWizard(@NotNull Project project, @NotNull List<AndroidFacet> facets, boolean signed, Boolean showBundle, @NotNull ExportEncryptedPrivateKeyTool encryptionTool) {
        super(AndroidBundle.message(showBundle != false ? "android.export.package.wizard.bundle.title" : "android.export.package.wizard.title", new Object[0]), project);
        this.myProject = project;
        this.mySigned = signed;
        this.myEncryptionTool = encryptionTool;
        assert (!facets.isEmpty());
        this.myFacet = facets.get(0);
        if (showBundle.booleanValue()) {
            this.addStep((Step)new ChooseBundleOrApkStep(this));
        }
        boolean useGradleToSign = AndroidModel.isRequired(this.myFacet);
        if (signed) {
            this.addStep((Step)new KeystoreStep(this, useGradleToSign, facets));
        }
        if (useGradleToSign) {
            this.addStep((Step)new GradleSignStep(this));
        } else {
            this.addStep((Step)new ApkStep(this));
        }
        this.init();
    }

    public boolean isSigned() {
        return this.mySigned;
    }

    protected void doOKAction() {
        if (!this.commitCurrentStep()) {
            return;
        }
        SigningWizardUsageTrackerUtilsKt.trackWizardOkAction(this.myProject);
        super.doOKAction();
        assert (this.myFacet != null);
        assert (AndroidModel.isRequired(this.myFacet));
        this.buildAndSignGradleProject();
    }

    public void doCancelAction() {
        SigningWizardUsageTrackerUtilsKt.trackWizardClosed(this.myProject);
        super.doCancelAction();
    }

    public void show() {
        SigningWizardUsageTrackerUtilsKt.trackWizardOpen(this.myProject);
        super.show();
    }

    private void buildAndSignGradleProject() {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Generating Signed APKs", false, null){

            public void run(@NotNull ProgressIndicator indicator) {
                Consumer buildResultHandler;
                SigningWizardEvent.SigningTargetType targetType;
                GradleFacet gradleFacet = GradleFacet.getInstance(ExportSignedPackageWizard.this.myFacet.getModule());
                if (gradleFacet == null) {
                    ExportSignedPackageWizard.getLog().error("Unable to get gradle project information for module: " + ExportSignedPackageWizard.this.myFacet.getModule().getName());
                    SigningWizardUsageTrackerUtilsKt.trackWizardGradleSigningFailed(this.myProject, SigningWizardEvent.SigningWizardFailureCause.FAILURE_CAUSE_NO_MODULE_FACET);
                    return;
                }
                GradleProjectPath gradleProjectPath = GradleProjectPathKt.getGradleProjectPath(ExportSignedPackageWizard.this.myFacet.getModule());
                if (gradleProjectPath == null) {
                    ExportSignedPackageWizard.getLog().error("Unable to get gradle project information for module: " + ExportSignedPackageWizard.this.myFacet.getModule().getName());
                    SigningWizardUsageTrackerUtilsKt.trackWizardGradleSigningFailed(this.myProject, SigningWizardEvent.SigningWizardFailureCause.FAILURE_CAUSE_NO_MODULE_FACET);
                    return;
                }
                String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)ExportSignedPackageWizard.this.myFacet.getModule());
                if (StringUtil.isEmpty((String)rootProjectPath)) {
                    ExportSignedPackageWizard.getLog().error("Unable to get gradle root project path for module: " + ExportSignedPackageWizard.this.myFacet.getModule().getName());
                    SigningWizardUsageTrackerUtilsKt.trackWizardGradleSigningFailed(this.myProject, SigningWizardEvent.SigningWizardFailureCause.FAILURE_CAUSE_NO_MODULE_ROOT_PATH);
                    return;
                }
                GradleAndroidModel androidModel = GradleAndroidModel.get(ExportSignedPackageWizard.this.myFacet);
                if (androidModel == null) {
                    ExportSignedPackageWizard.getLog().error("Unable to obtain Android project model. Did the last Gradle sync complete successfully?");
                    SigningWizardUsageTrackerUtilsKt.trackWizardGradleSigningFailed(this.myProject, SigningWizardEvent.SigningWizardFailureCause.FAILURE_CAUSE_NO_ANDROID_MODEL);
                    return;
                }
                if (ExportSignedPackageWizard.this.myBuildVariants == null) {
                    ExportSignedPackageWizard.getLog().error("Unable to find required information. Please check the previous steps are completed.");
                    SigningWizardUsageTrackerUtilsKt.trackWizardGradleSigningFailed(this.myProject, SigningWizardEvent.SigningWizardFailureCause.FAILURE_CAUSE_NO_VARIANTS_SELECTED);
                    return;
                }
                List<String> gradleTasks = ExportSignedPackageWizard.getGradleTasks(gradleProjectPath.getPath(), androidModel, ExportSignedPackageWizard.this.myBuildVariants, ExportSignedPackageWizard.this.myTargetType);
                ArrayList<String> projectProperties = new ArrayList<String>();
                projectProperties.add(this.createProperty("android.injected.signing.store.file", ExportSignedPackageWizard.this.myGradleSigningInfo.keyStoreFilePath));
                projectProperties.add(this.createProperty("android.injected.signing.store.password", new String(ExportSignedPackageWizard.this.myGradleSigningInfo.keyStorePassword)));
                projectProperties.add(this.createProperty("android.injected.signing.key.alias", ExportSignedPackageWizard.this.myGradleSigningInfo.keyAlias));
                projectProperties.add(this.createProperty("android.injected.signing.key.password", new String(ExportSignedPackageWizard.this.myGradleSigningInfo.keyPassword)));
                projectProperties.add(this.createProperty("android.injected.apk.location", ExportSignedPackageWizard.this.myApkPath));
                assert (this.myProject != null);
                GradleBuildInvoker gradleBuildInvoker = GradleBuildInvoker.getInstance(this.myProject);
                ImmutableList modules = ImmutableList.of((Object)ExportSignedPackageWizard.this.myFacet.getMainModule());
                boolean isKeyExported = false;
                if (ExportSignedPackageWizard.this.myTargetType.equals(ExportSignedPackageWizard.BUNDLE)) {
                    targetType = SigningWizardEvent.SigningTargetType.TARGET_TYPE_BUNDLE;
                    File exportedKeyFile = null;
                    if (ExportSignedPackageWizard.this.myExportPrivateKey) {
                        isKeyExported = true;
                        exportedKeyFile = ExportSignedPackageWizard.this.generatePrivateKeyPath();
                        try {
                            ExportSignedPackageWizard.this.myEncryptionTool.run(ExportSignedPackageWizard.this.myGradleSigningInfo.keyStoreFilePath, ExportSignedPackageWizard.this.myGradleSigningInfo.keyAlias, ExportSignedPackageWizard.GOOGLE_PUBLIC_KEY, exportedKeyFile.getPath(), ExportSignedPackageWizard.this.myGradleSigningInfo.keyStorePassword, ExportSignedPackageWizard.this.myGradleSigningInfo.keyPassword);
                            GenerateSignedApkSettings settings = GenerateSignedApkSettings.getInstance(this.myProject);
                            settings.EXPORT_PRIVATE_KEY = false;
                        }
                        catch (Exception e) {
                            ExportSignedPackageWizard.getLog().error("Something went wrong with the encryption tool", (Throwable)e);
                            UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)this.getProject(), (String)AndroidBundle.message("android.export.package.bundle.key.export.error.description", e.getMessage()), (String)AndroidBundle.message("android.export.package.bundle.key.export.error.title", new Object[0])));
                            SigningWizardUsageTrackerUtilsKt.trackWizardGradleSigningFailed(this.myProject, SigningWizardEvent.SigningWizardFailureCause.FAILURE_CAUSE_ENCRYPTION_ERROR);
                            return;
                        }
                    }
                    buildResultHandler = new GoToBundleLocationTask(this.myProject, (Collection<Module>)modules, "Generate Signed Bundle", ExportSignedPackageWizard.this.myBuildVariants, exportedKeyFile)::executeWhenBuildFinished;
                } else {
                    targetType = SigningWizardEvent.SigningTargetType.TARGET_TYPE_APK;
                    buildResultHandler = new GoToApkLocationTask(this.myProject, (Collection<Module>)modules, "Generate Signed APK", ExportSignedPackageWizard.this.myBuildVariants)::executeWhenBuildFinished;
                }
                File file2 = new File(rootProjectPath);
                buildResultHandler.consume(gradleBuildInvoker.executeAssembleTasks(modules.toArray(new Module[0]), (List<GradleBuildInvoker.Request>)ImmutableList.of((Object)GradleBuildInvoker.Request.builder(gradleBuildInvoker.getProject(), file2, gradleTasks).setCommandLineArguments(projectProperties).setMode(ExportSignedPackageWizard.getBuildModeFromTarget(ExportSignedPackageWizard.this.myTargetType)).build())));
                SigningWizardUsageTrackerUtilsKt.trackWizardGradleSigning(this.myProject, targetType, modules.size(), ExportSignedPackageWizard.this.myBuildVariants.size(), isKeyExported);
                ExportSignedPackageWizard.getLog().info("Export " + StringUtil.toUpperCase((String)ExportSignedPackageWizard.this.myTargetType) + " command: " + Joiner.on((char)',').join(gradleTasks) + ", destination: " + this.createProperty("android.injected.apk.location", ExportSignedPackageWizard.this.myApkPath));
            }

            private String createProperty(@NotNull String name2, @NotNull String value2) {
                return AndroidGradleSettings.createProjectProperty((String)name2, (String)value2);
            }
        });
    }

    @VisibleForTesting
    @Nullable
    static BuildMode getBuildModeFromTarget(@NotNull String targetType) {
        if (targetType.equals(APK)) {
            return BuildMode.ASSEMBLE;
        }
        if (targetType.equals(BUNDLE)) {
            return BuildMode.BUNDLE;
        }
        return null;
    }

    @VisibleForTesting
    @NotNull
    static File getApkLocation(@NotNull String apkFolderPath, @NotNull String buildType) {
        return new File(apkFolderPath, buildType);
    }

    @VisibleForTesting
    @NotNull
    static List<String> getGradleTasks(@NotNull String gradleProjectPath, @NotNull GradleAndroidModel GradleAndroidModel2, @NotNull List<String> buildVariants, @NotNull String targetType) {
        List<String> taskNames;
        if (GradleAndroidModel2.getFeatures().isBuildOutputFileSupported()) {
            taskNames = ExportSignedPackageWizard.getTaskNamesFromBuildInformation(GradleAndroidModel2, buildVariants, targetType);
        } else {
            IdeVariant selectedVariant = GradleAndroidModel2.getSelectedVariant();
            String selectedTaskName = ExportSignedPackageWizard.getTaskName(selectedVariant, targetType);
            if (selectedTaskName == null) {
                ExportSignedPackageWizard.getLog().warn("Could not get tasks for target " + targetType + " on variant " + selectedVariant.getName());
                return Collections.emptyList();
            }
            taskNames = ExportSignedPackageWizard.getTaskNamesFromSelectedVariant(buildVariants, selectedVariant.getName(), selectedTaskName);
        }
        return ContainerUtil.map(taskNames, name2 -> GradleProjectSystemUtil.createFullTaskName(gradleProjectPath, name2));
    }

    @NotNull
    private static List<String> getTaskNamesFromBuildInformation(@NotNull GradleAndroidModel GradleAndroidModel2, @NotNull List<String> buildVariants, @NotNull String targetType) {
        ArrayList taskNames = Lists.newArrayListWithExpectedSize((int)buildVariants.size());
        Map<String, IdeVariantBuildInformation> buildInformationByVariantName = GradleAndroidModel2.getAndroidProject().getVariantsBuildInformation().stream().collect(Collectors.toMap(x -> x.getVariantName(), x -> x));
        for (String variantName : buildVariants) {
            IdeVariantBuildInformation buildInformation = buildInformationByVariantName.get(variantName);
            if (buildInformation == null) {
                ExportSignedPackageWizard.getLog().warn("Could not get tasks for target " + targetType + " on variant " + variantName);
                continue;
            }
            String taskName = targetType.equals(BUNDLE) ? buildInformation.getBuildInformation().getBundleTaskName() : buildInformation.getBuildInformation().getAssembleTaskName();
            taskNames.add(taskName);
        }
        return taskNames;
    }

    @VisibleForTesting
    @NotNull
    static List<String> getTaskNamesFromSelectedVariant(@NotNull List<String> buildVariants, @NotNull String selectedVariantName, @NotNull String selectedTaskName) {
        ArrayList gradleTasks = Lists.newArrayListWithExpectedSize((int)buildVariants.size());
        for (String variantName : buildVariants) {
            String taskName = ExportSignedPackageWizard.replaceVariantFromTask(selectedTaskName, selectedVariantName, variantName);
            if (taskName != null) {
                gradleTasks.add(taskName);
                continue;
            }
            ExportSignedPackageWizard.getLog().warn("Could not replace variant " + selectedVariantName + " with " + variantName + " for task " + selectedTaskName + ".");
        }
        return gradleTasks;
    }

    @VisibleForTesting
    @Nullable
    static String replaceVariantFromTask(@NotNull String task2, @NotNull String oldVariant, @NotNull String newVariant) {
        if (task2.indexOf(oldVariant = StringUtil.decapitalize((String)oldVariant)) == 1) {
            newVariant = StringUtil.decapitalize((String)newVariant);
            return task2.replaceFirst(oldVariant, newVariant);
        }
        if (task2.contains(oldVariant = StringUtil.capitalize((String)oldVariant))) {
            newVariant = StringUtil.capitalize((String)newVariant);
            return task2.replaceFirst(oldVariant, newVariant);
        }
        return null;
    }

    private static String getTaskName(IdeVariant v, String targetType) {
        if (targetType.equals(BUNDLE)) {
            return v.getMainArtifact().getBuildInformation().getBundleTaskName();
        }
        return v.getMainArtifact().getBuildInformation().getAssembleTaskName();
    }

    protected void doNextAction() {
        if (!this.commitCurrentStep()) {
            return;
        }
        super.doNextAction();
    }

    private boolean commitCurrentStep() {
        try {
            ((ExportSignedPackageWizardStep)((Object)this.mySteps.get(this.myCurrentStep))).commitForNext();
        }
        catch (CommitStepException e) {
            Messages.showErrorDialog((Component)this.getContentPane(), (String)e.getMessage());
            return false;
        }
        return true;
    }

    protected int getNextStep(int stepIndex) {
        int result2 = super.getNextStep(stepIndex);
        if (result2 != this.myCurrentStep) {
            ((ExportSignedPackageWizardStep)((Object)this.mySteps.get(result2))).setPreviousStepIndex(this.myCurrentStep);
        }
        return result2;
    }

    protected int getPreviousStep(int stepIndex) {
        ExportSignedPackageWizardStep step2 = (ExportSignedPackageWizardStep)((Object)this.mySteps.get(stepIndex));
        int prevStepIndex = step2.getPreviousStepIndex();
        assert (prevStepIndex >= 0);
        return prevStepIndex;
    }

    protected void updateStep() {
        int step2 = this.getCurrentStep();
        ExportSignedPackageWizardStep currentStep = (ExportSignedPackageWizardStep)((Object)this.mySteps.get(step2));
        this.getFinishButton().setEnabled(currentStep.canFinish());
        super.updateStep();
        UIUtil.invokeLaterIfNeeded(() -> {
            this.getRootPane().setDefaultButton(this.getNextButton());
            JComponent component2 = currentStep.getPreferredFocusedComponent();
            if (component2 != null) {
                component2.requestFocus();
            }
        });
    }

    protected String getHelpID() {
        ExportSignedPackageWizardStep step2 = (ExportSignedPackageWizardStep)this.getCurrentStepObject();
        if (step2 != null) {
            return step2.getHelpId();
        }
        return null;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public void setFacet(@NotNull AndroidFacet facet2) {
        this.myFacet = facet2;
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    public void setPrivateKey(@NotNull PrivateKey privateKey) {
        this.myPrivateKey = privateKey;
    }

    public void setCertificate(@NotNull X509Certificate certificate) {
        this.myCertificate = certificate;
    }

    public PrivateKey getPrivateKey() {
        return this.myPrivateKey;
    }

    public X509Certificate getCertificate() {
        return this.myCertificate;
    }

    public void setCompileScope(@NotNull CompileScope compileScope) {
        this.myCompileScope = compileScope;
    }

    public void setApkPath(@NotNull String apkPath) {
        this.myApkPath = apkPath;
    }

    public void setGradleOptions(@NotNull List<String> buildVariants) {
        this.myBuildVariants = buildVariants;
    }

    public void setTargetType(@NotNull String targetType) {
        this.myTargetType = targetType;
    }

    @NotNull
    public String getTargetType() {
        return this.myTargetType;
    }

    @NotNull
    private File generatePrivateKeyPath() {
        return new File(this.myExportKeyPath, ENCRYPTED_PRIVATE_KEY_FILE);
    }

    public void setGradleSigningInfo(GradleSigningInfo gradleSigningInfo) {
        this.myGradleSigningInfo = gradleSigningInfo;
    }

    public void setExportPrivateKey(boolean exportPrivateKey) {
        this.myExportPrivateKey = exportPrivateKey;
    }

    public void setExportKeyPath(@NotNull String exportKeyPath) {
        this.myExportKeyPath = exportKeyPath;
    }
}

