/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.exportSignedPackage;

import com.google.common.base.Strings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.artifact.ProGuardConfigFilesPanel;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizard;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizardStep;
import org.jetbrains.android.exportSignedPackage.KeystoreStep;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.SaveFileListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

class ApkStep
extends ExportSignedPackageWizardStep {
    public static final String APK_PATH_PROPERTY = "ExportedApkPath";
    public static final String APK_PATH_PROPERTY_UNSIGNED = "ExportedUnsignedApkPath";
    public static final String RUN_PROGUARD_PROPERTY = "AndroidRunProguardForReleaseBuild";
    public static final String PROGUARD_CFG_PATHS_PROPERTY = "AndroidProguardConfigPaths";
    private TextFieldWithBrowseButton myApkPathField;
    private JPanel myContentPanel;
    private JLabel myApkPathLabel;
    private JCheckBox myProguardCheckBox;
    private ProGuardConfigFilesPanel myProGuardConfigFilesPanel;
    private final ExportSignedPackageWizard myWizard;
    private boolean myInited;
    private boolean myIsBundle;

    @Nullable
    private static String getContentRootPath(Module module2) {
        VirtualFile contentRoot;
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        if (contentRoots.length != 0 && (contentRoot = contentRoots[0]) != null) {
            return contentRoot.getPath();
        }
        return null;
    }

    public ApkStep(ExportSignedPackageWizard wizard) {
        this.myWizard = wizard;
        this.$$$setupUI$$$();
        this.myIsBundle = this.myWizard.getTargetType().equals("bundle");
        this.myApkPathLabel.setLabelFor((Component)this.myApkPathField);
        this.myApkPathField.getButton().addActionListener((ActionListener)new SaveFileListener(this.myContentPanel, this.myApkPathField, AndroidBundle.message("android.extract.package.choose.dest.apk", new Object[0]), "apk"){

            @Override
            protected String getDefaultLocation() {
                Module module2 = ApkStep.this.myWizard.getFacet().getModule();
                return ApkStep.getContentRootPath(module2);
            }
        });
        this.myProguardCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApkStep.this.myProGuardConfigFilesPanel.setEnabled(ApkStep.this.myProguardCheckBox.isSelected());
            }
        });
        this.myContentPanel.setPreferredSize(new Dimension(this.myContentPanel.getPreferredSize().width, JBUI.scale((int)250)));
    }

    public void _init() {
        String[] proguardCfgPaths;
        String runProguardPropValue;
        if (this.myInited) {
            return;
        }
        AndroidFacet facet2 = this.myWizard.getFacet();
        Module module2 = facet2.getModule();
        PropertiesComponent properties2 = PropertiesComponent.getInstance((Project)module2.getProject());
        String initialApkPath = this.getInitialPath(properties2, module2);
        if (!Strings.isNullOrEmpty((String)initialApkPath)) {
            this.myApkPathField.setText(FileUtil.toSystemDependentName((String)initialApkPath));
        }
        boolean selected = (runProguardPropValue = properties2.getValue(RUN_PROGUARD_PROPERTY)) != null ? Boolean.parseBoolean(runProguardPropValue) : facet2.getProperties().RUN_PROGUARD;
        this.myProguardCheckBox.setSelected(selected);
        this.myProGuardConfigFilesPanel.setEnabled(selected);
        String proguardCfgPathsStr = properties2.getValue(PROGUARD_CFG_PATHS_PROPERTY);
        String[] stringArray = proguardCfgPaths = proguardCfgPathsStr != null ? ApkStep.parseAndCheckProguardCfgPaths(proguardCfgPathsStr) : null;
        if (proguardCfgPaths != null && proguardCfgPaths.length > 0) {
            this.myProGuardConfigFilesPanel.setOsPaths(Arrays.asList(proguardCfgPaths));
        } else {
            AndroidFacetConfiguration configuration = (AndroidFacetConfiguration)facet2.getConfiguration();
            if (configuration.getState().RUN_PROGUARD) {
                this.myProGuardConfigFilesPanel.setUrls(facet2.getProperties().myProGuardCfgFiles);
            } else {
                ArrayList<String> urls = new ArrayList<String>();
                urls.add("file://%MODULE_SDK_HOME%/tools/proguard/proguard-android.txt");
                Pair<VirtualFile, Boolean> pair = AndroidCompileUtil.getDefaultProguardConfigFile(facet2);
                if (pair != null) {
                    urls.add(((VirtualFile)pair.getFirst()).getUrl());
                }
                this.myProGuardConfigFilesPanel.setUrls(urls);
            }
        }
        this.myInited = true;
    }

    @NotNull
    private static String[] parseAndCheckProguardCfgPaths(@NotNull String pathsStr) {
        if (pathsStr.isEmpty()) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] paths = pathsStr.split(File.pathSeparator);
        if (paths.length == 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        for (String path2 : paths) {
            if (LocalFileSystem.getInstance().refreshAndFindFileByPath(path2) != null) continue;
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        return paths;
    }

    @NotNull
    private static String mergeProguardCfgPathsToOneString(@NotNull Collection<String> paths) {
        StringBuilder builder2 = new StringBuilder();
        Iterator<String> it = paths.iterator();
        while (it.hasNext()) {
            builder2.append(it.next());
            if (!it.hasNext()) continue;
            builder2.append(File.pathSeparator);
        }
        return builder2.toString();
    }

    @VisibleForTesting
    String getApkPathPropertyName(String moduleName2) {
        return (this.myWizard.isSigned() ? APK_PATH_PROPERTY : APK_PATH_PROPERTY_UNSIGNED) + (String)(Strings.isNullOrEmpty((String)moduleName2) ? "" : "For" + moduleName2);
    }

    public JComponent getComponent() {
        return this.myContentPanel;
    }

    @Override
    protected boolean canFinish() {
        return true;
    }

    @Override
    public String getHelpId() {
        return "org.jetbrains.android.studio/publish/app-signing";
    }

    public void _commit(boolean finishChosen) throws CommitStepException {
        String apkPath = this.myApkPathField.getText().trim();
        if (apkPath.isEmpty()) {
            throw new CommitStepException(AndroidBundle.message("android.extract.package.specify.apk.path.error", new Object[0]));
        }
        AndroidFacet facet2 = this.myWizard.getFacet();
        PropertiesComponent properties2 = PropertiesComponent.getInstance((Project)this.myWizard.getProject());
        String moduleName2 = facet2 != null ? facet2.getModule().getName() : "";
        properties2.setValue(KeystoreStep.getModuleProperty(this.myIsBundle), moduleName2);
        properties2.setValue(this.getApkPathPropertyName(moduleName2), apkPath);
        File folder = new File(apkPath).getParentFile();
        if (folder == null) {
            throw new CommitStepException(AndroidBundle.message("android.cannot.create.file.error", apkPath));
        }
        try {
            if (!folder.exists()) {
                folder.mkdirs();
            }
        }
        catch (Exception e) {
            throw new CommitStepException(e.getMessage());
        }
        CompileScope compileScope = CompilerManager.getInstance((Project)this.myWizard.getProject()).createModuleCompileScope(facet2.getModule(), true);
        AndroidCompileUtil.setReleaseBuild(compileScope);
        properties2.setValue(RUN_PROGUARD_PROPERTY, Boolean.toString(this.myProguardCheckBox.isSelected()));
        if (this.myProguardCheckBox.isSelected()) {
            List<String> proguardOsCfgPaths = this.myProGuardConfigFilesPanel.getOsPaths();
            if (proguardOsCfgPaths.isEmpty()) {
                throw new CommitStepException(AndroidBundle.message("android.extract.package.specify.proguard.cfg.path.error", new Object[0]));
            }
            String proguardPathsStr = ApkStep.mergeProguardCfgPathsToOneString(proguardOsCfgPaths);
            properties2.setValue(PROGUARD_CFG_PATHS_PROPERTY, proguardPathsStr);
            for (String path2 : proguardOsCfgPaths) {
                if (new File(path2).isFile()) continue;
                throw new CommitStepException(AndroidBundle.message("android.cannot.find.file.error", path2));
            }
            compileScope.putUserData(AndroidCompileUtil.PROGUARD_CFG_PATHS_KEY, (Object)proguardPathsStr);
        }
        this.myWizard.setCompileScope(compileScope);
        this.myWizard.setApkPath(apkPath);
    }

    @Override
    protected void commitForNext() throws CommitStepException {
    }

    private void createUIComponents() {
        this.myProGuardConfigFilesPanel = new ProGuardConfigFilesPanel(){

            @Override
            @Nullable
            protected AndroidFacet getFacet() {
                return ApkStep.this.myWizard.getFacet();
            }
        };
    }

    @VisibleForTesting
    String getInitialPath(PropertiesComponent properties2, @NotNull Module module2) {
        String lastApkFolderPath = properties2.getValue(this.getApkPathPropertyName(module2.getName()));
        if (!Strings.isNullOrEmpty((String)lastApkFolderPath)) {
            return lastApkFolderPath;
        }
        String contentRootPath = ApkStep.getContentRootPath(module2);
        if (contentRootPath != null) {
            return contentRootPath + File.separator + module2.getName() + ".apk";
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myApkPathLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.export.package.destination.akp.label"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myApkPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, new Dimension(100, -1), new Dimension(300, -1), null));
        this.myProguardCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.export.package.run.proguard.label"));
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        ProGuardConfigFilesPanel proGuardConfigFilesPanel = this.myProGuardConfigFilesPanel;
        jPanel.add((Component)proGuardConfigFilesPanel, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 3, null, null, null, 2));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

