/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.wrappers;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.wrappers.ResourceElementWrapper;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueResourceElementWrapper
implements XmlAttributeValue,
ResourceElementWrapper,
PsiNamedElement,
PsiElementNavigationItem {
    @NotNull
    private final XmlAttributeValue myWrappedElement;
    @Nullable
    private final String myFileName;
    @Nullable
    private final String myDirName;

    public ValueResourceElementWrapper(@NotNull XmlAttributeValue wrappedElement) {
        if (!(wrappedElement instanceof NavigationItem)) {
            throw new IllegalArgumentException();
        }
        if (!(wrappedElement instanceof PsiMetaOwner)) {
            throw new IllegalArgumentException();
        }
        this.myWrappedElement = wrappedElement;
        PsiFile file2 = this.getContainingFile();
        this.myFileName = file2 != null ? file2.getName() : null;
        PsiDirectory dir = file2 != null ? file2.getContainingDirectory() : null;
        this.myDirName = dir != null ? dir.getName() : null;
    }

    @Override
    @NotNull
    public PsiElement getWrappedElement() {
        return this.myWrappedElement;
    }

    @NotNull
    public Project getProject() throws PsiInvalidElementAccessException {
        return this.myWrappedElement.getProject();
    }

    @NotNull
    public Language getLanguage() {
        return this.myWrappedElement.getLanguage();
    }

    public PsiManager getManager() {
        return this.myWrappedElement.getManager();
    }

    @NotNull
    public PsiElement[] getChildren() {
        return this.myWrappedElement.getChildren();
    }

    public PsiElement getParent() {
        return this.myWrappedElement.getParent();
    }

    @Nullable
    public PsiElement getFirstChild() {
        return this.myWrappedElement.getFirstChild();
    }

    @Nullable
    public PsiElement getLastChild() {
        return this.myWrappedElement.getLastChild();
    }

    @Nullable
    public PsiElement getNextSibling() {
        return this.myWrappedElement.getNextSibling();
    }

    @Nullable
    public PsiElement getPrevSibling() {
        return this.myWrappedElement.getPrevSibling();
    }

    public PsiFile getContainingFile() throws PsiInvalidElementAccessException {
        return this.myWrappedElement.getContainingFile();
    }

    public TextRange getTextRange() {
        return this.myWrappedElement.getTextRange();
    }

    public int getStartOffsetInParent() {
        return this.myWrappedElement.getStartOffsetInParent();
    }

    public int getTextLength() {
        return this.myWrappedElement.getTextLength();
    }

    @Nullable
    public PsiElement findElementAt(int offset) {
        return this.myWrappedElement.findElementAt(offset);
    }

    @Nullable
    public PsiReference findReferenceAt(int offset) {
        return this.myWrappedElement.findReferenceAt(offset);
    }

    public int getTextOffset() {
        return this.myWrappedElement.getTextOffset();
    }

    @NonNls
    public String getText() {
        return this.myWrappedElement.getText();
    }

    @NotNull
    public char[] textToCharArray() {
        return this.myWrappedElement.textToCharArray();
    }

    public PsiElement getNavigationElement() {
        return this.myWrappedElement.getNavigationElement();
    }

    public PsiElement getOriginalElement() {
        return this.myWrappedElement.getOriginalElement();
    }

    public boolean textMatches(@NotNull @NonNls CharSequence text2) {
        return this.myWrappedElement.textMatches(text2);
    }

    public boolean textMatches(@NotNull PsiElement element2) {
        return this.myWrappedElement.textMatches(element2);
    }

    public boolean textContains(char c) {
        return this.myWrappedElement.textContains(c);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        this.myWrappedElement.accept(visitor2);
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor2) {
        this.myWrappedElement.acceptChildren(visitor2);
    }

    public PsiElement copy() {
        return this.myWrappedElement.copy();
    }

    public PsiElement add(@NotNull PsiElement element2) throws IncorrectOperationException {
        return this.myWrappedElement.add(element2);
    }

    public PsiElement addBefore(@NotNull PsiElement element2, PsiElement anchor) throws IncorrectOperationException {
        return this.myWrappedElement.addBefore(element2, anchor);
    }

    public PsiElement addAfter(@NotNull PsiElement element2, PsiElement anchor) throws IncorrectOperationException {
        return this.myWrappedElement.addAfter(element2, anchor);
    }

    public void checkAdd(@NotNull PsiElement element2) throws IncorrectOperationException {
        this.myWrappedElement.checkAdd(element2);
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return this.myWrappedElement.addRange(first, last);
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return this.myWrappedElement.addRangeBefore(first, last, anchor);
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        return this.myWrappedElement.addRangeAfter(first, last, anchor);
    }

    public void delete() throws IncorrectOperationException {
        this.myWrappedElement.delete();
    }

    public void checkDelete() throws IncorrectOperationException {
        this.myWrappedElement.checkDelete();
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        this.myWrappedElement.deleteChildRange(first, last);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        return this.myWrappedElement.replace(newElement);
    }

    public boolean isValid() {
        return this.myWrappedElement.isValid();
    }

    public boolean isWritable() {
        return this.myWrappedElement.isWritable();
    }

    @Nullable
    public PsiReference getReference() {
        return this.myWrappedElement.getReference();
    }

    @NotNull
    public PsiReference[] getReferences() {
        return this.myWrappedElement.getReferences();
    }

    @Nullable
    public <T> T getCopyableUserData(Key<T> key) {
        return (T)this.myWrappedElement.getCopyableUserData(key);
    }

    public <T> void putCopyableUserData(Key<T> key, T value2) {
        this.myWrappedElement.putCopyableUserData(key, value2);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        return this.myWrappedElement.processDeclarations(processor, state2, lastParent, place);
    }

    @Nullable
    public PsiElement getContext() {
        return this.myWrappedElement.getContext();
    }

    public boolean isPhysical() {
        return false;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        return this.myWrappedElement.getResolveScope();
    }

    @NotNull
    public SearchScope getUseScope() {
        return this.myWrappedElement.getUseScope();
    }

    @Nullable
    public ASTNode getNode() {
        return this.myWrappedElement.getNode();
    }

    @NonNls
    public String toString() {
        return this.myWrappedElement.toString();
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (another instanceof ResourceElementWrapper) {
            another = ((ResourceElementWrapper)another).getWrappedElement();
        }
        return this.myWrappedElement == another || this.myWrappedElement.isEquivalentTo(another);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueResourceElementWrapper that = (ValueResourceElementWrapper)o;
        return this.myWrappedElement.equals(that.myWrappedElement);
    }

    public int hashCode() {
        return this.myWrappedElement.hashCode();
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myWrappedElement.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        this.myWrappedElement.putUserData(key, value2);
    }

    public Icon getIcon(int flags) {
        return this.myWrappedElement.getIcon(flags);
    }

    public String getName() {
        String value2 = this.myWrappedElement.getValue();
        if (value2.startsWith("@+id/")) {
            return IdeResourcesUtil.getResourceNameByReferenceText(value2);
        }
        return ((NavigationItem)this.myWrappedElement).getName();
    }

    @Nullable
    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        if (IdeResourcesUtil.isIdDeclaration(this.myWrappedElement)) {
            XmlAttribute attribute2 = (XmlAttribute)this.myWrappedElement.getParent();
            attribute2.setValue(name2);
        } else if (this.myWrappedElement.isValid()) {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myWrappedElement, XmlTag.class);
            DomElement domElement = DomManager.getDomManager((Project)this.getProject()).getDomElement(tag);
            assert (domElement instanceof ResourceElement || domElement instanceof Attr);
            if (domElement instanceof ResourceElement) {
                ResourceElement resElement = (ResourceElement)domElement;
                resElement.getName().setValue((Object)name2);
            } else {
                Attr attr = (Attr)domElement;
                ResourceReference resourceReference = (ResourceReference)attr.getName().getValue();
                assert (resourceReference != null);
                attr.getName().setValue((Object)new ResourceReference(resourceReference.getNamespace(), resourceReference.getResourceType(), name2));
            }
        }
        return null;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                String name2 = ((NavigationItem)ValueResourceElementWrapper.this.myWrappedElement).getName();
                if (ValueResourceElementWrapper.this.myDirName == null || ValueResourceElementWrapper.this.myFileName == null) {
                    return name2;
                }
                return name2 + " (..." + File.separatorChar + ValueResourceElementWrapper.this.myDirName + File.separatorChar + ValueResourceElementWrapper.this.myFileName + ")";
            }

            public Icon getIcon(boolean open2) {
                return null;
            }
        };
    }

    public void navigate(boolean requestFocus) {
        ((NavigationItem)this.myWrappedElement).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return ((NavigationItem)this.myWrappedElement).canNavigate();
    }

    public boolean canNavigateToSource() {
        return ((NavigationItem)this.myWrappedElement).canNavigateToSource();
    }

    @NotNull
    public String getValue() {
        return this.myWrappedElement.getValue();
    }

    public TextRange getValueTextRange() {
        return this.myWrappedElement.getValueTextRange();
    }

    public boolean processElements(PsiElementProcessor processor, PsiElement place) {
        return this.myWrappedElement.processElements(processor, place);
    }

    public PsiElement getTargetElement() {
        return this.getWrappedElement();
    }
}

