/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.structure.layout;

import com.google.common.base.Joiner;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.layout.Fragment;
import org.jetbrains.android.dom.layout.Include;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.structure.StructureUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutStructureViewBuilder
extends TreeBasedStructureViewBuilder {
    private final DomFileElement<LayoutViewElement> myElement;

    public LayoutStructureViewBuilder(@NotNull DomFileElement<LayoutViewElement> element2) {
        this.myElement = element2;
    }

    @NotNull
    public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
        return new StructureViewModelBase((PsiFile)this.myElement.getFile(), (StructureViewTreeElement)new LayoutNode((LayoutViewElement)this.myElement.getRootElement()));
    }

    private static class LayoutNode
    extends PsiTreeElementBase<XmlTag> {
        private final LayoutViewElement myElement;

        public LayoutNode(@NotNull LayoutViewElement element2) {
            super((PsiElement)element2.getXmlTag());
            this.myElement = element2;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            final ArrayList<StructureViewTreeElement> result2 = new ArrayList<StructureViewTreeElement>();
            DomElementVisitor visitor2 = new DomElementVisitor(){

                public void visitLayoutViewElement(LayoutViewElement element2) {
                    result2.add(new LayoutNode(element2));
                }

                public void visitFragment(Fragment element2) {
                    result2.add(new FragmentNode(element2));
                }

                public void visitInclude(Include element2) {
                    result2.add(new IncludeNode(element2));
                }

                public void visitDomElement(DomElement element2) {
                }
            };
            StructureUtils.acceptChildrenInOrder(this.myElement, visitor2);
            return result2;
        }

        public Icon getIcon(boolean open2) {
            XmlTag tag = this.myElement.getXmlTag();
            if (tag == null) {
                return null;
            }
            return AndroidDomElementDescriptorProvider.getIconForViewTag(tag.getName());
        }

        public String getLocationString() {
            XmlTag xmlTag = this.myElement.getXmlTag();
            XmlAttribute idAttribute = xmlTag == null ? null : xmlTag.getAttribute("id", "http://schemas.android.com/apk/res/android");
            return idAttribute == null ? null : idAttribute.getValue();
        }

        public boolean isSearchInLocationString() {
            return true;
        }

        @NotNull
        public String getPresentableText() {
            XmlTag xmlTag = this.myElement.getXmlTag();
            if (xmlTag == null) {
                return "";
            }
            String className = xmlTag.getName();
            return className.substring(className.lastIndexOf(46) + 1);
        }

        public String toString() {
            StringBuilder builder2 = new StringBuilder();
            this.dumpIndented(builder2, 0);
            return builder2.toString();
        }

        private void dumpIndented(@NotNull StringBuilder builder2, int indentLevel) {
            for (int i = 0; i < indentLevel; ++i) {
                builder2.append("  ");
            }
            builder2.append(this.getPresentableText());
            String locationString = this.getLocationString();
            if (locationString != null) {
                builder2.append(" (").append(locationString).append(")");
            }
            builder2.append('\n');
            for (StructureViewTreeElement element2 : this.getChildrenBase()) {
                if (element2 instanceof LayoutNode) {
                    ((LayoutNode)element2).dumpIndented(builder2, indentLevel + 1);
                    continue;
                }
                for (int i = 0; i < indentLevel + 1; ++i) {
                    builder2.append("  ");
                }
                builder2.append(element2.toString()).append("\n");
            }
        }
    }

    private static class IncludeNode
    extends PsiTreeElementBase<XmlTag> {
        private final Include myElement;

        private IncludeNode(@NotNull Include element2) {
            super((PsiElement)element2.getXmlTag());
            this.myElement = element2;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            return Collections.emptyList();
        }

        @Nullable
        public String getPresentableText() {
            Object result2 = "Include";
            String text2 = this.myElement.getLayout().getRawText();
            if (text2 != null) {
                result2 = (String)result2 + " " + text2;
            }
            return result2;
        }

        public Icon getIcon(boolean open2) {
            return StudioIcons.LayoutEditor.Palette.INCLUDE;
        }

        public String toString() {
            return this.getPresentableText();
        }
    }

    private static class FragmentNode
    extends PsiTreeElementBase<XmlTag> {
        private final Fragment myElement;

        public FragmentNode(@NotNull Fragment element2) {
            super((PsiElement)element2.getXmlTag());
            this.myElement = element2;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            return Collections.emptyList();
        }

        public Icon getIcon(boolean open2) {
            return StudioIcons.LayoutEditor.Palette.FRAGMENT;
        }

        @Nullable
        public String getPresentableText() {
            return Joiner.on((String)" ").skipNulls().join((Object)"Fragment", (Object)this.myElement.getFragmentName().getRawText(), new Object[0]);
        }

        public String toString() {
            return this.getPresentableText();
        }
    }
}

