/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.inspections;

import com.android.resources.ResourceFolderType;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.dom.navigation.NavClassHelperKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0017J\b\u0010\u000f\u001a\u00020\u000eH\u0017J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/android/dom/inspections/NavFileInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "getDisplayName", "", "getGroupDisplayName", "getShortName", "isRelevantFile", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "Lcom/intellij/psi/xml/XmlFile;", "AttributesVisitor", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nNavFileInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavFileInspection.kt\norg/jetbrains/android/dom/inspections/NavFileInspection\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,96:1\n37#2,2:97\n*S KotlinDebug\n*F\n+ 1 NavFileInspection.kt\norg/jetbrains/android/dom/inspections/NavFileInspection\n*L\n55#1:97,2\n*E\n"})
public final class NavFileInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = AndroidBundle.message("android.inspections.group.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"android.inspections.group.name\")");
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = AndroidBundle.message("android.inspections.nav.file", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"android.inspections.nav.file\")");
        return string;
    }

    @NotNull
    public String getShortName() {
        return "NavigationFile";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!(file2 instanceof XmlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((PsiElement)((PsiElement)file2));
        if (androidFacet == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        AndroidFacet facet2 = androidFacet;
        if (this.isRelevantFile(facet2, (XmlFile)file2)) {
            Module module2 = facet2.getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
            AttributesVisitor visitor2 = new AttributesVisitor(module2, manager, isOnTheFly);
            file2.accept((PsiElementVisitor)visitor2);
            Collection $this$toTypedArray$iv = visitor2.getMyResult();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new ProblemDescriptor[0]);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private final boolean isRelevantFile(AndroidFacet facet2, XmlFile file2) {
        ResourceFolderType resourceType = ModuleResourceManagers.getInstance(facet2).getLocalResourceManager().getFileResourceFolderType((PsiFile)file2);
        return resourceType == ResourceFolderType.NAVIGATION;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/android/dom/inspections/NavFileInspection$AttributesVisitor;", "Lcom/intellij/psi/XmlRecursiveElementVisitor;", "module", "Lcom/intellij/openapi/module/Module;", "myInspectionManager", "Lcom/intellij/codeInspection/InspectionManager;", "myOnTheFly", "", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/codeInspection/InspectionManager;Z)V", "myResult", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getMyResult", "()Ljava/util/List;", "visitXmlAttribute", "", "attribute", "Lcom/intellij/psi/xml/XmlAttribute;", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nNavFileInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavFileInspection.kt\norg/jetbrains/android/dom/inspections/NavFileInspection$AttributesVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,96:1\n1549#2:97\n1620#2,3:98\n26#3:101\n*S KotlinDebug\n*F\n+ 1 NavFileInspection.kt\norg/jetbrains/android/dom/inspections/NavFileInspection$AttributesVisitor\n*L\n80#1:97\n80#1:98,3\n88#1:101\n*E\n"})
    private static final class AttributesVisitor
    extends XmlRecursiveElementVisitor {
        @NotNull
        private final Module module;
        @NotNull
        private final InspectionManager myInspectionManager;
        private final boolean myOnTheFly;
        @NotNull
        private final List<ProblemDescriptor> myResult;

        public AttributesVisitor(@NotNull Module module2, @NotNull InspectionManager myInspectionManager, boolean myOnTheFly) {
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            Intrinsics.checkNotNullParameter((Object)myInspectionManager, (String)"myInspectionManager");
            this.module = module2;
            this.myInspectionManager = myInspectionManager;
            this.myOnTheFly = myOnTheFly;
            this.myResult = new ArrayList();
        }

        @NotNull
        public final List<ProblemDescriptor> getMyResult() {
            return this.myResult;
        }

        /*
         * WARNING - void declaration
         */
        public void visitXmlAttribute(@NotNull XmlAttribute attribute2) {
            block4: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)attribute2, (String)"attribute");
                super.visitXmlAttribute(attribute2);
                String string = attribute2.getNamespace();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attribute.namespace");
                String namespace = string;
                if (!Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)namespace) || !Intrinsics.areEqual((Object)"name", (Object)attribute2.getLocalName())) {
                    return;
                }
                XmlTag tag = attribute2.getParent();
                String string2 = attribute2.getValue();
                if (string2 == null) {
                    string2 = "";
                }
                String value2 = string2;
                String string3 = tag.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"tag.name");
                Iterable $this$map$iv = NavClassHelperKt.getClassesForTag(this.module, string3).keySet();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PsiClass psiClass = (PsiClass)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(it.getQualifiedName());
                }
                Set allowedDestinations = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                if (allowedDestinations.contains(value2)) break block4;
                XmlAttributeValue xmlAttributeValue = attribute2.getValueElement();
                if (xmlAttributeValue != null) {
                    XmlAttributeValue it = xmlAttributeValue;
                    boolean bl = false;
                    Object[] $i$f$mapTo2 = new Object[]{value2, tag.getName()};
                    boolean $i$f$emptyArray = false;
                    ProblemDescriptor problemDescriptor = this.myInspectionManager.createProblemDescriptor((PsiElement)it, AndroidBundle.message("android.inspections.nav.name.not.valid", $i$f$mapTo2), this.myOnTheFly, new LocalQuickFix[0], ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
                    Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"myInspectionManager.crea\u2026NOWN_SYMBOL\n            )");
                    this.myResult.add(problemDescriptor);
                }
            }
        }
    }
}

