/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.inspections;

import com.android.support.AndroidxNameUtils;
import com.android.tools.idea.imports.AndroidMavenImportFix;
import com.android.tools.idea.imports.MavenClassRegistryBase;
import com.android.tools.idea.imports.MavenClassRegistryManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a8\u0006\b"}, d2={"collectFixesFromMavenClassRegistry", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/android/tools/idea/imports/MavenClassRegistryManager;", "className", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.core"})
@JvmName(name="MavenClassResolverUtils")
public final class MavenClassResolverUtils {
    @NotNull
    public static final Collection<LocalQuickFix> collectFixesFromMavenClassRegistry(@NotNull MavenClassRegistryManager $this$collectFixesFromMavenClassRegistry, @NotNull String className, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$collectFixesFromMavenClassRegistry, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List fixes = new ArrayList();
        boolean useAndroidX2 = MigrateToAndroidxUtil.isAndroidx(project);
        SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$collectFixesFromMavenClassRegistry.getMavenClassRegistry().findLibraryData(className, useAndroidX2)), (Function1)((Function1)new Function1<MavenClassRegistryBase.Library, Boolean>(useAndroidX2, (List<LocalQuickFix>)fixes, className){
            final /* synthetic */ boolean $useAndroidX;
            final /* synthetic */ List<LocalQuickFix> $fixes;
            final /* synthetic */ String $className;
            {
                this.$useAndroidX = $useAndroidX;
                this.$fixes = $fixes;
                this.$className = $className;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull MavenClassRegistryBase.Library it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String resolvedArtifact = this.$useAndroidX ? AndroidxNameUtils.getCoordinateMapping((String)it.getArtifact()) : it.getArtifact();
                Intrinsics.checkNotNullExpressionValue((Object)resolvedArtifact, (String)"resolvedArtifact");
                return this.$fixes.add(new AndroidMavenImportFix(this.$className, resolvedArtifact, it.getVersion()));
            }
        })));
        return CollectionsKt.toList((Iterable)fixes);
    }
}

